/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.schedule.util;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;

import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;

import com.aimluck.commons.field.ALCellStringField;
import com.aimluck.eip.cayenne.om.portlet.EipTSchedule;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.schedule.ScheduleConst;
import com.aimluck.eip.schedule.ScheduleDayContainer;
import com.aimluck.eip.schedule.ScheduleResultData;
import com.aimluck.eip.schedule.ScheduleWeekContainer;
import com.aimluck.eip.util.ALEipUtils;

/**
 * スケジュールのユーティリティクラスです。
 * 
 */
public class CellScheduleUtils {

  /** <code>FLAG_EDIT_REPEAT_DEF</code> デフォルト値（繰り返し編集範囲） */
  public static final int FLAG_EDIT_REPEAT_DEF = -1;

  /** <code>FLAG_EDIT_REPEAT_ALL</code> 個別日程を編集（繰り返し編集範囲） */
  public static final int FLAG_EDIT_REPEAT_ALL = 0;

  /** <code>FLAG_EDIT_SCHEDULE_ONE</code> 全日程を編集（繰り返し編集範囲） */
  public static final int FLAG_EDIT_REPEAT_ONE = 1;

  /** <code>FLAG_DEL_MEMBER_ALL</code> [削除フラグ] すべての共有メンバーからこのスケジュールを削除する */
  public static final int FLAG_DEL_MEMBER_ALL = 0;

  /** <code>FLAG_DEL_MEMBER_ONE</code> [削除フラグ] このスケジュールからログインユーザーだけを削除する */
  public static final int FLAG_DEL_MEMBER_ONE = 1;

  /** <code>FLAG_DEL_RANGE_ALL</code> [削除フラグ] この繰り返しスケジュールを削除する */
  public static final int FLAG_DEL_RANGE_ALL = 0;

  /** <code>FLAG_DEL_RANGE_ONE</code> [削除フラグ] この繰り返しスケジュールの特定スケジュールのみを削除する */
  public static final int FLAG_DEL_RANGE_ONE = 1;

  /** スケジュールタイプ（一日） */
  public static final String SCHEDULE_TYPE_ONEDAY = "O";

  /** スケジュールタイプ（繰り返し） */
  public static final String SCHEDULE_TYPE_REPEAT = "R";

  /** スケジュールタイプ（期間） */
  public static final String SCHEDULE_TYPE_SPAN = "S";

  // add start
  /** スケジュールタイプ（日またぎ） */
  public static final String SCHEDULE_TYPE_CROSS_OVER = "Z";

  // add end
  /** <code>logger</code> loger */
  @SuppressWarnings("unused")
  private static final JetspeedLogger logger =
    JetspeedLogFactoryService.getLogger(CellScheduleUtils.class.getName());

  // add start
  /**
   * スケジュールのタイプを取得します。
   * 
   * @param scheduleオブジェクト
   * @return String スケジュールタイプ： 期間スケジュール = "S" 日またぎスケジュール = "Z" 単発スケジュール = "O"
   *         繰り返しスケジュール = "R"
   */
  // add end
  public static String getScheduleType(EipTSchedule schedule) {
    String ptn = schedule.getRepeatPattern();
    // change start
    // 繰り返しスケジュール対応
    // if (ptn.charAt(0) == 'S') {
    // return SCHEDULE_TYPE_SPAN;
    // } else if (ptn.charAt(0) == 'D'
    // || ptn.charAt(0) == 'M'
    // || ptn.charAt(0) == 'W') {
    // return SCHEDULE_TYPE_REPEAT;
    // }
    // return SCHEDULE_TYPE_ONEDAY;
    if (ptn.charAt(0) == 'S') {
      return SCHEDULE_TYPE_SPAN;
    } else if (ptn.charAt(0) == 'Z') {
      return SCHEDULE_TYPE_CROSS_OVER;
    } else if (ptn.charAt(0) == 'N') {
      return SCHEDULE_TYPE_ONEDAY;
    }
    return SCHEDULE_TYPE_REPEAT;
    // change end
  }

  public static List<ALEipUser> getShareUserMemberList(RunData rundata) {
    List<ALEipUser> memberList = new ArrayList<ALEipUser>();
    ALEipUser login_user = ALEipUtils.getALEipUser(rundata);
    // add start
    if (rundata.getParameters().containsKey("from_schedule_list")) {
      memberList.add(login_user);
    }
    // add end
    ALEipUser user = null;
    String str[] = rundata.getParameters().getStrings("shareuser");
    if (str != null && str.length > 0) {
      SelectQuery<TurbineUser> query = Database.query(TurbineUser.class);
      Expression exp =
        ExpressionFactory.inExp(TurbineUser.LOGIN_NAME_PROPERTY, str);
      query.setQualifier(exp);
      List<ALEipUser> sharuserlist = ALEipUtils.getUsersFromSelectQuery(query);
      int sharuserSize = sharuserlist.size();
      for (int i = 0; i < sharuserSize; i++) {
        user = sharuserlist.get(i);
        if (!ScheduleUtils.isContains(memberList, user)) {
          memberList.add(user);
        }
      }
    }

    String shareusers = rundata.getParameters().getString("shareusers");
    if (shareusers != null && shareusers.length() > 0) {
      List<String> list = new ArrayList<String>();
      String token = null;
      StringTokenizer st = new StringTokenizer(shareusers, ",");
      while (st.hasMoreTokens()) {
        token = st.nextToken();
        if (token != null) {
          list.add(token.trim());
        }
      }
      str = new String[list.size()];
      str = list.toArray(str);

      SelectQuery<TurbineUser> query = Database.query(TurbineUser.class);
      Expression exp =
        ExpressionFactory.inExp(TurbineUser.LOGIN_NAME_PROPERTY, str);
      query.setQualifier(exp);
      List<ALEipUser> sharuserslist = ALEipUtils.getUsersFromSelectQuery(query);
      int sharusersSize = sharuserslist.size();
      for (int i = 0; i < sharusersSize; i++) {
        user = sharuserslist.get(i);
        if (!ScheduleUtils.isContains(memberList, user)) {
          memberList.add(user);
        }
      }
      // if (!ScheduleUtils.isContains(memberList, login_user)) {
      // memberList.add(login_user);
      // }
    }

    return memberList;
  }

  // add start
  /**
   * 参加ユーザー(任意)のリスト
   * 
   * @param rundata
   * @return
   */
  public static List<ALEipUser> getShareUserSubMemberList(RunData rundata) {
    List<ALEipUser> memberList = new ArrayList<ALEipUser>();

    ALEipUser user = null;
    String str[] = rundata.getParameters().getStrings("sub-shareuser");
    if (str != null && str.length > 0) {
      SelectQuery<TurbineUser> query = Database.query(TurbineUser.class);
      Expression exp =
        ExpressionFactory.inExp(TurbineUser.LOGIN_NAME_PROPERTY, str);
      query.setQualifier(exp);
      List<ALEipUser> sharuserlist = ALEipUtils.getUsersFromSelectQuery(query);
      int sharuserSize = sharuserlist.size();
      for (int i = 0; i < sharuserSize; i++) {
        user = sharuserlist.get(i);
        if (!ScheduleUtils.isContains(memberList, user)) {
          memberList.add(user);
        }
      }
    }

    String shareusers = rundata.getParameters().getString("sub-shareusers");
    if (shareusers != null && shareusers.length() > 0) {
      List<String> list = new ArrayList<String>();
      String token = null;
      StringTokenizer st = new StringTokenizer(shareusers, ",");
      while (st.hasMoreTokens()) {
        token = st.nextToken();
        if (token != null) {
          list.add(token.trim());
        }
      }
      str = new String[list.size()];
      str = list.toArray(str);

      SelectQuery<TurbineUser> query = Database.query(TurbineUser.class);
      Expression exp =
        ExpressionFactory.inExp(TurbineUser.LOGIN_NAME_PROPERTY, str);
      query.setQualifier(exp);
      List<ALEipUser> sharuserslist = ALEipUtils.getUsersFromSelectQuery(query);
      int sharusersSize = sharuserslist.size();
      for (int i = 0; i < sharusersSize; i++) {
        user = sharuserslist.get(i);
        if (!ScheduleUtils.isContains(memberList, user)) {
          memberList.add(user);
        }
      }
    }

    return memberList;
  }

  /**
   * PC用にフォーマットした 繰り返しタイプを取得します。
   * 
   * @return
   */
  public static ALCellStringField getRepeatTypeForValidate(String repeat_type) {
    ALCellStringField repeat_type_forValidate = new ALCellStringField();
    // 携帯入力画面値の繰り返しタイプを バリデーション用にフォーマットします。
    if (ScheduleConst.CELL_REPEAT_TYPE_DAY.equals(repeat_type)) {
      repeat_type_forValidate.setValue(ScheduleConst.REPEAT_TYPE_DAY);
    } else if (ScheduleConst.CELL_REPEAT_TYPE_WEEK.equals(repeat_type)) {
      repeat_type_forValidate.setValue(ScheduleConst.REPEAT_TYPE_WEEK);
    } else if (ScheduleConst.CELL_REPEAT_TYPE_MONTH_DAY.equals(repeat_type)) {
      repeat_type_forValidate.setValue(ScheduleConst.REPEAT_TYPE_MONTH);
    } else if (ScheduleConst.CELL_REPEAT_TYPE_MONTH_WEEK.equals(repeat_type)) {
      repeat_type_forValidate.setValue(ScheduleConst.REPEAT_TYPE_MONTH);
    } else if (ScheduleConst.CELL_REPEAT_TYPE_YEAR_MONTH.equals(repeat_type)) {
      repeat_type_forValidate.setValue(ScheduleConst.REPEAT_TYPE_YEAR);
    } else if (ScheduleConst.CELL_REPEAT_TYPE_YEAR_WEEK.equals(repeat_type)) {
      repeat_type_forValidate.setValue(ScheduleConst.REPEAT_TYPE_YEAR);
    }
    return repeat_type_forValidate;
  }

  /**
   * PC用にフォーマットした 月タイプを取得します。
   * 
   * @return
   */
  public static ALCellStringField getMonthTypeForValidate(String repeat_type) {
    ALCellStringField month_type_forValidate = new ALCellStringField();
    if (ScheduleConst.CELL_REPEAT_TYPE_MONTH_DAY.equals(repeat_type)) {
      month_type_forValidate.setValue(ScheduleConst.MONTH_TYPE_MD);
    } else if (ScheduleConst.CELL_REPEAT_TYPE_MONTH_WEEK.equals(repeat_type)) {
      month_type_forValidate.setValue(ScheduleConst.MONTH_TYPE_MW);
    }
    return month_type_forValidate;
  }

  /**
   * PC用にフォーマットした 年タイプを取得します。
   * 
   * @return
   */
  public static ALCellStringField getYearTypeForValidate(String repeat_type) {
    ALCellStringField year_type_forValidate = new ALCellStringField();
    if (ScheduleConst.CELL_REPEAT_TYPE_YEAR_MONTH.equals(repeat_type)) {
      year_type_forValidate.setValue(ScheduleConst.YEAR_TYPE_MD);
    } else if (ScheduleConst.CELL_REPEAT_TYPE_YEAR_WEEK.equals(repeat_type)) {
      year_type_forValidate.setValue(ScheduleConst.YEAR_TYPE_MW);
    }
    return year_type_forValidate;
  }

  /**
   * 週間スケジュールコンテナを同一日付内で開始時刻順にソートします。
   * 
   * @param 週間スケジュールコンテナ
   * @return 週間スケジュールコンテナ
   */
  public static ScheduleWeekContainer sortByStartTime(
      ScheduleWeekContainer weekCon) {
    int size = weekCon.getDayList().size();
    try {
      for (int i = 0; i < size; i++) {
        final ScheduleDayContainer con = weekCon.getDayList().get(i);
        List<ScheduleResultData> list = con.getScheduleList();

        // ソート
        Collections.sort(list, new Comparator<ScheduleResultData>() {

          public int compare(ScheduleResultData a, ScheduleResultData b) {

            // 時刻比較用Calendar
            Calendar cal = Calendar.getInstance();
            Calendar cal2 = Calendar.getInstance();

            // 初期化
            ScheduleResultData p1 = null;
            ScheduleResultData p2 = null;
            p1 = a;
            p2 = b;

            // 期間スケジュールを先頭に表示
            if (p1.getPattern().equals("S")) {
              if (!p2.getPattern().equals("S")) {
                return -1;
              }
            } else {
              if (p2.getPattern().equals("S")) {
                return 1;
              }
            }
            cal.setTime(p1.getStartDate().getValue());
            cal.set(0, 0, 0);
            cal2.setTime(p2.getStartDate().getValue());
            cal2.set(0, 0, 0);

            if ((cal.getTime()).compareTo(cal2.getTime()) != 0) {
              return (cal.getTime()).compareTo(cal2.getTime());
            } else {
              cal.setTime(p1.getEndDate().getValue());
              cal.set(0, 0, 0);
              cal2.setTime(p2.getEndDate().getValue());
              cal2.set(0, 0, 0);
              return (cal.getTime()).compareTo(cal2.getTime());
            }
          }

        });
      }
    } catch (Exception ex) {
      logger.error("(携帯・スマートフォン)週間カレンダー時刻ソート処理に失敗しました", ex);
      return null;
    }
    return weekCon;
  }
  // add end

  // remove start
  // 未使用
  // public static List<FacilityResultData> getShareFacilityMemberList(
  // RunData rundata) {
  // List<FacilityResultData> facilityMemberList =
  // new ArrayList<FacilityResultData>();
  // FacilityResultData f_record = null;
  // String facstr[] = rundata.getParameters().getStrings("sharefac");
  // if (facstr != null && facstr.length > 0) {
  // SelectQuery<EipMFacility> fquery = Database.query(EipMFacility.class);
  // Expression fexp =
  // ExpressionFactory.inDbExp(EipMFacility.FACILITY_ID_PK_COLUMN, facstr);
  // fquery.setQualifier(fexp);
  // List<FacilityResultData> f_list =
  // FacilitiesUtils.getFacilitiesFromSelectQuery(fquery);
  // int f_list_size = f_list.size();
  // for (int i = 0; i < f_list_size; i++) {
  // f_record = f_list.get(i);
  // if (!FacilitiesUtils.isContains(facilityMemberList, f_record)) {
  // facilityMemberList.add(f_record);
  // }
  // }
  // }
  //
  // String sharefacs = rundata.getParameters().getString("sharefacs");
  // if (sharefacs != null && sharefacs.length() > 0) {
  // List<String> list = new ArrayList<String>();
  // String token = null;
  // StringTokenizer st = new StringTokenizer(sharefacs, ",");
  // while (st.hasMoreTokens()) {
  // token = st.nextToken();
  // if (token != null) {
  // list.add(token.trim());
  // }
  // }
  // String[] str = new String[list.size()];
  // str = list.toArray(str);
  //
  // SelectQuery<EipMFacility> fquery = Database.query(EipMFacility.class);
  // Expression fexp =
  // ExpressionFactory.inDbExp(EipMFacility.FACILITY_ID_PK_COLUMN, str);
  // fquery.setQualifier(fexp);
  // List<FacilityResultData> f_list =
  // FacilitiesUtils.getFacilitiesFromSelectQuery(fquery);
  // int fsize = f_list.size();
  // for (int i = 0; i < fsize; i++) {
  // f_record = f_list.get(i);
  // if (!FacilitiesUtils.isContains(facilityMemberList, f_record)) {
  // facilityMemberList.add(f_record);
  // }
  // }
  // }
  //
  // return facilityMemberList;
  // }
  // remove end
}
