/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2012 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.schedule.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.generic.MathTool;

import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.schedule.ScheduleConst;
import com.aimluck.eip.schedule.beans.ScheduleUserBean;
import com.aimluck.eip.services.orgutils.ALOrgUtilsService;
import com.aimluck.eip.user.beans.UserGroupPositionLiteBean;
import com.aimluck.eip.user.util.UserUtils;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;

/**
 * 1日スケジュール用ユーティリティ
 */
public class OneDayScheduleUtils {

  /** loger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(OneDayScheduleUtils.class.getName());

  /**
   * 基本項目の初期設定
   * 
   * @param rundata
   *          実行データ
   * @param context
   *          Velocityコンテキスト
   * @param memberUserIdList
   *          閲覧メンバーユーザーID一覧
   */
  public static void initBaseField(RunData rundata, Context context, String[] memberUserIdList) {

    // 現在のポートレットを取得する
    VelocityPortlet portlet = ALEipUtils.getPortlet(rundata, context);

    // 現在のユーザーを取得する
    ALEipUser loginuser = ALEipUtils.getALEipUser(rundata);

    // 各種基本項目を設定する
    // テーマ
    context.put("theme", ALOrgUtilsService.getTheme());

    // 本日日付
    Calendar today = Calendar.getInstance();
    context.put("today", String.format("%1$tY-%1$tm-%1$td", today));

    // 表示開始時間
    String time_start = portlet.getPortletConfig().getInitParameter("p1a-rows");
    context.put("time_start", time_start);

    // 表示終了時間
    String time_end = portlet.getPortletConfig().getInitParameter("p1b-rows");
    context.put("time_end", time_end);

    // 表示時間間隔
    String time_interval = portlet.getPortletConfig().getInitParameter("p1c-rows");
    context.put("time_interval", time_interval);

    // 閲覧メンバー一覧と閲覧可能メンバー一覧を作成
    List<ScheduleUserBean> memberList = new ArrayList<ScheduleUserBean>(0);
    List<ScheduleUserBean> approvalMemberList = new ArrayList<ScheduleUserBean>(0);
    try {
      for (String userId : memberUserIdList) {
        // メンバーのスケジュール用ユーザー情報取得
        ScheduleUserBean userInfo = ScheduleUtils.getScheduleUserBean(Integer.toString(ALEipUtils.getUserId(rundata)), userId);
        memberList.add(userInfo);
        if (!ScheduleConst.SCHEDULE_ACL_REFUSAL.equals(userInfo.getAccessCtrl())) {
          // 閲覧権限≠不可の場合<閲覧メンバー可リストに登録>
          approvalMemberList.add(userInfo);
        }
      }
    } catch (Exception e) {
      logger.error("１日スケジュール画面表示にて、ユーザー情報の取得に失敗しました。ログインユーザー:" + loginuser.getName(), e);
    }

    // 閲覧メンバー一覧
    context.put("member_list", memberList);

    // 閲覧可能メンバー一覧
    context.put("app_member_list", approvalMemberList);

    // ログインユーザー情報
    String current = loginuser.getAliasName().toString();
    context.put("current_user", current);
    context.put("current_user_ln", loginuser.getName());
    context.put("current_user_id", loginuser.getUserId());

    // ログインユーザーの所属部署1,部署2
    List<UserGroupPositionLiteBean> list = UserUtils.getPostPositionBeanList((int) loginuser.getUserId().getValue());
    if (list != null && list.size() > 0) {
      UserGroupPositionLiteBean b = list.get(0);
      String current_parent_group_name = b.getPost1GroupName();
      String current_group_name = b.getPost2GroupName();
      context.put("current_group_name", current_group_name);
      context.put("current_parent_group_name", current_parent_group_name);
    }

    // アクセスコントロール
    context.put("hasAcl", ScheduleUtils.hasAuthOther(rundata));

    // セキュリティID
    String secId = "";
    try {
      secId = URLEncoder.encode((String) rundata.getUser().getTemp(ALEipConstants.SECURE_ID), ALEipConstants.DEF_CONTENT_ENCODING);
    } catch (UnsupportedEncodingException e) {
      logger.error("セキュリティIDを読み込めませんでした。ログインユーザー:" + loginuser.getName(), e);
    }
    context.put(ALEipConstants.SECURE_ID, secId);

    // 遷移元
    boolean isFromMonthly = ("FromMonthly".equals(ALEipUtils.getTemp(rundata, context, "FROM_PORTLET")));
    context.put("isFromMonthly", isFromMonthly);

    // VM用共通処理
    context.put("utils", new ALCommonUtils());

    // VelocityToolの設定
    context.put("math", new MathTool());

    // 色分類名一覧を設定
    context.put("scheduleCategoryNameList", ScheduleUtils.SCHEDULE_CATEGORY_NAME_LIST);
    // 色コード一覧を設定
    context.put("scheduleCategoryColorList", ScheduleUtils.SCHEDULE_CATEGORY_COLOR_LIST);

  }
}
