/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 *
 * Copyright(C) 2011 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
dojo.provide("aipo.schedule.common");

/**
 * スケジュールサブ情報表示
 *
 * @param url スケジュールサブ情報取得処理URL
 * @param portlet_id ポートレットID
 * @param containerNode ツールチップ部品のノード
 */
aipo.schedule.common.showTooltip = function(url, portlet_id, containerNode) {

    var datehtml = "";
    var rmbhtml = "";
    var smbhtml = "";
    var placehtml = "";

    dojo.xhrGet({
        portletId: portlet_id,
        url: url,
        encoding: "utf-8",
        handleAs: "json-comment-filtered",
        load: function(schedule, event) {
            if (schedule.length <= 0) {
                return;
            }

            // 期間でない場合、開始時刻と終了時刻を設定
            if (!schedule.isSpan) {
                datehtml = "<span style=\"font-size: 0.90em;\">" + schedule.date + "</span><br/>";
            }

            // 参加必須メンバー
            rmbhtml = aipo.schedule.common.getMemberListHtml(schedule.reqMemberList);
            if(rmbhtml != ""){
                rmbhtml = "<span style=\"font-size: 0.90em;\">【参加必須】</span><br/><ul>" + rmbhtml + "</ul>";
            }

            // 参加任意メンバー
            smbhtml = aipo.schedule.common.getMemberListHtml(schedule.subMemberList);
            if(smbhtml != ""){
                smbhtml = "<span style=\"font-size: 0.90em;\">【参加任意】</span><br/><ul>" + smbhtml + "</ul>";
            }

            // 場所
            if(schedule.place != ""){
                placehtml = "<span style=\"font-size: 0.90em;\">場所</span><br/><ul>・" + schedule.place + "</ul>";
            }

            // ツールチップ表示
            var tooltiphtml = "<h4>" + schedule.name + "</h4>" + datehtml + rmbhtml + smbhtml + placehtml;
            containerNode.innerHTML = tooltiphtml;
        }
    });
}

/**
 * 3名ごと改行の参加メンバー表示
 *
 * @param list ALEipUserのリスト
 * @return 3名ごとに改行タグを入れたテキスト
 */
aipo.schedule.common.getMemberListHtml = function(list){
    var mbhtml = "";
    if (list) {
        var memberSize = list.length;
        for (var i = 0 ; i < memberSize ; i++) {
            mbhtml += "・" + list[i].aliasName.value;
            if((i+1) % 3 == 0 && (i+1) != memberSize){
                mbhtml += "<br/>";
            }
        }
    }
    return mbhtml;
}

// add start 要件No.16　スケジュール画面（月単位／週単位／日単位）右クリックメニュー
/**
 * スケジュール右クリックメニュー表示処理
 * @param event マウスイベントオブジェクト
 * @param portletId ポートレットID
 * @param detailUrl 詳細画面URL
 * @param baseurl 汎用URL
 * @param status 状態
 * @param priority 重要フラグ
 * @param isrepeat 繰り返しフラグ
 * @param ismember メンバーフラグ
 * @param isowner 主催者フラグ
 * @param isshare 共有スケジュールフラグ
 * @param isloginuser 本人（秘書）フラグ
 * @param userid ユーザーid
 * @param secid トークンid
 * @param node 右クリック表示対象タグオブジェクト
 * @param callback コールバック
 */
dojo.require('dijit.Menu');
aipo.schedule.common.showMenu = function(
  event,
  portletId,
  detailUrl,
  baseurl,
  status,
  priority,
  isrepeat,
  ismember,
  isowner,
  isshare,
  isloginuser,
  userid,
  secid,
  node,
  callback) {

  var pMenu = new dijit.Menu();

//alert("isloginuser:" + isloginuser + " ismember:" + ismember + " isowner:" + isowner)

  if( isloginuser == "false" ) {
    //本人、秘書でない場合は、主催者用、参加メンバー用メニューは表示しない。
    ismember = "false";
    isowner = "false";
  } else {
    ismember = "true";
  }
  
  // add start 要件No.26 スケジュール個別色換え
  // 分類する処理
  if(isowner == "true" || ismember == "true") {
    // サブメニューの設定
    var pSubMenu = new dijit.Menu();
    // 色分類のレコード分描画する
    // 色分類名リスト
    var colorNameList = ptConfig[portletId].colorNameList;
    // 色コードリスト
    var colorCodeList = ptConfig[portletId].colorCodeList;
    dojo.forEach(colorCodeList, function(colorCode, index){
        // 色分類名を取得
        var colorName = colorNameList[index];
        // サブメニューの背景色を決定
        var itemStyle = "";
        if(colorCode != ""){
          itemStyle = "background-color:#" + colorCode + ";";
        }else{
          itemStyle = "background-color:#FFFFFF;";
        }
        // サブメニューに色分類を追加
        pSubMenu.addChild(new dijit.MenuItem({
          label: colorName,
          style: itemStyle,
          onClick: function(evt) {
            // 個別色の表示更新
            if(node.id.indexOf("termSchedule-") != 0
            && node.id.indexOf("termScheduleDivHandleLeft-") != 0
            && node.id.indexOf("termScheduleDivHandleRight-") != 0){
              // 週間スケジュールの期間以外の設定
              //if(colorCode != ""){
              //  // 色ありの場合
              //  dojo.style(node, "backgroundColor", "#" + colorCode);
              //}else{
              //  // 色なしの場合
              //  dojo.style(node, "backgroundColor", "");
              //}
              aipo.schedule.common.setColor(baseurl, portletId, userid, colorCode, node);
            }else{
              // 週間スケジュールの期間予定の設定
              var targetNode = null;
              if(node.id.indexOf("termSchedule-") == 0){
                targetNode = dojo.byId(node.id.replace("termSchedule", "indColor"));
              }else if(node.id.indexOf("termScheduleDivHandleLeft-") == 0){
                targetNode = dojo.byId(node.id.replace("termScheduleDivHandleLeft", "indColor"));
              }else if(node.id.indexOf("termScheduleDivHandleRight-") == 0){
                targetNode = dojo.byId(node.id.replace("termScheduleDivHandleRight", "indColor"));
              }
              if(targetNode){
                if(colorCode != ""){
                  // 色ありの場合
                  dojo.style(targetNode, "backgroundColor", "#" + colorCode);
                  dojo.style(targetNode, "display", "inline");
                }else{
                  // 色なしの場合
                  dojo.style(targetNode, "backgroundColor", "");
                  dojo.style(targetNode, "display", "none");
                }
              }
            }
            // 個別色のDB登録
            var url = baseurl + "&template=ScheduleChangeIndividualColorJSONScreen" + "&secid=" + secid + "&userid=" + userid + "&categoryColor=" + colorCode;
            aipo.schedule.common.ajaxNoAlertRequest(url, portletId);

            //個別色のDB登録時は、画面のリロードを行なわないため、Tooltipフラグを元に戻す
            ptConfig[portletId].isTooltipEnable = true;
          }
        }));
    });
    // メインメニューの描画
    pMenu.addChild(new dijit.PopupMenuItem({
      label: "<div>分類する</div>",
      popup: pSubMenu,
      templateString:
        '<tr class="dijitReset dijitMenuItem"'
        +'dojoAttachEvent="onmouseenter:_onHover,onmouseleave:_onUnhover,ondijitclick:_onClick">'
          +'<td class="dijitReset"><div class="dijitMenuItemIcon ${iconClass}" dojoAttachPoint="iconNode" ></div></td>'
          +'<td tabIndex="-1" class="dijitReset dijitMenuItemLabel" dojoAttachPoint="containerNode" waiRole="menuitem"></td>'
          +'<td class="dijitReset" dojoAttachPoint="arrowCell">'
            +'<div class="dijitMenuExpand" dojoAttachPoint="expand" style="display:block">'
              +'<span class="dijitInline dijitArrowNode dijitMenuExpandInner"><img src="images/schedule/submenu.gif"></span>'
            +'</div>'
          +'</td>'
        +'</tr>'
    }));
  }
  // add end
  
  pMenu.addChild(new dijit.MenuItem({
    label: "<div style='width:180px;'>詳細表示</div>",
    onClick: function(evt) {
      aipo.common.showWindow(detailUrl, portletId, aipo.schedule.onLoadScheduleDetail);
      pMenu._onBlur();
    }
  }));

  if(isowner == "true") {
    //主催者の場合

    var msg1 = "削除理由の入力を行なわずに、スケジュールを削除してよろしいですか？\n※削除理由を入力する場合は、スケジュール詳細画面から削除を行なって下さい。";
    var msg2 = "スケジュールを削除してよろしいですか？";

    pMenu.addChild(new dijit.MenuItem({
      label: "<div>編集する</div>",
      onClick: function(evt) {
        var url = baseurl + "&template=ScheduleFormScreen" + "&userid=" + userid + "&secid=" + secid;
        aipo.common.showWindow(url, portletId, aipo.schedule.onLoadScheduleDialog);
        pMenu._onBlur();
      }
    }));

    if( isrepeat == "true" ) {
    
      var labelStringOneDayDelete = "";
      var labelStringAllDayDelete = "";
      if( isshare == "true" ) {
          labelStringOneDayDelete = "<div>コメントせずこの日だけ削除</div>";
          labelStringAllDayDelete = "<div>コメントせず全削除</div>";
      } else {
          labelStringOneDayDelete = "<div>この日だけ削除する</div>";
          labelStringAllDayDelete = "<div>全削除する</div>";
      }
    
      pMenu.addChild(new dijit.MenuItem({
        label: labelStringOneDayDelete,
        onClick: function(evt) {
          var msg = "";
          if( isshare == "true" ) {
            msg = msg1;
          } else {
            msg = msg2;
          }
          if( confirm(msg) ) {
            var url = baseurl + "&template=ScheduleFormJSONScreen" + "&mode=delete" + "&userid=" + userid + "&secid=" + secid;
            if( isshare == "true" ) {
              url = url + "&del_member_flag=0&del_range_flag=1";
            } else {
              url = url + "&del_member_flag=1&del_range_flag=1";
            }
            aipo.schedule.common.ajaxRequest(url, callback, portletId);
          }
          pMenu._onBlur();
        }
      }));
      pMenu.addChild(new dijit.MenuItem({
        label: labelStringAllDayDelete,
        onClick: function(evt) {
          var msg = "";
          if( isshare == "true" ) {
            msg = msg1;
          } else {
            msg = msg2;
          }
          if( confirm(msg) ) {
            var url = baseurl + "&template=ScheduleFormJSONScreen" + "&mode=delete" + "&userid=" + userid + "&secid=" + secid;
            if( isshare == "true" ) {
              url = url + "&del_member_flag=0&del_range_flag=0";
            } else {
              url = url + "&del_member_flag=1&del_range_flag=0";
            }
            aipo.schedule.common.ajaxRequest(url, callback, portletId);
          }
          pMenu._onBlur();
        }
      }));
    } else {

      var labelStringDelete = "";
      if( isshare == "true" ) {
          labelStringDelete = "<div>コメントせず削除</div>";
      } else {
          labelStringDelete = "<div>削除する</div>";
      }
      
      pMenu.addChild(new dijit.MenuItem({
        label: labelStringDelete,
        onClick: function(evt) {
          var msg = "";
          if( isshare == "true" ) {
            msg = msg1;
          } else {
            msg = msg2;
          }
          if( confirm(msg) ) {
            var url = baseurl + "&template=ScheduleFormJSONScreen" + "&mode=delete" + "&userid=" + userid + "&secid=" + secid;
            if( isshare == "true" ) {
              url = url + "&del_member_flag=0&del_range_flag=0";
            } else {
              url = url + "&del_member_flag=1&del_range_flag=0";
            }
            aipo.schedule.common.ajaxRequest(url, callback, portletId);
          }
          pMenu._onBlur();
        }
      }));
    }

    pMenu.addChild(new dijit.MenuItem({
      label: "<div>コピーして登録する</div>",
      onClick: function(evt) {
        var url = baseurl + "&template=ScheduleFormScreen" + "&userid=" + userid + "&secid=" + secid + "&is_copy=true";
        aipo.common.showWindow(url, portletId, aipo.schedule.onLoadScheduleDialog);
        pMenu._onBlur();
      }
    }));

  } else if(ismember == "true") {
    //参加者の場合

    var msg3 = "返信コメントの入力を行なわずに、回答を行ないますがよろしいですか？\n※返信コメントを入力する場合は、スケジュール詳細画面から回答を行なって下さい。";

    //承諾処理
    var labelStringC = "";
    var newStatusC  = "";
    if( status == "C" ) {
      labelStringC = "<div>未回答に戻す</div>";
      newStatusC = "T";
    } else {
      labelStringC = "<div>コメントせず承諾する</div>";
      newStatusC = "C";
    }

    pMenu.addChild(new dijit.MenuItem({
      label: labelStringC,
      onClick: function(evt) {
        if( newStatusC == "C" && !confirm(msg3) ) {
          pMenu._onBlur();
          return;
        }
        var url = baseurl + "&template=ScheduleFormJSONScreen" + "&mode=" + "change_status" + "&status=" + newStatusC + "&secid=" + secid + "&userid=" + userid;
        aipo.schedule.common.ajaxRequest(url, callback, portletId);
        pMenu._onBlur();
      }
    }));

    //仮承諾処理
    var labelStringP = "";
    var newStatusP  = "";
    if( status == "P" ) {
      labelStringP = "<div>未回答に戻す</div>";
      newStatusP = "T";
    } else {
      labelStringP = "<div>コメントせず仮承諾する</div>";
      newStatusP = "P";
    }

    pMenu.addChild(new dijit.MenuItem({
      label: labelStringP,
      onClick: function(evt) {
        if( newStatusP == "P" && !confirm(msg3) ) {
          pMenu._onBlur();
          return;
        }
        var url = baseurl + "&template=ScheduleFormJSONScreen" + "&mode=" + "change_status" + "&status=" + newStatusP + "&secid=" + secid + "&userid=" + userid;
        aipo.schedule.common.ajaxRequest(url, callback, portletId);
        pMenu._onBlur();
      }
    }));

    //辞退して削除する処理
    pMenu.addChild(new dijit.MenuItem({
      label: "<div>コメントせず辞退して削除する</div>",
      onClick: function(evt) {
        if( confirm(msg3) ) {
          var url = baseurl + "&template=ScheduleFormJSONScreen" + "&mode=" + "change_status" + "&status=" + "RV" + "&secid=" + secid + "&userid=" + userid;
          aipo.schedule.common.ajaxRequest(url, callback, portletId);
          pMenu._onBlur();
        }
      }
    }));

    //辞退して削除しない処理
    var labelStringV = "";
    var newStatusV  = "";
    if( status == "V" ) {
      labelStringV = "<div>未回答に戻す</div>";
      newStatusV = "T";
    } else {
      labelStringV = "<div>コメントせず辞退して削除しない</div>";
      newStatusV = "V";
    }

    pMenu.addChild(new dijit.MenuItem({
      label:labelStringV,
      onClick: function(evt) {
        if( newStatusV == "V" && !confirm(msg3) ) {
          pMenu._onBlur();
          return;
        }
        var url = baseurl + "&template=ScheduleFormJSONScreen" + "&mode=" + "change_status" + "&status=" + newStatusV + "&secid=" + secid + "&userid=" + userid;
        aipo.schedule.common.ajaxRequest(url, callback, portletId);
        pMenu._onBlur();
      }
    }));

    //返信せずに削除処理
    pMenu.addChild(new dijit.MenuItem({
      label: "<div>返信せず削除</div>",
      onClick: function(evt) {
        if( confirm("返信せずに削除しますが、よろしいですか？") ) {
          var url = baseurl + "&template=ScheduleFormJSONScreen" + "&mode=" + "change_status" + "&status=" + "RN" + "&secid=" + secid + "&userid=" + userid;
          aipo.schedule.common.ajaxRequest(url, callback, portletId);
        }
        pMenu._onBlur();
      }
    }));
  }

  // 重要にする／重要解除処理
  if(isowner == "true" || ismember == "true") {
    if( priority == "false" ) {
      pMenu.addChild(new dijit.MenuItem({
        label: "<div>重要にする</div>",
        onClick: function(evt) {
          var url = baseurl + "&template=ScheduleFormJSONScreen" + "&mode=" + "change_priority" + "&status=" + "T" + "&secid=" + secid + "&userid=" + userid;
          aipo.schedule.common.ajaxRequest(url, callback, portletId);
          pMenu._onBlur();
        }
      }));
    } else {
      pMenu.addChild(new dijit.MenuItem({
        label: "<div>重要解除</div>",
        onClick: function(evt) {
          var url = baseurl + "&template=ScheduleFormJSONScreen" + "&mode=" + "change_priority" + "&status=" + "F" + "&secid=" + secid + "&userid=" + userid;
          aipo.schedule.common.ajaxRequest(url, callback, portletId);
          pMenu._onBlur();
        }
      }));
    }
  }

  // 閉じる処理
  pMenu.addChild(new dijit.MenuItem({
    label: "<div>閉じる</div>",
    onClick: function(evt) {
      pMenu._onBlur();
    }
  }));

  // 対象ノードにバインド後、メニューを表示し、バインドを解除する。
  pMenu.bindDomNode(node);
  pMenu._openMyself(event);
  pMenu.unBindDomNode(node);

}

/**
 * Ajax処理
 *
 * @param url リクエストURL
 * @param callback レスポンス受信後にコールバックするメソッドオブジェクト
 * @param portletId ポートレットID
 */
aipo.schedule.common.ajaxRequest = function(url, callback, portletId) {
    ptConfig[portletId].isTooltipEnable = false;
    dojo.xhrGet({
        url: url,
        timeout: 60000,
        encoding: "utf-8",
        handleAs: "json-comment-filtered",
        headers: { X_REQUESTED_WITH: "XMLHttpRequest" },
        load: function (res, ioArgs){
          //alert(res.toString());
          //aipo.portletReload('schedule');
          if( res != "" ) {
            if( res.toString().indexOf("Priority") != 0 ) {
              alert(res.toString());
            }
          }
          callback.call(null, portletId, "");
        }
    });
};

// add end
// add start 要件No.26 スケジュール個別色換え
/**
 * Ajax非同期リクエスト処理<br/>
 * コールバック処理およびアラート処理を実行しない
 *
 * @param url リクエストURL
 * @param portletId ポートレットID
 */
aipo.schedule.common.ajaxNoAlertRequest = function(url, portletId) {
    ptConfig[portletId].isTooltipEnable = false;
    dojo.xhrGet({
        url: url,
        timeout: 60000,
        encoding: "utf-8",
        handleAs: "json-comment-filtered",
        headers: { X_REQUESTED_WITH: "XMLHttpRequest" },
        load: function (res, ioArgs){
        }
    });
};

/**
 * 個別色設定処理
 * @param baseurl 汎用URL
 * @param portletId ポートレットID
 * @param userid ユーザーid
 * @param colorCode 個別色
 * @param node 右クリック表示対象タグオブジェクト
 */
aipo.schedule.common.setColor = function(baseurl, portletId, userid, colorCode, node) {
  if( ! ptConfig[portletId].targetTableId || node.className.indexOf("monthCalendarLink") >= 0) {
    //１日スケジュール画面、または月間スケジュール画面の期間予定の場合
    if(colorCode != ""){
      dojo.style(node, "backgroundColor", "#" + colorCode);
    } else {
      dojo.style(node, "backgroundColor", "");
    }
  } else {
    //週間、月間スケジュール画面の通常予定の場合
    //繰り返し、日またぎに対応するため、name属性で横串にして個別色を設定する
    var key = "entityid=";
    var start = baseurl.toLowerCase().indexOf(key);
    var end = baseurl.indexOf("&", start);
    if( end == -1 ) {
      end = baseurl.length
    }
    var entityid = baseurl.slice(start + key.length, end);
    var targetTableId = ptConfig[portletId].targetTableId;
    var queryString = "div[name='schedule-rightclick-color-" + portletId + "-" + entityid  + "-" + userid + "']";
    dojo.query(queryString, dojo.byId(ptConfig[portletId].targetTableId)).forEach(function(ele) {
      if(colorCode != ""){
        dojo.style(ele, "backgroundColor", "#" + colorCode);
      } else {
        dojo.style(ele, "backgroundColor", "");
      }
    }, this);
  }
}
//add end

// add start 要件No.15 スケジュール画面（月単位）カレンダー追加

/**
 * 月間スケジュール画面リロード
 *
 */
aipo.schedule.common.reload = function(portletId){
  //aipo.portletReload('schedule');
  aipo.schedule.common.viewPage(ptConfig[portletId].initUrl, portletId, null)
}

/**
 * 月間スケジュール画面用viewPage
 * 初期描画フラグを設定しつつページ非同期読込を実施する。
 * @param url 読み込み先ページURL
 * @param portletId 読み込み先ポートレットID
 * @param params 読み込み先ページ用リクエストパラメータ
 */
aipo.schedule.common.viewPage = function(url, portletId, params) {

    var portlet = dijit.byId('portlet_' + portletId);
    if(! portlet){
      portlet = new aimluck.widget.Contentpane({},'portlet_' + portletId);
    }

    if(portlet){
      ptConfig[portletId].reloadUrl= url;

      // 読み込み終了後に描画終了処理を実行する
      portlet.onLoad = aipo.schedule.common.initCalendar;

      if(params){
        for(i = 0 ; i < params.length; i++ ) {
         portlet.setParam(params[i][0], params[i][1]);
        }
      }

      portlet.viewPage(url);
    }
};

/**
 * カレンダーツール初期化
 *
 */
aipo.schedule.common.initCalendar = function() {

//alert("initCalendar" + dojo.byId("current").value)
  // カレンダーWidget呼び出し
  dojo.require("aipo.widget.MonthlyScheduleDropdownDatepicker");
  var startDateSpan = new aipo.widget.MonthlyScheduleDropdownDatepicker({
    id: "monthlyStartDateSpan",
    widgetId: "monthlyStartDateSpan",
    iconURL: "images/icon/icon_date.gif",
    iconAlt: "開始日",
    name: "monthlyStartDateSpan",
    hiddenId: "monthly_start_date",
    initValue: dojo.byId("monthlyCurrentDate").value,
    checked: "checked",
    inputId: "monthly_start_date_input",
    dateId: "monthly_start_date",
    displayCheck: "none",
    callback: aipo.schedule.common.viewPage
   }, dojo.byId("monthlyStartDateSpan")
  );
}
// add end

