/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2011 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

dojo.provide("aipo.widget.MemberGroupSendSelectList");

dojo.require("dijit._Widget");
dojo.require("dijit._Templated");

dojo.declare("aipo.widget.MemberGroupSendSelectList", [dijit._Widget, dijit._Templated], {
    widgetId:"",
    memberFromId: "",
    memberFromUrl: "",
    memberFromOptionKey: "",
    memberFromOptionValue: "",
    memberToTitle: "",
    memberToListTitle: "",
    memberToId: "",
    buttonAddId: "",
    buttonRemoveId: "",
    buttonAllRemoveId: "",
    buttonAllRemoveDisplay: "none",
    initGroupName: "",
    initParentGroupName: "",
    memberLimit: 0,
    groupSelectId: "",
    parentGroupSelectId: "",
    group1SelectPreOptionKey: "",
    group1SelectPreOptionValue: "",
    group2SelectPreOptionKey: "",
    group2SelectPreOptionValue: "",
    groupSelectOptionKey: "",
    groupSelectOptionValue: "",
    post1GroupUrl: "",
    changePost2GroupUrl: "",
    changePost1GroupUrl: "",

    templateString:"<div id=\"${widgetId}\" widgetId=\"${widgetId}\">"
      + "<table class=\"none\"><tr><td>"
      + "<div id=\"memberPopupDiv\"><div class=\"outer\"><div class=\"popup\" style=\"width:330px;\"><div class=\"clearfix\">" 
      + "<div class=\"memberlistToTop\" >${memberToTitle}</div>"
      + "<div class=\"memberlistFromTop\">"
      + "<select size=\"1\" style=\"width:100%\" name=\"${parentGroupSelectId}\" id=\"${parentGroupSelectId}\" dojoAttachEvent=\"onchange:changeParentGroup\"></select>"
      + "<select size=\"1\" style=\"width:100%\" name=\"${groupSelectId}\" id=\"${groupSelectId}\" dojoAttachEvent=\"onchange:changeGroup\"></select>"
      + "</div></div>"
      + "<div class=\"clearfix\">"
      
      + "<div class=\"memberlistToBody\">"
      
      + "<div class=\"clearfix\">"
      + "${memberToListTitle}"
      + "<table style=\"width:100%;\"><tbody><tr><td style=\"width:90%\">"
      + "<select size=\"7\" multiple=\"multiple\" style=\"width:100%\" name=\"${memberToId}\" id=\"${memberToId}\"></select>"
      + "</td>"
//      + "<td>"
//      + "<input id=\"${buttonAddId}\" name=\"${buttonAddId}\" type=\"button\" class=\"button\" value=\"<\" dojoAttachEvent=\"onclick:onMemberAddClick\">"
//      + "<input id=\"${buttonRemoveId}\" name=\"${buttonRemoveId}\" type=\"button\" class=\"button\" value=\">\"/ dojoAttachEvent=\"onclick:onMemberRemoveClick\">"
//      + "</td>"
      + "</tr></tbody></table>"
      + "</div>"

      + "</div>" 
      
      + "<div class=\"memberlistFromBody\"><select size=\"8\" multiple=\"multiple\" style=\"width:100%\" name=\"${memberFromId}\" id=\"${memberFromId}\"></select></div></div>"
      
      + "<div class=\"clearfix\">"
      
      + "<div class=\"memberlistToBottom\">"
      + "<div style=\"display: ${buttonAllRemoveDisplay};\" class=\"alignleft\">"
      + "<input id=\"${buttonAllRemoveId}\" name=\"${buttonAllRemoveId}\" type=\"button\" class=\"button\" value=\"\u3059\u3079\u3066\u524a\u9664\"/ dojoAttachEvent=\"onclick:onAllMemberRemoveClick\">"
      + "</div>"
      + "<div class=\"alignright\">"
      + "<input id=\"${buttonRemoveId}\" name=\"${buttonRemoveId}\" type=\"button\" class=\"button\" value=\"\u524a\u9664\"/ dojoAttachEvent=\"onclick:onMemberRemoveClick\">"
      + "</div>"
      + "</div>"
      + "<div class=\"memberlistFromBottom\">"
      + "<div style=\"display: none;\" id=\"${widgetId}-memberlist-indicator\" class=\"indicator alignleft\">読み込み中</div>"
      + "<div class=\"alignright\">"
      + "<input id=\"${buttonAddId}\" name=\"${buttonAddId}\" type=\"button\" class=\"button\" value=\"\u3000\uff1c\u0020\u8ffd\u52a0\u3000\"/ dojoAttachEvent=\"onclick:onMemberAddClick\">"
      + "</div>"
      + "</div>"
      
      + "</div></div></div></div>"
      + "</td></tr></table></div>\n",

    ////////////////////////////////////////////////////////
    //初期表示処理
    postCreate: function(){
        this.id = this.widgetId;
        
        //メンバーリストボックス初期表示
        var url = this.memberFromUrl+"&mode=post1_group&groupname="+this.initGroupName;
        var params = {
          url: url,
          key: this.memberFromOptionKey,
          value: this.memberFromOptionValue,
          indicator: this.widgetId + "-memberlist-indicator"
        };
        aimluck.io.createOptions(this.memberFromId, params);
        
        //部署１プルダウンを表示
        params = {
          url: this.post1GroupUrl,
          key: this.groupSelectOptionKey,
          value: this.groupSelectOptionValue,
          selectedId: this.initParentGroupName,
          preOptions: { key:this.group1SelectPreOptionKey, value:this.group1SelectPreOptionValue }
        };
        aimluck.io.createOptions(this.parentGroupSelectId, params);
        
        //部署２プルダウンを表示
        url = this.changePost1GroupUrl+"&parent_group_name="+this.initParentGroupName;
        params = {
          url: url,
          key: this.groupSelectOptionKey,
          value: this.groupSelectOptionValue,
          selectedId: this.initGroupName,
          preOptions: { key:this.group2SelectPreOptionKey, value:this.group2SelectPreOptionValue }
        };
        aimluck.io.createOptions(this.groupSelectId, params);
    },
    addOption:function(select, value, text, is_selected) {
      aimluck.io.addOption(select, value, text, is_selected);
    },
    addOptionSync:function(value, text, is_selected) {
      var select = dojo.byId(this.memberToId);
      if (this.memberLimit != 0 && select.options.length >= this.memberLimit) return;
      if (document.all) {
        var option = document.createElement("OPTION");
        option.value = value;
        option.text = text;
        option.selected = is_selected;
        if (select.options.length == 1 && select.options[0].value == ""){
                select.options.remove(0);
          }
          select.add(option, select.options.length);
      } else {
        var option = document.createElement("OPTION");
        option.value = value;
        option.text = text;
        option.selected = is_selected;
        if (select.options.length == 1 && select.options[0].value == ""){
            select.removeChild(select.options[0]);
        }
        select.insertBefore(option, select.options[select.options.length]);
      }
    },
    addMember:function(select_member_from, select_member_to, refer_select_member_to) {
      if (document.all) {
            var f_o = select_member_from.options;
            var t_o = select_member_to.options;
            if (f_o.length == 1 && f_o[0].value == "") return;
            for(i = 0 ; i < f_o.length; i ++ ) {
            
                if(!f_o[i].selected) continue;
                
                var iseq = false;
                for( j = 0 ; j < t_o.length; j ++ ) {
                  if( t_o[j].value == f_o[i].value ) {
                    iseq = true;
                    break;
                  }
                }

                if(iseq) continue;
               
                var option = document.createElement("OPTION");
                option.value = f_o[i].value;
                option.text = f_o[i].text;
                option.selected = true;
            if (t_o.length == 1 && t_o[0].value == ""){
                    t_o.remove(0);
            }
               if (this.memberLimit != 0 && select_member_to.options.length >= this.memberLimit) return;
                t_o.add(option, t_o.length);
            }
      } else {
            var f_o = select_member_from.options;
            var t_o = select_member_to.options;
            if (f_o.length == 1 && f_o[0].value == "") return;
            for(i = 0 ; i < f_o.length; i ++ ) {
                if(!f_o[i].selected) continue;
                var iseq = false;

                for( j = 0 ; j < t_o.length; j ++ ) {
                  if( t_o[j].value == f_o[i].value ) {
                    iseq = true;
                    break;
                  }
                }
                
                if(iseq) continue;
                var option = document.createElement("OPTION");
                option.value = f_o[i].value;
                option.text = f_o[i].text;
                option.selected = true;
            if (select_member_to.options.length == 1 && select_member_to.options[0].value == ""){
                select_member_to.removeChild(select_member_to.options[0]);
            }
                if (this.memberLimit != 0 && select_member_to.options.length >= this.memberLimit) return;
                select_member_to.insertBefore(option, t_o[t_o.length]);
            }
      }
    },
    removeAllMember:function(select) {
      if (document.all) {
        var t_o = select.options;
          for(i = 0 ;i < t_o.length; i ++ ) {
              if( t_o[i].selected ) {
              t_o.remove(i);
                i -= 1;
            }
            }
      } else {
        var t_o = select.options;
          for(i = 0 ;i < t_o.length; i ++ ) {
              if( t_o[i].selected ) {
                    select.removeChild(t_o[i]);
                i -= 1;
                }
            }
      }
    },
    removeAllMemberWithoutSelect:function(select) {
      if (document.all) {
        var t_o = select.options;
        for(i = 0 ;i < t_o.length; i ++ ) {
          t_o.remove(i);
          i -= 1;
        }
      } else {
        var t_o = select.options;
        for(i = 0 ;i < t_o.length; i ++ ) {
          select.removeChild(t_o[i]);
          i -= 1;
        }
      }
    },
    removeMember:function(select) {
      if (document.all) {
        var t_o = select.options;
          for(i = 0 ;i < t_o.length; i ++ ) {
              if( t_o[i].selected ) {
              t_o.remove(i);
                i -= 1;
            }
            }
      } else {
        var t_o = select.options;
          for(i = 0 ;i < t_o.length; i ++ ) {
              if( t_o[i].selected ) {
                    select.removeChild(t_o[i]);
                i -= 1;
                }
            }
      }
    },
    removeMemberSync:function(select_member_to) {
      var select = select_member_to;
      if (document.all) {
        var t_o = select.options;
          for(i = 0 ;i < t_o.length; i ++ ) {
              if( t_o[i].selected ) {
              t_o.remove(i);
                i -= 1;
            }
        }
      } else {
        var t_o = select.options;
          for(i = 0 ;i < t_o.length; i ++ ) {
              if( t_o[i].selected ) {
                select.removeChild(t_o[i]);
                i -= 1;
              }
          }
      }
    },
    /////////////////////////////////////////////////////////
    //部署２プルダウン選択時処理
    changeGroup: function(select) {
    
    //部署2プルダウンの選択値を取得
      var group_name = select.target.options[select.target.selectedIndex].value;
      var url = "";
      if( group_name == "ALL" ) {
        //"すべて"を選択した場合、部署１の選択肢を取得して、表示処理
        url = this.changePost2GroupUrl+"&mode=post1_group&groupname="+dojo.byId(this.parentGroupSelectId).value;
      } else {     
        url = this.changePost2GroupUrl+"&mode=group&groupname="+group_name;
      }
      var params = {
        url: url,
        key: this.memberFromOptionKey,
        value: this.memberFromOptionValue,
        indicator: this.widgetId + "-memberlist-indicator"
      };
      aimluck.io.createOptions(this.memberFromId, params);
      
    },
    /////////////////////////////////////////////////////////
    //部署１プルダウン選択
    changeParentGroup: function(select) {
      
      ////////////////////////
      //メンバーリストボックス表示
      ////////////////////////
      var group_name = select.target.options[select.target.selectedIndex].value;
      var url = this.changePost2GroupUrl+"&mode=post1_group&groupname="+group_name;
      var params = {
        url: url,
        key: this.memberFromOptionKey,
        value: this.memberFromOptionValue,
        indicator: this.widgetId + "-memberlist-indicator"
      };
      aimluck.io.createOptions(this.memberFromId, params);
    
      /////////////////////
      //部署２プルダウンを表示
      /////////////////////
      
      //部署1プルダウンの選択値を取得
      var parent_group_name = select.target.options[select.target.selectedIndex].value;
      
      //部署2プルダウン生成処理
      var url = this.changePost1GroupUrl+"&parent_group_name="+parent_group_name;
      var preOptionKey = "";
      var preOptionValue = "";
      if( parent_group_name == "groupsend" || parent_group_name == "groupsend_without_post" ) {
        preOptionKey = this.group2SelectPreOptionKey;
        preOptionValue = this.group2SelectPreOptionValue;
      }
      var params = {
        url: url,
        key: this.groupSelectOptionKey,
        value: this.groupSelectOptionValue,
        //selectedId: this.initGroupName,
        preOptions: { key:preOptionKey, value:preOptionValue }
      };
      aimluck.io.createOptions(this.groupSelectId, params);
      
    },
    onMemberAddClick: function(/*Event*/ evt){
      this.addMember(dojo.byId(this.memberFromId), dojo.byId(this.memberToId));
    },
    onMemberRemoveClick: function(/*Event*/ evt){
       this.removeMemberSync(dojo.byId(this.memberToId));
    },
    onAllMemberRemoveClick: function(/*Event*/ evt){
       this.removeAllMemberWithoutSelect(dojo.byId(this.memberToId));
    }
});
