package aipo.webservice.util;

/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

import java.util.Calendar;
import java.util.Comparator;

import com.aimluck.eip.cayenne.om.portlet.EipTSchedule;
import com.aimluck.eip.cayenne.om.portlet.EipTScheduleMap;

/**
 * <HR>
 * スケジュール情報一覧昇順ソートクラス
 * <p>
 * 
 * スケジュールマップの時刻昇順による順序付け
 * <P>
 * <HR>
 * <P>
 * 
 */
public class EipTScheduleMapComparatorByTimeAsc implements
    Comparator<EipTScheduleMap> {

  /** 作業用カレンダー */
  private final Calendar cal = Calendar.getInstance();

  /*
   * (非 Javadoc)
   * 
   * @see java.util.Comparator#compare(T, T)
   */
  public int compare(EipTScheduleMap o1, EipTScheduleMap o2) {
    // 開始時刻を取得
    EipTSchedule s1 = o1.getEipTSchedule();
    cal.setTime(s1.getStartDate());
    int hour1 = cal.get(Calendar.HOUR_OF_DAY);
    int minute1 = cal.get(Calendar.MINUTE);

    EipTSchedule s2 = o2.getEipTSchedule();
    cal.setTime(s2.getStartDate());
    int hour2 = cal.get(Calendar.HOUR_OF_DAY);
    int minute2 = cal.get(Calendar.MINUTE);

    // 開始時刻で比較
    if (hour1 != hour2) {
      return hour1 - hour2;
    } else if (minute1 != minute2) {
      return minute1 - minute2;
    } else {
      // 終了時刻を取得
      cal.setTime(s1.getEndDate());
      hour1 = cal.get(Calendar.HOUR_OF_DAY);
      minute1 = cal.get(Calendar.MINUTE);

      cal.setTime(s2.getEndDate());
      hour2 = cal.get(Calendar.HOUR_OF_DAY);
      minute2 = cal.get(Calendar.MINUTE);

      // 終了時刻で比較
      if (hour1 != hour2) {
        return hour1 - hour2;
      } else if (minute1 != minute2) {
        return minute1 - minute2;
      }
    }

    return 0;
  }

}
