/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.account;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.account.util.AccountUtils;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.query.ALUserDirectSelectQuery;
import com.aimluck.eip.user.beans.UserGroupLiteBean;
import com.aimluck.eip.user.beans.UserGroupPositionLiteBean;
import com.aimluck.eip.user.util.UserUtils;
import com.aimluck.eip.util.ALEipUtils;

/**
 * ユーザーアカウントの検索データを管理するためのクラスです。 <br />
 * 
 */
public class AccountUserSelectData extends
    ALAbstractSelectData<TurbineUser, ALBaseUser> {

  /** logger */
  private static final JetspeedLogger logger =
    JetspeedLogFactoryService.getLogger(AccountUserSelectData.class.getName());

  /** 現在表示している部署 */
  private String currentPost;

  private int registeredUserNum;

  private boolean adminFilter;

  // add by motegi start 部署階層化
  // ログインユーザーの所属する部署
  private String current_group_name;

  // ログインユーザーの所属する部署の親部署
  private String current_parent_group_name;

  // 部署1プルダウンを選択されたかどうか（された：1 されない：null）
  private boolean isChangePost1;

  /**
   * 初期処理
   * 
   * @param action
   *            アクションクラス
   * @param rundata
   *            JetSpeedランデータ
   * @param context
   *            JetSpeedコンテキスト
   * @see com.aimluck.eip.common.ALAbstractSelectData#init(com.aimluck.eip.modules.actions.common.ALAction,
   *      org.apache.turbine.util.RunData, org.apache.velocity.context.Context)
   */
  @Override
  public void init(ALAction action, RunData rundata, Context context)
      throws ALPageNotFoundException, ALDBErrorException {
    // String sort = ALEipUtils.getTemp(rundata, context, LIST_SORT_STR);
    // if (sort == null || sort.equals("")) {
    // ALEipUtils.setTemp(rundata, context, LIST_SORT_STR, "userposition");
    // }
    super.init(action, rundata, context);

    // add by motegi start 部署階層化
    String ajax_search_corp =
      rundata.getRequest().getParameter("ajax_search_corp");
    if (ajax_search_corp == null || "".equals(ajax_search_corp)) {
      // 初期表示時
      String s1 =
        ALEipUtils.getTemp(rundata, context, "current_parent_group_name");
      if (s1 == null) {
        current_parent_group_name = "";
      } else {
        current_parent_group_name = s1;
      }
      String s2 = ALEipUtils.getTemp(rundata, context, "current_group_name");
      if (s2 == null) {
        current_group_name = "";
      } else {
        current_group_name = s2;
      }
      String s3 = ALEipUtils.getTemp(rundata, context, "change_post1");
      if (s3 == null || "".equals(s3)) {
        isChangePost1 = false;
      } else {
        isChangePost1 = true;
      }
      String s4 = ALEipUtils.getTemp(rundata, context, "adminfiltered");
      if ("1".equals(s4)) {
        adminFilter = true;
      } else {
        adminFilter = false;
      }
    } else {
      // プルダウン選択時
      String change_post1 = rundata.getRequest().getParameter("change_post1");
      if (change_post1 == null || "".equals(change_post1)) {
        isChangePost1 = false;
        // 部署1プルダウン以外を選択時
        current_parent_group_name =
          rundata.getRequest().getParameter("parent_group_name");
        current_group_name =
          rundata.getRequest().getParameter("post2_group_name");

        if ("ALL".equals(current_group_name)) {
          // 部署2プルダウンで”すべて”を選択された場合
          isChangePost1 = true;
        }
      } else {
        isChangePost1 = true;
        // 部署1プルダウンを選択時
        current_parent_group_name =
          rundata.getRequest().getParameter("parent_group_name");
        current_group_name = "";
      }

      // 管理者権限を持つユーザーだけを表示するフラグ取得
      adminFilter = rundata.getParameters().getBoolean("adminfiltered");

      ALEipUtils.setTemp(
        rundata,
        context,
        "current_parent_group_name",
        current_parent_group_name);
      ALEipUtils.setTemp(
        rundata,
        context,
        "current_group_name",
        current_group_name);
      ALEipUtils.setTemp(rundata, context, "change_post1", change_post1);
      ALEipUtils.setTemp(rundata, context, "adminfiltered", adminFilter
        ? "1"
        : "0");
    }

    // add end
  }

  /**
   * 一覧データを取得します。
   * 
   * @param rundata
   *            JetSpeedランデータ
   * @param context
   *            JetSpeedコンテキスト
   * @return ユーザー情報リスト
   * @see com.aimluck.eip.common.ALAbstractListData#selectData(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context)
   */
  // @Override
  // protected ResultList<TurbineUser> selectList(RunData rundata, Context
  // context) {
  // try {
  // // 登録済みのユーザ数をデータベースから取得
  //
  // SelectQuery<TurbineUser> query = getSelectQuery(rundata, context);
  // buildSelectQueryForListView(query);
  // buildSelectQueryForListViewSort(query, rundata, context);
  // ResultList<TurbineUser> list = query.getResultList();
  //
  // registeredUserNum = list.getTotalCount();
  // return list;
  // } catch (Exception ex) {
  // logger.error("Exception", ex);
  // return null;
  // }
  // }
  @Override
  protected ResultList<TurbineUser> selectList(RunData rundata, Context context) {

    try {

      // add by motegi
      if (current_group_name == null
        || (ALEipUtils.GROUPSEND_WITHOUT_POST.equals(current_parent_group_name) && ""
          .equals(current_group_name))) {
        // 部署が指定されていない、もしくは部署1で"グループ送信"を選択した場合は検索しない。
        return new ResultList<TurbineUser>();
      }
      // add end

      ALUserDirectSelectQuery query = new ALUserDirectSelectQuery();

      // システム管理のユーザー情報一覧では無効レコードも取得する。
      query.setContainDisabled(true);

      if (adminFilter) {
        query.setAdminOnly(true);
      }

      if (isChangePost1) {
        if (!"ALL".equals(current_parent_group_name)) {
          List<String> tmpList =
            ALEipUtils.getGroupNameList(current_parent_group_name, true);
          query.setGroupNames(tmpList);
        } else {
          // 部署１プルダウンで”すべて”を選択された場合は全検索
          query.setAll(true);
        }
      } else {
        if (ALEipUtils.GROUPSEND_WITHOUT_POST.equals(current_parent_group_name)) {
          query.setGroupSendId(current_group_name);
        } else {
          query.setGroupName(current_group_name);
        }
      }

      buildSelectQueryForListView(query);

      return query.getResultList();
    } catch (Exception ex) {
      logger.error("ユーザー情報の一覧取得に失敗しました。", ex);
      return null;
    }
  }

  // add start by motegi
  /**
   * ページング結果のリストを取得します。
   * 
   * @param records
   *            検索結果
   */
  protected void buildSelectQueryForListView(ALUserDirectSelectQuery query) {
    query.limit(getRowsNum());
    query.page(current_page);
  }

  // del start
  // /**
  // * 検索条件を設定した SelectQuery を返します。 <BR>
  // *
  // * @param rundata
  // * @param context
  // * @return
  // */
  // private SelectQuery<TurbineUser> getSelectQuery(RunData rundata,
  // Context context) {
  //
  // ObjectId oid =
  // new ObjectId("TurbineUser", TurbineUser.USER_ID_PK_COLUMN, 3);
  // Expression exp1 =
  // ExpressionFactory.matchAllDbExp(
  // oid.getIdSnapshot(),
  // Expression.GREATER_THAN);
  //
  // SelectQuery<TurbineUser> query =
  // Database.query(TurbineUser.class, exp1).where(
  // Operations.eq(TurbineUser.COMPANY_ID_PROPERTY, Integer.valueOf(1)),
  // Operations.ne(TurbineUser.DISABLED_PROPERTY, "T"));
  //
  // adminFilter = rundata.getParameters().getBoolean("adminfiltered");
  // if (adminFilter) {
  // try {
  // Group group = JetspeedSecurity.getGroup("LoginUser");
  // Role adminrole = JetspeedSecurity.getRole("admin");
  // List<TurbineUserGroupRole> admins =
  // Database
  // .query(TurbineUserGroupRole.class)
  // .where(
  // Operations.eq(
  // TurbineUserGroupRole.TURBINE_ROLE_PROPERTY,
  // adminrole.getId()),
  // Operations.eq(TurbineUserGroupRole.TURBINE_GROUP_PROPERTY, group
  // .getId()),
  // Operations.ne(TurbineUserGroupRole.TURBINE_USER_PROPERTY, 1))
  // .distinct(true)
  // .fetchList();
  // List<Integer> admin_ids = new ArrayList<Integer>();
  // admin_ids.add(Integer.valueOf(1));
  // for (TurbineUserGroupRole tugr : admins) {
  // admin_ids.add(tugr.getTurbineUser().getUserId());
  // }
  // query.andQualifier(ExpressionFactory.inDbExp(
  // TurbineUser.USER_ID_PK_COLUMN,
  // admin_ids));
  // } catch (Exception ex) {
  // logger.error("Exception", ex);
  // }
  // }
  //
  // String filter = ALEipUtils.getTemp(rundata, context, LIST_FILTER_STR);
  // current_filter = filter;
  //
  // Map<Integer, ALEipPost> gMap = ALEipManager.getInstance().getPostMap();
  // if (filter == null
  // || "".equals(filter)
  // || !gMap.containsKey(Integer.valueOf(filter))) {
  // return query;
  // }
  //
  // String groupName =
  // (ALEipManager.getInstance().getPostMap().get(Integer.valueOf(filter)))
  // .getGroupName()
  // .getValue();
  //
  // query.where(Operations.eq(TurbineUser.TURBINE_USER_GROUP_ROLE_PROPERTY
  // + "."
  // + TurbineUserGroupRole.TURBINE_GROUP_PROPERTY
  // + "."
  // + TurbineGroup.GROUP_NAME_PROPERTY, groupName));
  //
  // return query;
  // }
  // /**
  // * フィルタ用の <code>Criteria</code> を構築します。
  // *
  // * @param crt
  // * @param rundata
  // * @param context
  // * @return
  // */
  // @Override
  // protected SelectQuery<TurbineUser> buildSelectQueryForFilter(
  // SelectQuery<TurbineUser> query, RunData rundata, Context context) {
  // // 指定部署IDの取得
  // String filter = ALEipUtils.getTemp(rundata, context, LIST_FILTER_STR);
  //
  // // 指定部署が存在しているかを確認し、存在していなければ値を削除する
  // Map<Integer, ALEipPost> gMap = ALEipManager.getInstance().getPostMap();
  // if (filter != null
  // && filter.trim().length() != 0
  // && !gMap.containsKey(Integer.valueOf(filter))) {
  // filter = null;
  // }
  //
  // String filter_type =
  // ALEipUtils.getTemp(rundata, context, LIST_FILTER_TYPE_STR);
  // String crt_key = null;
  // Attributes map = getColumnMap();
  // if (filter == null || filter_type == null || filter.equals("")) {
  // return query;
  // }
  // crt_key = map.getValue(filter_type);
  // if (crt_key == null) {
  // return query;
  // }
  //
  // Expression exp = ExpressionFactory.matchDbExp(crt_key, filter);
  // query.andQualifier(exp);
  // current_filter = filter;
  // current_filter_type = filter_type;
  // return query;
  // }
  /**
   * 
   * @param id
   * @return
   */
  @SuppressWarnings("unused")
  private String getPostName(int id) {
    if (ALEipManager
      .getInstance()
      .getPostMap()
      .containsKey(Integer.valueOf(id))) {
      return (ALEipManager.getInstance().getPostMap().get(Integer.valueOf(id)))
        .getPostName()
        .getValue();
    }
    return null;
  }

  // /**
  // *
  // * @param id
  // * @return
  // */
  // @SuppressWarnings("unused")
  // private String getPositionName(int id) {
  // if (ALEipManager.getInstance().getPositionMap().containsKey(
  // Integer.valueOf(id))) {
  // return (ALEipManager.getInstance().getPositionMap().get(Integer
  // .valueOf(id))).getPositionName().getValue();
  // }
  // return null;
  // }
  /**
   * @param rundata
   * @param context
   * @return
   * @throws ALPageNotFoundException
   */
  @Override
  // change start
  // protected ALBaseUser selectDetail(RunData rundata, Context context) {
  // return AccountUtils.getBaseUser(rundata, context);
  // }
  protected ALBaseUser selectDetail(RunData rundata, Context context)
      throws ALPageNotFoundException {
    ALBaseUser user = AccountUtils.getBaseUser(rundata, context);
    if (user == null) {
      logger.error("ユーザー情報の詳細取得に失敗しました。");
      throw new ALPageNotFoundException();
    }
    return user;
  }

  // change end

  /**
   * ResultData に値を格納して返します。（一覧データ） <BR>
   * 
   * @param obj
   *            DBから取得したユーザー情報
   * @return 画面表示用データ
   * @throws ALDBErrorException
   * @see com.aimluck.eip.common.ALAbstractSelectData#getListData(java.lang.Object)
   */
  @Override
  protected Object getResultData(TurbineUser record) throws ALDBErrorException {
    try {
      // add start
      record = ALEipUtils.getTurbineUser(record.getUserId());
      // add end

      AccountResultData rd = new AccountResultData();
      rd.initField();
      rd.setUserId(record.getUserId().intValue());
      rd.setUserName(record.getLoginName());
      rd.setName(new StringBuffer()
        .append(record.getLastName())
        .append(" ")
        .append(record.getFirstName())
        .toString());
      rd.setPostNameList(ALEipUtils.getPostNameList(record.getUserId()));
      rd.setPositionName(ALEipUtils.getPositionName(record
        .getPositionId()
        .intValue()));
      rd.setDisabled(record.getDisabled());

      // add by motegi start 複数部署役職対応
      rd.setPostList(UserUtils.getPostPositionBeanList(record
        .getUserId()
        .intValue()));
      if (rd.getPostList().size() == 0) {
        // 部署役職が無いユーザーについては空のオブジェクトをセットする。
        UserGroupPositionLiteBean b = new UserGroupPositionLiteBean();
        b.initField();
        rd.addPostList(b);
      }

      // add by motegi start 部署階層化対応
      rd.setRoleList(UserUtils.getRoleBeanList(record.getUserId().intValue()));
      // add end

      // add by motegi start データ連携対応
      rd.setMailAccountList(UserUtils.getUserWebmailAccountLiteBeanList(record
        .getUserId()
        .intValue()));

      // add start
      rd.setDisplayName(record.getDisplayName());
      // add end

      return rd;
    } catch (Exception ex) {
      // change start
      // logger.error("Exception", ex);
      logger.error("ユーザー情報の一覧取得に失敗しました。", ex);
      // chaneg end
      return null;
    }
  }

  /**
   * 詳細データを取得します。 <BR>
   * 
   * @param rundata
   *            JetSpeedランデータ
   * @param context
   *            JetSpeedコンテキスト
   * @return DBから取得したユーザー情報
   * @throws ALDBErrorException
   * @see com.aimluck.eip.common.ALAbstractSelectData#selectDetail(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context)
   */
  @Override
  protected Object getResultDataDetail(ALBaseUser record)
      throws ALDBErrorException {
    try {
      Integer id = new Integer(record.getUserId());

      AccountResultData rd = new AccountResultData();
      rd.initField();
      rd.setUserId(Integer.valueOf(record.getUserId()).intValue());
      rd.setUserName(record.getUserName());
      // add start
      rd.setDisplayName(record.getDisplayName());
      // add end
      rd.setName(new StringBuffer()
        .append(record.getLastName())
        .append(" ")
        .append(record.getFirstName())
        .toString());
      rd.setNameKana(new StringBuffer()
        .append(record.getLastNameKana())
        .append(" ")
        .append(record.getFirstNameKana())
        .toString());
      rd.setEmail(record.getEmail());
      rd.setOutTelephone(record.getOutTelephone());
      rd.setInTelephone(record.getInTelephone());
      rd.setCellularPhone(record.getCellularPhone());
      rd.setCellularMail(record.getCellularMail());
      // change by motegi start 部署階層化対応
      // rd.setPostNameList(ALEipUtils.getPostNameList(id.intValue()));
      // rd.setPositionName(ALEipUtils.getPositionName(record.getPositionId()));
      rd.setPostList(UserUtils.getPostPositionBeanList(Integer.valueOf(record
        .getUserId())));
      if (rd.getPostList().size() == 0) {
        // 部署役職が無いユーザーについては空のオブジェクトをセットする。
        UserGroupPositionLiteBean b = new UserGroupPositionLiteBean();
        b.initField();
        rd.addPostList(b);
      }
      // change end
      rd.setDisabled(record.getDisabled());
      rd.setIsAdmin(ALEipUtils.isAdmin(Integer.valueOf(record.getUserId())));

      // add by motegi start 部署階層化対応
      rd.setRoleList(UserUtils.getRoleBeanList(Integer.parseInt(record
        .getUserId())));

      rd.setGroupSendList(UserUtils.getGroupSendBeanList(Integer
        .parseInt(record.getUserId())));
      // add end

      /** メールアドレスはWebメールアカウントを表示 add by motegi */
      rd.setMailAccountList(UserUtils.getUserWebmailAccountLiteBeanList(Integer
        .parseInt(record.getUserId())));

      rd.setCellularUid(record.getCelluarUId());

      rd.setCategoryName(record.getCategory());

      if (record.getPhoto() != null) {
        rd.setHasPhoto(true);
      } else {
        rd.setHasPhoto(false);
      }

      return rd;
    } catch (Exception ex) {
      // change start
      // logger.error("Exception", ex);
      // return null;
      logger.error("ユーザー情報の詳細取得に失敗しました。", ex);
      return null;
      // change end
    }
  }

  /**
   * ※未使用
   * 
   */
  @Override
  protected Attributes getColumnMap() {
    Attributes map = new Attributes();
    return map;
  }

  /**
   * 
   * @return
   */
  public String getCurrentPost() {
    return currentPost;
  }

  /**
   * 部署１リスト取得
   * 
   * @return 部署１リスト
   */
  // public Map<Integer, ALEipPost> getPostMap() {
  public List<ALEipPost> getPostMap() {
    // change by motegi start 部署階層化対応
    // return ALEipManager.getInstance().getPostMap();
    List<ALEipPost> list = ALEipUtils.getPostMap();

    ALEipPost p = new ALEipPost();
    p.initField();
    p.setGroupName("ALL");
    p.setPostName("すべて");
    list.add(0, p);

    return list;
    // change end
  }

  /**
   * 登録ユーザー数を取得する．
   * 
   * @return
   */
  public int getRegisteredUserNum() {
    return registeredUserNum;
  }

  public int getRandomNum() {
    SecureRandom random = new SecureRandom();
    return (random.nextInt() * 100);
  }

  public boolean isAdminFiltered() {
    return adminFilter;
  }

  // add by motegi start
  /**
   * 部署2プルダウン用データ取得処理
   * 
   * @return 部署2（or グループ送信）リスト
   */
  public List<UserGroupLiteBean> getChildGroupList() {

    if (current_parent_group_name != null
      && current_parent_group_name.length() > 0) {
      return UserUtils.getPost2LiteBeans(
        current_parent_group_name,
        true,
        true,
        true);
    }

    UserGroupLiteBean b = new UserGroupLiteBean();
    b.initField();
    b.setGroupId("0");
    b.setName("（選択して下さい）");
    List<UserGroupLiteBean> list = new ArrayList<UserGroupLiteBean>();
    list.add(b);
    return list;
  }

  /**
   * 表示対象部署２グループ名取得
   * 
   * @return 表示対象部署２グループ名
   */
  public String getCurrentGroupName() {
    return current_group_name;
  }

  /**
   * 表示対象部署１グループ名取得
   * 
   * @return 表示対象部署１グループ名
   */
  public String getCurrentParentGroupName() {
    return current_parent_group_name;
  }

}
