/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.addressbook;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.Transaction;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.commons.field.ALDateField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.commons.utils.ALStringUtil;
import com.aimluck.eip.addressbook.util.AddressBookUtils;
import com.aimluck.eip.addressbookuser.util.AddressBookUserUtils;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressGroup;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressbook;
import com.aimluck.eip.cayenne.om.portlet.EipTAddressbookGroupMap;
import com.aimluck.eip.common.ALAbstractFormWindow;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.accessctl.ALAccessControlConstants;
import com.aimluck.eip.services.eventlog.ALEventlogConstants;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;

/**
 * アドレス帳用入力フォームデータです。
 * 
 */
public class AddressBookFormData
// change start
    // 運用課題No.68
    // extends ALAbstractFormData {
    extends ALAbstractFormWindow {
  // change end

  private static final JetspeedLogger logger =
    JetspeedLogFactoryService.getLogger(AddressBookFormData.class.getName());

  // 所有グループのリスト
  private List<AddressBookGroupResultData> groupList;

  // このアドレスが登録されているグループ(グループオブジェクト格納)
  private List<Object> groups;

  // グループ名表示用フィールド(「、」区切りのグループ名)
  private ALStringField group_names;

  private ALStringField firstname;

  private ALStringField lastname;

  private ALStringField first_name_kana;

  // change start 2012.2.14
  // 受入障害No.285
  // private ALStringField last_name_kana;
  private String last_name_kana = null;

  // change end

  private ALStringField email;

  // 電話番号
  private ALStringField telephone1;

  // private ALStringField telephone2;

  // private ALStringField telephone3;

  // 携帯電話
  private ALStringField cellular_phone1;

  // private ALStringField cellular_phone2;

  // private ALStringField cellular_phone3;

  private ALStringField cellular_mail;

  private List<AddressBookCompanyResultData> companyList;

  private ALNumberField company_id;

  private ALStringField position_name;

  private ALStringField public_flag;

  private ALStringField note;

  private ALStringField create_user;

  private ALStringField update_user;

  private ALDateField create_date;

  private ALDateField update_date;

  // 会社情報
  private ALStringField company_name;

  // private ALStringField company_name_kana;

  // private ALStringField post_name;

  // private ALStringField comp_zipcode1;

  // private ALStringField comp_zipcode2;

  // private ALStringField comp_address;

  // private ALStringField comp_telephone1;

  // private ALStringField comp_telephone2;

  // private ALStringField comp_telephone3;

  // private ALStringField comp_fax_number1;

  // private ALStringField comp_fax_number2;

  // private ALStringField comp_fax_number3;

  // private ALStringField comp_url;

  private boolean is_new_company;

  private int loginuserid;

  // add start for Log
  private String login_name;

  // add end

  private int owner_id;

  // add by motegi start
  /** FAX番号 */
  private ALStringField fax_number1;

  /** FAX番号 */
  // private ALStringField fax_number2;
  /** FAX番号 */
  // private ALStringField fax_number3;
  // add end
  @Override
  public void init(ALAction action, RunData rundata, Context context)
      throws ALPageNotFoundException, ALDBErrorException {
    super.init(action, rundata, context);
    is_new_company = rundata.getParameters().getBoolean("is_new_company");

    loginuserid = ALEipUtils.getUserId(rundata);
    // add start
    login_name = ALEipUtils.getUserLoginName(loginuserid);
    // add end

    // add start 2012.2.14 受入障害対応No.285
    last_name_kana = rundata.getParameters().getString("last_name_kana");
    // add end
  }

  /**
   * 画面フィールド初期化
   * 
   * @see com.aimluck.eip.common.ALData#initField()
   */
  public void initField() {
    groups = new ArrayList<Object>();

    group_names = new ALStringField();

    lastname = new ALStringField();
    lastname.setFieldName("名前(姓)");
    lastname.setTrim(true);
    firstname = new ALStringField();
    firstname.setFieldName("名前(名)");
    firstname.setTrim(true);
    // remove start
    // 受入障害No.285
    // last_name_kana = new ALStringField();
    // last_name_kana.setFieldName("フリガナ(姓)");
    // last_name_kana.setTrim(true);
    // first_name_kana = new ALStringField();
    // first_name_kana.setFieldName("フリガナ(名)");
    // first_name_kana.setTrim(true);
    // remove end

    email = new ALStringField();
    email.setFieldName("メールアドレス");
    email.setTrim(true);

    // 電話番号
    telephone1 = new ALStringField();
    telephone1.setFieldName("電話番号");
    telephone1.setTrim(true);
    // del start
    // telephone2 = new ALStringField();
    // telephone2.setFieldName("電話番号");
    // telephone2.setTrim(true);
    // telephone3 = new ALStringField();
    // telephone3.setFieldName("電話番号");
    // telephone3.setTrim(true);
    // del end

    // 携帯番号
    cellular_phone1 = new ALStringField();
    cellular_phone1.setFieldName("電話番号（携帯）");
    cellular_phone1.setTrim(true);
    // del start
    // cellular_phone2 = new ALStringField();
    // cellular_phone2.setFieldName("電話番号（携帯）");
    // cellular_phone2.setTrim(true);
    // cellular_phone3 = new ALStringField();
    // cellular_phone3.setFieldName("電話番号（携帯）");
    // cellular_phone3.setTrim(true);
    // del end

    cellular_mail = new ALStringField();
    cellular_mail.setFieldName("携帯メールアドレス");
    cellular_mail.setTrim(true);
    company_id = new ALNumberField();
    company_id.setFieldName("会社");
    position_name = new ALStringField();
    position_name.setFieldName("役職");
    position_name.setTrim(true);
    public_flag = new ALStringField();
    public_flag.setFieldName("公開区分");
    public_flag.setTrim(true);
    create_user = new ALStringField();
    create_user.setFieldName("作成者");
    update_user = new ALStringField();
    update_user.setFieldName("更新者");
    create_date = new ALDateField();
    create_date.setFieldName("作成日");
    update_date = new ALDateField();
    update_date.setFieldName("最終更新日");

    // 会社情報
    company_name = new ALStringField();
    company_name.setFieldName("会社名");
    company_name.setTrim(true);
    // del start
    // company_name_kana = new ALStringField();
    // company_name_kana.setFieldName("会社名(フリガナ)");
    // company_name_kana.setTrim(true);
    // post_name = new ALStringField();
    // post_name.setFieldName("部署名");
    // post_name.setTrim(true);
    // comp_zipcode1 = new ALStringField();
    // comp_zipcode1.setFieldName("郵便番号");
    // comp_zipcode1.setTrim(true);
    // comp_zipcode2 = new ALStringField();
    // comp_zipcode2.setFieldName("郵便番号");
    // comp_zipcode2.setTrim(true);
    // comp_address = new ALStringField();
    // comp_address.setFieldName("住所");
    // comp_address.setTrim(true);
    // comp_telephone1 = new ALStringField();
    // comp_telephone1.setFieldName("電話番号");
    // comp_telephone1.setTrim(true);
    // comp_telephone2 = new ALStringField();
    // comp_telephone2.setFieldName("電話番号");
    // comp_telephone2.setTrim(true);
    // comp_telephone3 = new ALStringField();
    // comp_telephone3.setFieldName("電話番号");
    // comp_telephone3.setTrim(true);
    // comp_fax_number1 = new ALStringField();
    // comp_fax_number1.setFieldName("FAX番号");
    // comp_fax_number1.setTrim(true);
    // comp_fax_number2 = new ALStringField();
    // comp_fax_number2.setFieldName("FAX番号");
    // comp_fax_number2.setTrim(true);
    // comp_fax_number3 = new ALStringField();
    // comp_fax_number3.setFieldName("FAX番号");
    // comp_fax_number3.setTrim(true);
    // comp_url = new ALStringField();
    // comp_url.setFieldName("URL");
    // comp_url.setTrim(true);
    // del end

    // add by motegi start
    // FAX番号
    fax_number1 = new ALStringField();
    fax_number1.setFieldName("FAX番号");
    fax_number1.setTrim(true);

    note = new ALStringField();
    note.setFieldName("備考");
    // add end
  }

  /**
   * 自分がオーナーのグループを取得する。
   * 
   * @param rundata
   * @param context
   */
  // change start
  // public void loadGroupList(RunData rundata, Context context) {
  public boolean loadGroupList(RunData rundata, Context context) {
    // change end
    groupList = new ArrayList<AddressBookGroupResultData>();
    try {
      SelectQuery<EipMAddressGroup> query =
        Database.query(EipMAddressGroup.class);
      Expression exp =
        ExpressionFactory.matchExp(EipMAddressGroup.OWNER_ID_PROPERTY, Integer
          .valueOf(ALEipUtils.getUserId(rundata)));
      query.setQualifier(exp);
      // add start
      // 運用課題No.82
      // 会社名の昇順ソート
      query.orderAscending(EipMAddressGroup.GROUP_NAME_PROPERTY);
      // add end

      List<EipMAddressGroup> aList = query.fetchList();
      int size = aList.size();
      for (int i = 0; i < size; i++) {
        EipMAddressGroup record = aList.get(i);
        AddressBookGroupResultData rd = new AddressBookGroupResultData();
        rd.initField();
        rd.setGroupId(record.getGroupId().intValue());
        rd.setGroupName(record.getGroupName());
        groupList.add(rd);
      }

    } catch (Exception ex) {
      // change start
      // logger.error("Exception", ex);
      String msg = "プルダウン表示用の会社情報の一覧取得に失敗しました。[" + login_name + "]";
      logger.error(msg, ex);
      return false;
      // change end
    }
    // add start
    return true;
    // add ends
  }

  /**
   * 指定アドレスのグループを取得する。
   * 
   * @param rundata
   * @param context
   */
  // public void loadGroups(RunData rundata, Context context) {
  // try {
  // String addressid =
  // ALEipUtils.getTemp(rundata, context, ALEipConstants.ENTITY_ID);
  //
  // if (addressid == null || "".equals(addressid)) {
  // return;
  // }
  //
  // SelectQuery<EipTAddressbookGroupMap> query =
  // Database.query(EipTAddressbookGroupMap.class);
  // Expression exp1 =
  // ExpressionFactory.matchExp(
  // EipTAddressbookGroupMap.EIP_TADDRESS_GROUP_PROPERTY
  // + "."
  // + EipMAddressGroup.OWNER_ID_PROPERTY,
  // Integer.valueOf(ALEipUtils.getUserId(rundata)));
  // query.setQualifier(exp1);
  //
  // Expression exp2 =
  // ExpressionFactory.matchExp(
  // EipTAddressbookGroupMap.ADDRESS_ID_PROPERTY,
  // Integer.valueOf(addressid));
  // query.andQualifier(exp2);
  //
  // query.distinct(true);
  //
  // List<EipTAddressbookGroupMap> aList = query.fetchList();
  // int size = aList.size();
  // for (int i = 0; i < size; i++) {
  // EipTAddressbookGroupMap record = aList.get(i);
  // AddressBookGroupResultData rd = new AddressBookGroupResultData();
  // rd.initField();
  // rd.setGroupId(record.getEipTAddressGroup().getGroupId().intValue());
  // rd.setGroupName(record.getEipTAddressGroup().getGroupName());
  // groups.add(rd);
  // }
  // } catch (Exception ex) {
  // logger.error("Exception", ex);
  // }
  // }
  // public void loadCompanyList(RunData rundata, Context context) {
  // companyList = new ArrayList<AddressBookCompanyResultData>();
  // try {
  // SelectQuery<EipMAddressbookCompany> query =
  // Database.query(EipMAddressbookCompany.class);
  //
  // Expression exp02 =
  // ExpressionFactory.noMatchExp(
  // EipMAddressbookCompany.COMPANY_NAME_PROPERTY,
  // AddressBookUtils.EMPTY_COMPANY_NAME);
  // query.setQualifier(exp02);
  //
  // List<EipMAddressbookCompany> aList = query.fetchList();
  // int size = aList.size();
  // for (int i = 0; i < size; i++) {
  // EipMAddressbookCompany record = aList.get(i);
  // AddressBookCompanyResultData rd = new AddressBookCompanyResultData();
  // rd.initField();
  // rd.setCompanyId(record.getCompanyId().intValue());
  // rd.setCompanyName(record.getCompanyName() + " " + record.getPostName());
  // companyList.add(rd);
  // }
  //
  // } catch (Exception ex) {
  // logger.error("Exception", ex);
  // }
  // }
  /**
   * バリデーション初期化
   * 
   * @see com.aimluck.eip.common.ALAbstractFormData#setValidator()
   */
  @Override
  protected void setValidator() {
    lastname.setNotNull(true);
    lastname.limitMaxLength(50);
    firstname.setNotNull(true);
    firstname.limitMaxLength(50);

    // remove start 2012.2.14 受入障害対応No.285
    // last_name_kana.setNotNull(true);
    // last_name_kana.limitMaxLength(50);
    // first_name_kana.setNotNull(true);
    // first_name_kana.limitMaxLength(50);
    // remove end

    email.setCharacterType(ALStringField.TYPE_ASCII);
    email.limitMaxLength(64);
    // del start
    // telephone.setCharacterType(ALStringField.TYPE_ASCII);
    // telephone.limitMaxLength(13);
    // del end

    // 電話番号
    // change start
    // telephone1.setCharacterType(ALStringField.TYPE_NUMBER);
    // telephone1.limitMaxLength(5);
    // telephone2.setCharacterType(ALStringField.TYPE_NUMBER);
    // telephone2.limitMaxLength(4);
    // telephone3.setCharacterType(ALStringField.TYPE_NUMBER);
    // telephone3.limitMaxLength(4);
    telephone1.limitMaxLength(99);
    // change end

    // 携帯
    // change start
    // cellular_phone1.setCharacterType(ALStringField.TYPE_NUMBER);
    // cellular_phone1.limitMaxLength(5);
    // cellular_phone2.setCharacterType(ALStringField.TYPE_NUMBER);
    // cellular_phone2.limitMaxLength(4);
    // cellular_phone3.setCharacterType(ALStringField.TYPE_NUMBER);
    // cellular_phone3.limitMaxLength(4);
    cellular_phone1.limitMaxLength(99);
    // change end

    cellular_mail.setCharacterType(ALStringField.TYPE_ASCII);
    cellular_mail.limitMaxLength(50);
    position_name.limitMaxLength(50);

    // 会社情報
    if (is_new_company) {
      // 会社名
      company_name.setNotNull(true);
      company_name.limitMaxLength(50);

      // del start
      // 会社名カナ
      // company_name_kana.setNotNull(true);
      // company_name.limitMaxLength(50);
      // 部署名
      // post_name.limitMaxLength(50);
      // 会社郵便番号
      // comp_zipcode1.setCharacterType(ALStringField.TYPE_NUMBER);
      // comp_zipcode1.limitLength(3, 3);
      // comp_zipcode2.setCharacterType(ALStringField.TYPE_NUMBER);
      // comp_zipcode2.limitLength(4, 4);
      // 会社住所
      // comp_address.limitMaxLength(50);
      // 会社電話番号
      // comp_telephone1.setCharacterType(ALStringField.TYPE_NUMBER);
      // comp_telephone1.limitMaxLength(5);
      // comp_telephone2.setCharacterType(ALStringField.TYPE_NUMBER);
      // comp_telephone2.limitMaxLength(4);
      // comp_telephone3.setCharacterType(ALStringField.TYPE_NUMBER);
      // comp_telephone3.limitMaxLength(4);
      // 会社FAX番号
      // comp_fax_number1.setCharacterType(ALStringField.TYPE_NUMBER);
      // comp_fax_number1.limitMaxLength(5);
      // comp_fax_number2.setCharacterType(ALStringField.TYPE_NUMBER);
      // comp_fax_number2.limitMaxLength(4);
      // comp_fax_number3.setCharacterType(ALStringField.TYPE_NUMBER);
      // comp_fax_number3.limitMaxLength(4);
      // 会社URL
      // comp_url.setCharacterType(ALStringField.TYPE_ASCII);
      // comp_url.limitMaxLength(90);
      // del end
    }

    // add by motegi start
    // fax_number1.setCharacterType(ALStringField.TYPE_ASCII);
    fax_number1.limitMaxLength(99);
    // fax_number2.setCharacterType(ALStringField.TYPE_NUMBER);
    // fax_number2.limitMaxLength(4);
    // fax_number3.setCharacterType(ALStringField.TYPE_NUMBER);
    // fax_number3.limitMaxLength(4);

    note.setNotNull(false);
    note.limitMaxLength(1000);
    // add by motegi end
  }

  /**
   * バリデーション
   * 
   * @param msgList
   *          エラーメッセージリスト
   * @return 処理結果(正常：true、異常:false)
   * 
   * @see com.aimluck.eip.common.ALAbstractFormData#validate(java.util.ArrayList)
   */
  @Override
  protected boolean validate(List<String> msgList) {
    // remove start
    // List<String> dummy = new ArrayList<String>();
    // remove end
    lastname.validate(msgList);
    // remove start
    // firstname.validate(msgList);
    // remove end

    // フリガナのカタカナへの変換
    // change start 2012.2.14 受入障害対応No.285
    // last_name_kana.setValue(ALStringUtil.convertHiragana2Katakana(ALStringUtil
    // .convertH2ZKana(last_name_kana.toString())));
    // first_name_kana.setValue(ALStringUtil.convertHiragana2Katakana(ALStringUtil
    // .convertH2ZKana(first_name_kana.toString())));
    last_name_kana =
      (ALStringUtil.convertHiragana2Katakana(ALStringUtil
        .convertH2ZKana(last_name_kana.toString())));
    if (null != last_name_kana) {
      removeSpace(last_name_kana);
      if (last_name_kana.length() > 50) {
        msgList.add("『 <span class='em'>フリガナ</span> 』は50文字以下で入力してください。");
      }
    }
    // change end
    // remove start
    // last_name_kana.validate(msgList);
    // first_name_kana.validate(msgList);
    // remove end

    // メールアドレス
    email.validate(msgList);
    if (email.getValue().trim().length() > 0
      && !ALStringUtil.isMailAddress(email.getValue())) {
      msgList.add("『 <span class='em'>メールアドレス</span> 』を正しく入力してください。");
    }

    // 電話
    // change start
    // if (!telephone1.getValue().equals("")
    // || !telephone2.getValue().equals("")
    // || !telephone3.getValue().equals("")) {
    // if (!telephone1.validate(dummy)
    // || !telephone2.validate(dummy)
    // || !telephone3.validate(dummy)) {
    // msgList.add("『 <span class='em'>電話番号</span> 』を正しく入力してください。");
    // }
    // }
    telephone1.validate(msgList);
    // change end

    // 携帯電話
    // change start
    // if (!cellular_phone1.getValue().equals("")
    // || !cellular_phone2.getValue().equals("")
    // || !cellular_phone3.getValue().equals("")) {
    // if (!cellular_phone1.validate(dummy)
    // || !cellular_phone2.validate(dummy)
    // || !cellular_phone3.validate(dummy)) {
    // msgList.add("『 <span class='em'>電話番号（携帯）</span> 』を正しく入力してください。");
    // }
    // }
    cellular_phone1.validate(msgList);
    // change end

    // del by motegi start 個人アドレス帳対応
    // 携帯メールアドレス
    // cellular_mail.validate(msgList);
    // if (cellular_mail.getValue().trim().length() > 0
    // && !ALStringUtil.isCellPhoneMailAddress(cellular_mail.getValue())) {
    // msgList.add("『 <span class='em'>携帯メールアドレス</span> 』を正しく入力してください。");
    // }
    // del end

    position_name.validate(msgList);

    // 会社情報入力時用
    if (is_new_company) {
      company_name.validate(msgList);

      // add start 会社名重複チェック
      SelectQuery<EipMAddressGroup> query =
        Database.query(EipMAddressGroup.class);
      Expression exp1 =
        ExpressionFactory.matchExp(
          EipMAddressGroup.GROUP_NAME_PROPERTY,
          company_name.getValue());
      query.setQualifier(exp1);
      Expression exp2 =
        ExpressionFactory.matchExp(
          EipMAddressGroup.OWNER_ID_PROPERTY,
          loginuserid);
      query.andQualifier(exp2);

      if (query.fetchList().size() != 0) {
        msgList.add("社外グループ名『 <span class='em'>"
          + company_name
          + "</span> 』は既に登録されています。");
      }
      // add end

      // del by motegi start 個人アドレス帳対応
      // // 会社名フリガナのカタカナへの変換
      // company_name_kana.setValue(ALStringUtil
      // .convertHiragana2Katakana(ALStringUtil.convertH2ZKana(company_name_kana
      // .toString())));
      // company_name_kana.validate(msgList);
      //
      // post_name.validate(msgList);
      // // 会社郵便番号
      // if (!comp_zipcode1.getValue().equals("")
      // || !comp_zipcode2.getValue().equals("")) {
      // if (!comp_zipcode1.validate(dummy) || !comp_zipcode2.validate(dummy)) {
      // msgList.add("『 <span class='em'>郵便番号（会社）</span> 』を正しく入力してください。");
      // }
      // }
      // comp_address.validate(msgList);
      // // 会社電話番号
      // if (!comp_telephone1.getValue().equals("")
      // || !comp_telephone2.getValue().equals("")
      // || !comp_telephone3.getValue().equals("")) {
      // if (!comp_telephone1.validate(dummy)
      // || !comp_telephone2.validate(dummy)
      // || !comp_telephone3.validate(dummy)) {
      // msgList.add("『 <span class='em'>電話番号（会社）</span> 』を正しく入力してください。");
      // }
      // }
      // // 携帯電話
      // if (!comp_fax_number1.getValue().equals("")
      // || !comp_fax_number2.getValue().equals("")
      // || !comp_fax_number3.getValue().equals("")) {
      // if (!comp_fax_number1.validate(dummy)
      // || !comp_fax_number2.validate(dummy)
      // || !comp_fax_number3.validate(dummy)) {
      // msgList.add("『 <span class='em'>FAX番号（会社）</span> 』を正しく入力してください。");
      // }
      // }
      // comp_url.validate(msgList);
      // del end
    }

    // add by motegi start
    fax_number1.validate(msgList);
    note.validate(msgList);
    // add end

    return msgList.size() == 0;
  }

  /**
   * 個人アドレス情報編集画面表示処理
   * 
   * @param rundata
   *          JetSpeedランデータ
   * @param context
   *          JetSpeedコンテキスト
   * @param msgList
   *          エラーメッセージリスト
   * @return 処理結果(正常：true、異常:false)
   * 
   * @throws ALDBErrorException
   * @see com.aimluck.eip.common.ALAbstractFormData#loadFormData(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context, java.util.ArrayList)
   */
  @Override
  protected boolean loadFormData(RunData rundata, Context context,
      List<String> msgList) throws ALDBErrorException {
    try {
      // オブジェクトモデルを取得
      EipMAddressbook address =
        AddressBookUtils.getEipMAddressbook(rundata, context);
      if (address == null) {
        return false;
      }

      // add by motegi start 別ウインドウ化対応 ウインドウにエンティティIDを渡すため
      setEntityId(ALEipUtils
        .getTemp(rundata, context, ALEipConstants.ENTITY_ID));
      // add end

      // 登録ユーザ名の設定
      ALEipUser createdUser =
        ALEipUtils.getALEipUser(address.getCreateUserId().intValue());
      String createdUserName = createdUser.getAliasName().getValue();
      create_user.setValue(createdUserName);

      // 更新ユーザ名の設定
      String updatedUserName;
      if (address.getCreateUserId().equals(address.getUpdateUserId())) {
        updatedUserName = createdUserName;
      } else {
        ALEipUser updatedUser =
          ALEipUtils.getALEipUser(address.getUpdateUserId().intValue());
        updatedUserName = updatedUser.getAliasName().getValue();
      }
      update_user.setValue(updatedUserName);

      group_names.setValue(AddressBookUtils.getMyGroupNamesAsString(
        rundata,
        address.getAddressId().intValue(),
        ALEipUtils.getUserId(rundata)));

      // change by motegi start 個人アドレス帳対応
      // EipMAddressbookCompany company = address.getEipMAddressbookCompany();
      // if (company.getCompanyId().intValue() > 0) {
      // company_id.setValue(company.getCompanyId().intValue());
      // }
      EipMAddressGroup company =
        AddressBookUtils.getEipMAddressGroup(address.getAddressId());
      if (company != null && company.getGroupId().intValue() > 0) {
        company_id.setValue(company.getGroupId().intValue());
      }
      // change end

      // remove start 2012.2.14 受入障害対応No.285
      // firstname.setValue(address.getFirstName());
      // first_name_kana.setValue(address.getFirstNameKana());
      // remove end
      lastname.setValue(address.getLastName());
      // change start 2012.2.14 受入障害対応No.285
      // last_name_kana.setValue(address.getLastNameKana());
      last_name_kana = (address.getLastNameKana());
      // change end
      email.setValue(address.getEmail());
      // telephone.setValue(address.getTelephone());

      // 電話番号
      // change start
      // StringTokenizer token;
      // if (address.getTelephone() != null) {
      // token = new StringTokenizer(address.getTelephone(), "-");
      // if (token.countTokens() == 3) {
      // telephone1.setValue(token.nextToken());
      // telephone2.setValue(token.nextToken());
      // telephone3.setValue(token.nextToken());
      // }
      // }
      telephone1.setValue(address.getTelephone());
      // change end

      // 電話番号（携帯）
      // change start
      // if (address.getCellularPhone() != null) {
      // token = new StringTokenizer(address.getCellularPhone(), "-");
      // if (token.countTokens() == 3) {
      // cellular_phone1.setValue(token.nextToken());
      // cellular_phone2.setValue(token.nextToken());
      // cellular_phone3.setValue(token.nextToken());
      // }
      // }
      cellular_phone1.setValue(address.getCellularPhone());
      // change end

      // FAX番号 add by motegi start
      fax_number1.setValue(address.getFaxNumber());

      note.setValue(address.getNote());
      // add end

      cellular_mail.setValue(address.getCellularMail());
      position_name.setValue(address.getPositionName());
      public_flag.setValue(address.getPublicFlag());

      create_date.setValue(address.getCreateDate());
      // create_user.setValue(address.getCreateUserId()e)
      update_date.setValue(address.getUpdateDate());

      owner_id = address.getOwnerId();

    } catch (Exception ex) {
      // add start
      String msg = "個人アドレス情報の編集画面の表示に失敗しました。[" + login_name + "]";
      logger.error(msg, ex);
      // add end
      return false;
    }
    return true;
  }

  /**
   * 個人アドレス情報登録処理
   * 
   * @param rundata
   *          JetSpeedランデータ
   * @param context
   *          JetSpeedコンテキスト
   * @param msgList
   *          エラーメッセージリスト
   * @return 処理結果(正常：true、異常:false)
   * 
   * @see com.aimluck.eip.common.ALAbstractFormData#insertFormData(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context, java.util.ArrayList)
   */
  @Override
  protected boolean insertFormData(RunData rundata, Context context,
      List<String> msgList) {

    // add by motegi start アカウントのデフォルトフォルダに（ROOT）フォルダ追加に伴う
    // 標準のトランザクション（オートコミット）
    Transaction baseTx = Transaction.getThreadTransaction();

    DataContext dataContext = DataContext.getThreadDataContext();

    // 自己管理トランザクション
    Transaction tx =
      Transaction.internalTransaction(DataContext
        .getThreadDataContext()
        .getParentDataDomain()
        .getTransactionDelegate());

    // 標準のトランザクションを自己管理トランザクションに置き換えます。
    Transaction.bindThreadTransaction(tx);
    // add by motegi end

    // 作業ユーザIDの取得
    int uid = ALEipUtils.getUserId(rundata);
    try {

      // add by motegi start
      // トランザクション開始
      tx.begin();
      // add by motegi end

      // if (is_new_company) {
      // 会社情報の登録処理
      // del by motegi start 個人アドレス帳対応 社外アドレスグループを会社情報として扱う
      // if (!insertCompanyData(rundata, context)) {
      // }
      // }

      // アドレス情報の登録処理
      EipMAddressbook address = Database.create(EipMAddressbook.class);
      // 個人情報の設定
      address.setLastName(lastname.getValue());
      address.setFirstName(firstname.getValue());
      // address.setLastNameKana(last_name_kana.getValue());
      // address.setFirstNameKana(first_name_kana.getValue());
      address.setLastNameKana(last_name_kana);
      address.setEmail(email.getValue());

      // 電話
      // if (!telephone1.getValue().equals("")
      // && !telephone2.getValue().equals("")
      // && !telephone3.getValue().equals("")) {
      // address.setTelephone(new StringBuffer()
      // .append(telephone1.getValue())
      // .append("-")
      // .append(telephone2.getValue())
      // .append("-")
      // .append(telephone3.getValue())
      // .toString());
      // } else {
      // address.setTelephone("");
      // }

      // 携帯電話
      // if (!cellular_phone1.getValue().equals("")
      // && !cellular_phone2.getValue().equals("")
      // && !cellular_phone3.getValue().equals("")) {
      // address.setCellularPhone(new StringBuffer().append(
      // cellular_phone1.getValue()).append("-").append(
      // cellular_phone2.getValue()).append("-").append(
      // cellular_phone3.getValue()).toString());
      // } else {
      // address.setCellularPhone("");
      // }

      address.setTelephone(telephone1.getValue());
      address.setCellularPhone(cellular_phone1.getValue());
      address.setCellularMail(cellular_mail.getValue());
      // FAX番号 add by motegi start
      address.setFaxNumber(fax_number1.getValue());
      address.setNote(note.getValue());
      // add end

      address.setPositionName(position_name.getValue());

      // 会社の設定
      // del by motegi start 個人アドレス帳対応
      // boolean hasCompany = false;
      // if (company_id.getValue() > 0) {
      // EipMAddressbookCompany company =
      // Database.get(EipMAddressbookCompany.class, Integer
      // .valueOf((int) company_id.getValue()));
      // if (company.getCompanyId().intValue() > 0) {
      // // CompanyID が存在する場合
      // address.setEipMAddressbookCompany(company);
      // hasCompany = true;
      // }
      // }
      // if (!hasCompany) {
      // // 会社名でソートできるように、ダミーの会社情報を設定する。
      // EipMAddressbookCompany company =
      // AddressBookUtils.getDummyEipMAddressbookCompany(rundata, context);
      // address.setEipMAddressbookCompany(company);
      // }
      // del end

      // 公開区分の設定
      // change by motegi start 個人アドレス帳対応
      // address.setPublicFlag(public_flag.getValue());
      address.setPublicFlag("F");
      // change end

      // オーナIDの設定
      address.setOwnerId(Integer.valueOf(uid));
      address.setCreateUserId(Integer.valueOf(uid));
      address.setUpdateUserId(Integer.valueOf(uid));
      Date now = new Date();
      address.setCreateDate(now);
      address.setUpdateDate(now);

      // add by motegi start
      dataContext.commitChanges();
      // add by motegi end

      // add by motegi start 個人アドレス帳対応
      EipMAddressGroup group = null;
      if (is_new_company) {
        group = Database.create(EipMAddressGroup.class);
        rundata.getParameters().setProperties(group);
        group.setGroupName(company_name.getValue());
        group.setPublicFlag("F");
        group.setOwnerId(Integer.valueOf(uid));
        group.setCreateDate(now);
        group.setUpdateDate(now);

        // add by motegi start
        dataContext.commitChanges();
        // add by motegi end
      } else {
        if ((int) company_id.getValue() != 0) {
          group = Database.get(EipMAddressGroup.class, company_id.getValue());
        } else {
          group = AddressBookUserUtils.getDefaultEipMAddressGroup();
        }
      }

      // add end

      // change by motegi start
      // Database.commit();
      dataContext.commitChanges();
      // change by motegi end

      // Address-Groupマッピングテーブルへのデータ追加
      // Integer id = address.getAddressId();

      // change by motegi start 個人アドレス帳対応
      // for (int i = 0; i < groups.size(); i++) {
      // EipTAddressbookGroupMap map =
      // Database.create(EipTAddressbookGroupMap.class);
      // map.setEipMAddressbook(Database.get(EipMAddressbook.class, id));
      // map.setEipTAddressGroup((EipMAddressGroup) groups.get(i));
      // }
      if (group != null) {
        EipTAddressbookGroupMap map =
          Database.create(EipTAddressbookGroupMap.class);
        map.setEipMAddressbook(address);
        map.setEipTAddressGroup(group);
      }
      // change end

      dataContext.commitChanges();
      Database.commit();

      String name =
        new StringBuffer().append(lastname.getValue()).append(" ").append(
          firstname.getValue()).toString();

      // イベントログに保存
      ALEventlogFactoryService.getInstance().getEventlogHandler().log(
        address.getAddressId(),
        ALEventlogConstants.PORTLET_TYPE_ADDRESSBOOK,
        name);

      return true;
    } catch (Exception ex) {
      Database.rollback();
      String msg = "個人アドレス情報の登録に失敗しました。[" + login_name + "]";
      logger.error(msg, ex);
      msgList.add(msg);
      return false;
      // add by motegi start
    } finally {
      // 自己管理トランザクションを標準のトランザクションに戻します。
      Transaction.bindThreadTransaction(baseTx);
      // add by motegi end
    }
  }

  /**
   * 個人アドレス情報削除処理
   * 
   * @param rundata
   *          JetSpeedランデータ
   * @param context
   *          JetSpeedコンテキスト
   * @param msgList
   *          エラーメッセージリスト
   * @return 処理結果(正常：true、異常:false)
   * 
   * @see com.aimluck.eip.common.ALAbstractFormData#deleteFormData(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context, java.util.ArrayList)
   */
  @Override
  protected boolean deleteFormData(RunData rundata, Context context,
      List<String> msgList) {
    try {
      String addressid =
        ALEipUtils.getTemp(rundata, context, ALEipConstants.ENTITY_ID);
      if (addressid == null || Integer.valueOf(addressid) == null) {
        logger.debug("[AddressBook] Cannot find Address ID .");
        return false;
      }

      EipMAddressbook addressbook =
        Database.get(EipMAddressbook.class, Integer.valueOf(addressid));

      // entityIdの取得
      int entityId = addressbook.getAddressId();
      // 名前の取得
      String name =
        new StringBuffer()
          .append(addressbook.getLastName())
          .append(" ")
          .append(addressbook.getFirstName())
          .toString();

      Database.delete(addressbook);

      SelectQuery<EipTAddressbookGroupMap> query =
        Database.query(EipTAddressbookGroupMap.class);
      Expression exp =
        ExpressionFactory.matchExp(
          EipTAddressbookGroupMap.ADDRESS_ID_PROPERTY,
          Integer.valueOf(addressid));
      query.setQualifier(exp);

      List<EipTAddressbookGroupMap> maps = query.fetchList();
      Database.deleteAll(maps);

      Database.commit();

      // イベントログに保存
      ALEventlogFactoryService.getInstance().getEventlogHandler().log(
        entityId,
        ALEventlogConstants.PORTLET_TYPE_ADDRESSBOOK,
        name);
    } catch (Exception ex) {
      Database.rollback();
      String msg = "個人アドレス情報の削除に失敗しました。[" + login_name + "]";
      logger.error(msg, ex);
      msgList.add(msg);
      return false;
    }
    return true;
  }

  /**
   * 個人アドレス情報更新処理
   * 
   * @param rundata
   *          JetSpeedランデータ
   * @param context
   *          JetSpeedコンテキスト
   * @param msgList
   *          エラーメッセージリスト
   * @return 処理結果(正常：true、異常:false)
   * 
   * @see com.aimluck.eip.common.ALAbstractFormData#updateFormData(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context, java.util.ArrayList)
   */
  @Override
  protected boolean updateFormData(RunData rundata, Context context,
      List<String> msgList) {
    try {
      // 作業ユーザIDの取得
      int uid = ALEipUtils.getUserId(rundata);
      // del by motegi start 個人アドレス帳対応 社外アドレスグループを会社情報として扱う
      // if (is_new_company) {
      // if (!insertCompanyData(rundata, context)) {
      // }
      // }
      // 会社情報の登録処理終了

      // オブジェクトモデルを取得
      EipMAddressbook address =
        AddressBookUtils.getEipMAddressbook(rundata, context);
      if (address == null) {
        return false;
      }

      address.setLastName(lastname.getValue());
      address.setFirstName(firstname.getValue());
      // change start 2012.2.14 受入障害対応No.285
      // address.setLastNameKana(last_name_kana.getValue());
      // address.setFirstNameKana(first_name_kana.getValue());
      address.setLastNameKana(last_name_kana);
      // change end
      address.setEmail(email.getValue());
      // address.setTelephone(telephone.getValue());

      // 電話番号(外線)
      // del start
      // if (!telephone1.getValue().equals("")
      // && !telephone2.getValue().equals("")
      // && !telephone3.getValue().equals("")) {
      // address.setTelephone(new StringBuffer()
      // .append(telephone1.getValue())
      // .append("-")
      // .append(telephone2.getValue())
      // .append("-")
      // .append(telephone3.getValue())
      // .toString());
      // } else {
      // address.setTelephone("");
      // }
      // del end

      // 携帯電話
      // del start
      // if (!cellular_phone1.getValue().equals("")
      // && !cellular_phone2.getValue().equals("")
      // && !cellular_phone3.getValue().equals("")) {
      // address.setCellularPhone(new StringBuffer().append(
      // cellular_phone1.getValue()).append("-").append(
      // cellular_phone2.getValue()).append("-").append(
      // cellular_phone3.getValue()).toString());
      // } else {
      // address.setCellularPhone("");
      // }
      // del end

      // del by motegi start 個人アドレス帳対応
      // address.setCellularMail(cellular_mail.getValue());
      // del end

      // FAX番号 add by motegi start
      // if (!fax_number1.getValue().equals("")
      // && !fax_number2.getValue().equals("")
      // && !fax_number3.getValue().equals("")) {
      // address.setFaxNumber(new StringBuffer()
      // .append(fax_number1.getValue())
      // .append("-")
      // .append(fax_number2.getValue())
      // .append("-")
      // .append(fax_number3.getValue())
      // .toString());
      // } else {
      // address.setFaxNumber("");
      // }

      // add start
      address.setTelephone(telephone1.getValue());
      address.setCellularPhone(cellular_phone1.getValue());
      address.setCellularMail(cellular_mail.getValue());
      // FAX番号
      address.setFaxNumber(fax_number1.getValue());
      // 備考
      address.setNote(note.getValue());
      // add end

      // 会社の設定
      // del by motegi start 個人アドレス帳対応
      // boolean hasCompany = false;
      // if (company_id.getValue() > 0) {
      // EipMAddressbookCompany company =
      // Database.get(EipMAddressbookCompany.class, Integer
      // .valueOf((int) company_id.getValue()));
      // if (company.getCompanyId().intValue() > 0) {
      // // CompanyID が存在する場合
      // address.setEipMAddressbookCompany(company);
      // hasCompany = true;
      // }
      // }
      // if (!hasCompany) {
      // // 会社名でソートできるように、ダミーの会社情報を設定する。
      // EipMAddressbookCompany company =
      // AddressBookUtils.getDummyEipMAddressbookCompany(rundata, context);
      // address.setEipMAddressbookCompany(company);
      // }
      // del end

      address.setPositionName(position_name.getValue());

      // change by motegi start 個人アドレス帳対応
      // if (user_id == address.getOwnerId()) {
      // address.setPublicFlag(public_flag.getValue());
      // }
      address.setPublicFlag("F");
      // change end

      address.setUpdateUserId(Integer.valueOf(uid));
      address.setUpdateDate(new Date());

      // Address-Groupマッピングテーブルへのデータ追加

      String addressid =
        ALEipUtils.getTemp(rundata, context, ALEipConstants.ENTITY_ID);

      // 所属グループの全取得
      // remove start マップテーブルは未所属含めて一旦全削除する
      // SelectQuery<EipMAddressGroup> query1 =
      // Database.query(EipMAddressGroup.class);
      // Expression exp1 =
      // ExpressionFactory.matchExp(EipMAddressGroup.OWNER_ID_PROPERTY, Integer
      // .valueOf(uid));
      // query1.setQualifier(exp1);
      //
      // List<EipMAddressGroup> list = query1.fetchList();
      // int listsize = list.size();
      // Integer[] groupIds = new Integer[listsize];
      // for (int i = 0; i < listsize; i++) {
      // groupIds[i] = list.get(i).getGroupId();
      // }
      // remove end

      // Address-Group Mapテーブル情報を一旦削除
      // remove start マップテーブルは未所属含めて一旦全削除する
      // if (listsize != 0) {
      // remove end
      SelectQuery<EipTAddressbookGroupMap> query2 =
        Database.query(EipTAddressbookGroupMap.class);
      // remove start マップテーブルは未所属含めて一旦全削除する
      // Expression exp2 = ExpressionFactory.inDbExp("group_id", groupIds);
      // query2.setQualifier(exp2);
      // remove end
      Expression exp3 =
        ExpressionFactory.matchExp(
          EipTAddressbookGroupMap.ADDRESS_ID_PROPERTY,
          addressid);
      query2.setQualifier(exp3);

      List<EipTAddressbookGroupMap> maps = query2.fetchList();
      Database.deleteAll(maps);
      // remove start マップテーブルは未所属含めて一旦全削除する
      // }
      // remove end

      // del by motegi start 個人アドレス帳対応
      // Address-Group Mapテーブルへ指定された全グループを登録。
      // int groupsize = groups.size();
      // for (int i = 0; i < groupsize; i++) {
      // EipTAddressbookGroupMap map =
      // Database.create(EipTAddressbookGroupMap.class);
      // map.setEipMAddressbook(Database.get(EipMAddressbook.class, Integer
      // .valueOf(addressid)));
      // map.setEipTAddressGroup((EipMAddressGroup) groups.get(i));
      // }
      // del end

      // add by motegi start 個人アドレス帳対応
      EipMAddressGroup group = null;
      if (is_new_company) {
        Date now = new Date();
        group = Database.create(EipMAddressGroup.class);
        rundata.getParameters().setProperties(group);
        group.setGroupName(company_name.getValue());
        group.setPublicFlag("F");
        group.setOwnerId(Integer.valueOf(uid));
        group.setCreateDate(now);
        group.setUpdateDate(now);
      } else {
        if ((int) company_id.getValue() != 0) {
          group = Database.get(EipMAddressGroup.class, company_id.getValue());
        } else {
          group = AddressBookUserUtils.getDefaultEipMAddressGroup();
        }
      }

      if (group != null) {
        EipTAddressbookGroupMap map =
          Database.create(EipTAddressbookGroupMap.class);
        map.setEipMAddressbook(address);
        map.setEipTAddressGroup(group);
      }
      // add end

      Database.commit();

      String name =
        new StringBuffer().append(lastname.getValue()).append(" ").append(
          firstname.getValue()).toString();

      // イベントログに保存
      ALEventlogFactoryService.getInstance().getEventlogHandler().log(
        address.getAddressId(),
        ALEventlogConstants.PORTLET_TYPE_ADDRESSBOOK,
        name);

    } catch (Exception ex) {
      Database.rollback();
      String msg = "個人アドレス情報の更新に失敗しました。[" + login_name + "]";
      logger.error(msg, ex);
      msgList.add(msg);
      return false;
    }
    return true;
  }

  /**
   * フォームへデータをセットします。
   * 
   * @param rundata
   * @param context
   * @param msgList
   * @return
   * @throws ALPageNotFoundException
   * @throws ALDBErrorException
   */
  // del by motegi start 個人アドレス帳対応
  // @Override
  // protected boolean setFormData(RunData rundata, Context context,
  // List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
  // boolean res = super.setFormData(rundata, context, msgList);
  // groups = new ArrayList<Object>();
  // if (res) {
  // try {
  // String str[] = rundata.getParameters().getStrings("group_to");
  // if (str == null) {
  // return res;
  // }
  // if (isEmpty(str)) {
  // return res;
  // }
  //
  // SelectQuery<EipMAddressGroup> query =
  // Database.query(EipMAddressGroup.class);
  // Expression exp =
  // ExpressionFactory.inDbExp(EipMAddressGroup.GROUP_ID_PK_COLUMN, str);
  // query.setQualifier(exp);
  //
  // List<EipMAddressGroup> list = query.fetchList();
  // int size = list.size();
  // for (int i = 0; i < size; i++) {
  // EipMAddressGroup group = list.get(i);
  // groups.add(group);
  // }
  // } catch (Exception ex) {
  // logger.error("Exception", ex);
  // }
  // }
  // return res;
  // }
  // private boolean isEmpty(String str[]) {
  // boolean res = true;
  // for (int i = 0; i < str.length; i++) {
  // if (str[i] != null && !"".equals(str[i])) {
  // res = false;
  // }
  // }
  // return res;
  // }
  // del end
  public ALStringField getCellularMail() {
    return cellular_mail;
  }

  public ALStringField getCellularPhone1() {
    return cellular_phone1;
  }

  // public ALStringField getCellularPhone2() {
  // return cellular_phone2;
  // }
  //
  // public ALStringField getCellularPhone3() {
  // return cellular_phone3;
  // }

  public ALNumberField getCompanyId() {
    return company_id;
  }

  public ALStringField getEmail() {
    return email;
  }

  public ALStringField getFirstNameKana() {
    return first_name_kana;
  }

  public ALStringField getFirstName() {
    return firstname;
  }

  // public ALStringField getLastNameKana() {
  // return last_name_kana;
  // }
  public String getLastNameKana() {
    return last_name_kana;
  }

  public ALStringField getLastName() {
    return lastname;
  }

  public ALStringField getNote() {
    return note;
  }

  public ALStringField getPositionName() {
    return position_name;
  }

  public ALStringField getPublicFlag() {
    return public_flag;
  }

  // public ALStringField getTelephone() {
  // return telephone;
  // }

  public ALStringField getTelephone1() {
    return telephone1;
  }

  // public ALStringField getTelephone2() {
  // return telephone2;
  // }
  //
  // public ALStringField getTelephone3() {
  // return telephone3;
  // }

  public void setCellularMail(ALStringField field) {
    cellular_mail = field;
  }

  // public void setCellularPhone(ALStringField field) {
  // cellular_phone = field;
  // }

  public void setCompanyId(ALNumberField field) {
    company_id = field;
  }

  public void setEmail(ALStringField field) {
    email = field;
  }

  public void setFirstNameKana(ALStringField field) {
    first_name_kana = field;
  }

  public void setFirstName(ALStringField field) {
    firstname = field;
  }

  // public void setLastNameKana(ALStringField field) {
  // last_name_kana = field;
  // }

  public void setLastNameKana(String field) {
    last_name_kana = field;
  }

  public void setLastName(ALStringField field) {
    lastname = field;
  }

  public void setNote(ALStringField field) {
    note = field;
  }

  public void setPositionName(ALStringField field) {
    position_name = field;
  }

  public void setPublicFlag(ALStringField field) {
    public_flag = field;
  }

  // public void setTelephone(ALStringField field) {
  // telephone = field;
  // }

  public ALDateField getCreateDate() {
    return create_date;
  }

  public ALDateField getUpdateDate() {
    return update_date;
  }

  public void setCreateDate(ALDateField field) {
    create_date = field;
  }

  public ALStringField getCreateUser() {
    return create_user;
  }

  public void setUpdateDate(ALDateField field) {
    update_date = field;
  }

  public ALStringField getUpdateUser() {
    return update_user;
  }

  public List<AddressBookGroupResultData> getGroupList() {
    return groupList;
  }

  public List<AddressBookCompanyResultData> getCompanyList() {
    return companyList;
  }

  /**
   * @return
   */
  public ALStringField getGroupNames() {
    return group_names;
  }

  /**
   * @param field
   */
  public void setGroupNames(ALStringField field) {
    group_names = field;
  }

  public List<Object> getGroups() {
    return groups;
  }

  // 会社情報 getter
  public ALStringField getCompanyName() {
    return company_name;
  }

  // del start
  // public ALStringField getCompanyNameKana() {
  // return company_name_kana;
  // }
  //
  // public ALStringField getPostName() {
  // return post_name;
  // }
  //
  // public ALStringField getCompZipcode1() {
  // return comp_zipcode1;
  // }
  //
  // public ALStringField getCompZipcode2() {
  // return comp_zipcode2;
  // }
  //
  // public ALStringField getCompAddress() {
  // return comp_address;
  // }
  //
  // public ALStringField getCompTelephone1() {
  // return comp_telephone1;
  // }
  //
  // public ALStringField getCompTelephone2() {
  // return comp_telephone2;
  // }
  //
  // public ALStringField getCompTelephone3() {
  // return comp_telephone3;
  // }
  //
  // public ALStringField getCompFaxNumber1() {
  // return comp_fax_number1;
  // }
  //
  // public ALStringField getCompFaxNumber2() {
  // return comp_fax_number2;
  // }
  //
  // public ALStringField getCompFaxNumber3() {
  // return comp_fax_number3;
  // }
  //
  // public ALStringField getCompUrl() {
  // return comp_url;
  // }
  // del end

  /**
   * 会社情報一括登録を行うかを示す値を返す。
   * 
   * @return
   */
  public boolean isNewCompany() {
    return is_new_company;
  }

  /**
   * 現在ログイン中のユーザIDを返します。
   * 
   * @return
   */
  public int getUserId() {
    return loginuserid;
  }

  /**
   * オーナーIDを返します。
   * 
   * @return
   */
  public int getOwnerId() {
    return owner_id;
  }

  // ***************************************************************************
  // privateメソッド
  // ***************************************************************************

  /**
   * 会社情報を登録します。
   */
  // del by motegi start 個人アドレス帳対応 社外アドレスグループを会社情報として扱う
  // private boolean insertCompanyData(RunData rundata, Context context) {
  // int uid = ALEipUtils.getUserId(rundata);
  // try {
  // EipMAddressbookCompany company =
  // Database.create(EipMAddressbookCompany.class);
  // rundata.getParameters().setProperties(company);
  // company.setCompanyName(company_name.getValue());
  // company.setCompanyNameKana(company_name_kana.getValue());
  // company.setPostName(post_name.getValue());
  //
  // // 郵便番号の設定
  // if (!comp_zipcode1.getValue().equals("")
  // && !comp_zipcode2.getValue().equals("")) {
  // company.setZipcode(new StringBuffer()
  // .append(comp_zipcode1.getValue())
  // .append("-")
  // .append(comp_zipcode2.getValue())
  // .toString());
  // } else {
  // company.setZipcode("");
  // }
  //
  // company.setAddress(comp_address.getValue());
  //
  // // 電話番号の設定
  // if (!comp_telephone1.getValue().equals("")
  // && !comp_telephone2.getValue().equals("")
  // && !comp_telephone3.getValue().equals("")) {
  // company.setTelephone(new StringBuffer().append(
  // comp_telephone1.getValue()).append("-").append(
  // comp_telephone2.getValue()).append("-").append(
  // comp_telephone3.getValue()).toString());
  // } else {
  // company.setTelephone("");
  // }
  //
  // // FAX番号の設定
  // if (!comp_fax_number1.getValue().equals("")
  // && !comp_fax_number2.getValue().equals("")
  // && !comp_fax_number3.getValue().equals("")) {
  // company.setFaxNumber(new StringBuffer().append(
  // comp_fax_number1.getValue()).append("-").append(
  // comp_fax_number2.getValue()).append("-").append(
  // comp_fax_number3.getValue()).toString());
  // } else {
  // company.setFaxNumber("");
  // }
  //
  // company.setUrl(comp_url.getValue());
  // company.setCreateUserId(Integer.valueOf(uid));
  // company.setUpdateUserId(Integer.valueOf(uid));
  //
  // Date now = new Date();
  // company.setCreateDate(now);
  // company.setUpdateDate(now);
  //
  // Database.commit();
  //
  // // 会社IDの設定
  // company_id.setValue(company.getCompanyId().longValue());
  // } catch (Exception ex) {
  // Database.rollback();
  // logger.error("Exception", ex);
  // return false;
  // }
  // return true;
  // }
  // del end
  /**
   * アクセス権限チェック用メソッド。 アクセス権限の機能名を返します。
   * 
   * @return
   */
  @Override
  public String getAclPortletFeature() {
    return ALAccessControlConstants.POERTLET_FEATURE_ADDRESSBOOK_ADDRESS_OUTSIDE;
  }

  // add by motegi start
  /**
   * FAX番号を取得します。 <BR>
   * 
   * @return
   */
  public ALStringField getFaxNumber1() {
    return fax_number1;
  }

  // del start
  // /**
  // * FAX番号を取得します。 <BR>
  // *
  // * @return
  // */
  // public ALStringField getFaxNumber2() {
  // return fax_number2;
  // }
  //
  // /**
  // * FAX番号を取得します。 <BR>
  // *
  // * @return
  // */
  // public ALStringField getFaxNumber3() {
  // return fax_number3;
  // }
  // del end

  /**
   * アクセス権限をチェックします。
   * 
   * @return
   */
  @Override
  protected boolean doCheckAclPermission(RunData rundata, Context context,
      int defineAclType) throws ALPermissionException {
    boolean tmp = super.doCheckAclPermission(rundata, context, defineAclType);

    // 詳細表示、追加、削除は一覧表示の権限が必要
    if (defineAclType == ALAccessControlConstants.VALUE_ACL_DETAIL
      || defineAclType == ALAccessControlConstants.VALUE_ACL_INSERT
      || defineAclType == ALAccessControlConstants.VALUE_ACL_DELETE) {
      super.doCheckAclPermission(
        rundata,
        context,
        ALAccessControlConstants.VALUE_ACL_LIST);
      hasAuthority = (hasAuthority && tmp);
    }

    return true;
  }

  // add start 2012.2.14 受入障害対応No.285
  // ALStringフィールドを使用しないため
  // スペース除去メソッドをALStringから移植
  /**
   * 入力フィールド値の左右の全角スペースを削除します。
   * 
   * @param str
   * @return
   */
  private static String removeSpace(String str) {
    int len = str.length();
    int st = 0;
    char[] val = str.toCharArray();

    while ((st < len) && (val[st] <= ' ' || val[st] == 0x3000)) {
      st++;
    }
    while ((st < len) && (val[len - 1] <= ' ' || val[len - 1] == 0x3000)) {
      len--;
    }
    return ((st > 0) || (len < str.length())) ? str.substring(st, len) : str;
  }
  // add end 2012.2.14
}
