if(!dojo._hasResource["aipo.schedule.dnd.ScheduleToolTipFoundation"]){
dojo._hasResource["aipo.schedule.dnd.ScheduleToolTipFoundation"] = true;
/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://www.aipo.com/
 *
 * Copyright(C) 2012 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// リッチクライアントスケジュール用ツールチップ土台
dojo.provide("aipo.schedule.dnd.ScheduleToolTipFoundation");

/**
 * 通常予定用ツールチップの土台
 */
dojo.declare("aipo.schedule.dnd.ScheduleToolTipFoundation", null, {
     // ポートレットID
     portletId: null,
     // 親要素
     parentnode: null,
     // 親要素のドラッグ＆ドロップオブジェクト
     draggable: null,
     // 表示対象のツールチップ
     tooltipObject: null,
     /** コンストラクタ */
     constructor: function(/*String*/node, /*Array*/params){
        // paramsの内訳
        //    portletId:String:ポートレットID
        //    parentnode:String:親（表示元）要素ID
        //    draggable:Object:親要素のドラッグ＆ドロップオブジェクト
        this.portletId = params.pid;
        this.parentnode = params.parentnode;
        this.draggable = params.draggable;
        this.node = dojo.byId(node);
        this.events = [
            dojo.connect(this.node, "onmousedown", this, "onMouseDown"),
            dojo.connect(this.node, "onmouseover", this, "onMouseOver")
        ];
     },
     /** マウス押下 */
     onMouseDown: function(e){
        this.hide();
        if(this.parentnode == null || this.parentnode == "undefined"){return;}
        if(this.draggable){this.draggable.onMouseDown(e);}
     },
     /** マウスオーバー */
     onMouseOver: function(e){
        if(this.parentnode == null || this.parentnode == "undefined"){return;}
     },
     /** オブジェクト破棄 */
     destroy: function(){
        dojo.forEach(this.events, dojo.disconnect);
        this.events = this.node = this.handle = null;
    },
    /** 自身を隠す */
    hide: function(){
        dojo.marginBox (this.node,{ l: 0, t: -10000, w: 0, h: 0 });
    }
});

}