if(!dojo._hasResource["aipo.widget.EmbedDateCalendar"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["aipo.widget.EmbedDateCalendar"] = true;
/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://www.aipo.com/
 *
 * Copyright(C) 2012 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

dojo.provide("aipo.widget.EmbedDateCalendar");

dojo.require("dijit._Calendar");
dojo.require("aipo.widget.DateCalendar");

/**
 * 埋め込みカレンダー
 * 初期表示時、initValueに設定された日付のカレンダーを表示します。
 *
 * カレンダーで選択した日付は、「id=dateId」の要素にyyyy-mm-dd形式で設定されます。
 * カレンダーで日付を選択する際、前処理は「preSelectValue」後処理は「postSelectValue」が実行されます。それぞれ実行したい関数を代入して下さい。
 *
 * 外部から選択中の日付を変更したい場合は、changeBaseDateを実行します。
 *
 * 外部から表示内容の更新をしたい場合は、updateDisplayを実行します。
 * 表示内容の更新をする際、前処理は「preUpdateDisplay」メイン処理は「mainUpdateDisplay」後処理は「postUpdateDisplay」が実行されます。それぞれ実行したい関数を代入して下さい。
 * カレンダーの年か月を変更した際は、updateDisplayも実行され表示内容を更新します。
 *
 */
dojo.declare("aipo.widget.EmbedDateCalendar", aipo.widget.DateCalendar, {
    /** 日付設定先要素名 */
    dateId:"",
    /** 初期選択日付（yyyy-mm-dd形式） */
    initValue: "",
    /** エラーメッセージ出力先ID */
    errorAreaId: "",
    /**
     * Widget生成後処理
     * @see aipo.widget.DateCalendar#postCreate()
     */
    postCreate: function(){
        this.inherited(arguments);
        //this.changeBaseDate();
    },
    /** 表示更新前処理（コールバック関数を指定すること） */
    preUpdateDisplay: function(/*Date*/date){},
    /** 表示更新後処理（コールバック関数を指定すること） */
    postUpdateDisplay: function(/*Date*/date){},
    /**
     * 表示更新メイン処理
     * @param userId (任意)実行対象のユーザーID
     * @param url (任意)対象日取得URL
     * @param errorArea (任意)エラーメッセージ表示先
     */
    mainUpdateDisplay: function(/*String*/userId, /*String*/url, /*Element*/errorArea){},
    /**
     * カレンダーの状態更新
     * @param userId (任意)処理対象のユーザーID
     * @param url (任意)メイン処理用対象日取得URL
     * @param errorAreaId (任意)メイン処理用エラーメッセージ表示先ID
     */
    updateDisplay: function(/*String*/userId, /*String*/url, /*String*/errorAreaId){
        // エラーメッセージ出力先の確定
        var errorArea = null;
        if(errorAreaId == null || errorAreaId == ""){
            errorArea = dojo.byId(this.errorAreaId);
        }else{
            errorArea = dojo.byId(errorAreaId);
        }
        // 前処理、メイン処理、後処理の順で実行
        this.preUpdateDisplay();
        this.mainUpdateDisplay(userId, url, errorArea);
        this.postUpdateDisplay();
    },
    /**
     * 基準日付変更
     * @param dateString 基準日（yyyy-mm-dd形式の文字列）
     */
    changeBaseDate: function(/*String*/dateString){
        // 実行対象の基準日を確定
        var runDateString = null;
        if(dateString != null && dateString != ""){
            runDateString = dateString;
        }else{
            runDateString = this.initValue;
        }
        var baseDate = new Date();
        if(runDateString != null && runDateString != ""){
            var tmpdate = runDateString.split("-");
            if(tmpdate.length == 3){
                baseDate.setDate(1);
                baseDate.setFullYear(parseInt(tmpdate[0], 10));
                baseDate.setMonth(parseInt(tmpdate[1], 10)-1);
                baseDate.setDate(parseInt(tmpdate[2], 10));
                baseDate.setHours(0,0,0,0);
            }
        }
        // カレンダーウィジットの選択日付を変更
        this.setValue(baseDate);
        // 画面項目に初期日付を設定
        var yy = baseDate.getFullYear();
        var mm = baseDate.getMonth() + 1;
        var dd = baseDate.getDate();
        var dateValue = dojo.byId(this.dateId);
        if(dateValue){
            dateValue.value = yy + "-" + mm + "-" + dd;
        }
    },
    /** 日付選択前処理（コールバック関数を指定すること） */
    preSelectValue: function(/*Date*/date){},
    /** 日付選択後処理（コールバック関数を指定すること） */
    postSelectValue: function(/*Date*/date){},
    /**
     * 日付選択メイン処理
     * @param date 選択した日付
     */
    mainSelectValue: function(/*Date*/date){
        var yy = date.getFullYear();
        var mm = date.getMonth() + 1;
        var dd = date.getDate();

        var dateValue = dojo.byId(this.dateId);
        if(dateValue){
            dateValue.value = yy+"-"+mm+"-"+dd;
        }
    },
    /**
     * 日付選択
     * @param date 選択した日付
     * @see dijit._Calendar#onValueSelected(Date)
     */
    onValueSelected: function(/*date*/date){
        // 前処理、メイン処理、後処理の順で実行
        this.preSelectValue(date);
        this.mainSelectValue(date);
        this.postSelectValue(date);
    },
    /**
     * 日付変更
     * @param date 変更後の日付
     * @see dijit._Calendar#onChange(Date)
     */
    onChange: function(/*Date*/date){},
    /**
     * 年・月変更
     * @param part 変更対象（年：year/月：month）
     * @param amount 増減値
     * @see dijit._Calendar#_adjustDisplay(String, int)
     */
    _adjustDisplay: function(/*String*/part, /*int*/amount){
        this.displayMonth = dojo.date.add(this.displayMonth, part, amount);
        this._populateGrid();
        // カレンダー状態更新
        this.updateDisplay();

        // add start 要件No.15 スケジュール画面（月単位）カレンダー追加
        // スタイル更新
        this.postPopulateGrid();
        // add end
    },

    // add start 要件No.15 スケジュール画面（月単位）カレンダー追加
    /**
     * 値設定
     * @param value 日付
     * @see dijit._Calendar#setValue(Date)
     */
	setValue: function(/*Date*/ value){
		// summary: set the current date and update the UI.  If the date is disabled, the selection will
		//	not change, but the display will change to the corresponding month.
		if(!this.value || dojo.date.compare(value, this.value)){
			value = new Date(value);
			this.displayMonth = new Date(value);
			if(!this.isDisabledDate(value, this.lang)){
				this.value = value;
				this.value.setHours(0,0,0,0);
				this.onChange(this.value);
			}
			this._populateGrid();
			// スタイル更新
			this.postPopulateGrid();
		}
	},
    /**
     * スタイル更新
     */
	postPopulateGrid: function(){}
	// add end
});

}
