/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package aipo.batch.utils;

import org.apache.jetspeed.om.security.Group;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.om.security.Role;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.security.GroupManagement;
import org.apache.jetspeed.services.security.JetspeedSecurityCache;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.jetspeed.services.security.RoleException;

import com.aimluck.eip.cayenne.om.security.TurbineGroup;
import com.aimluck.eip.cayenne.om.security.TurbineRole;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.cayenne.om.security.TurbineUserGroupRole;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.services.security.ALRoleManagement;

/**
 * ロールを管理するクラスALRoleManagementのコピークラスです。<br>
 * grantRole、getRoleを変更しています。<br>
 */
public class ALBatchRoleUtils {

  private final static boolean cachingEnable = true;

  /**
   * 
   * @see {@link ALRoleManagement#grantRole(String, String)}
   */
  public static void grantRole(String username, String rolename)
      throws JetspeedSecurityException {
    grantRole(username, rolename, GroupManagement.DEFAULT_GROUP_NAME);
  }

  /**
   * コミット、ロールバックをコメントアウトしました。<br>
   * 
   * @see {@link ALRoleManagement#grantRole(String, String, String)}
   */
  public static void grantRole(String username, String rolename,
      String groupname) throws JetspeedSecurityException {
    try {
      JetspeedUser user = JetspeedSecurity.getUser(username);
      Role role = JetspeedSecurity.getRole(rolename);
      Group group = JetspeedSecurity.getGroup(groupname);

      // 新規オブジェクトモデル
      TurbineUserGroupRole user_group_role =
        Database.create(TurbineUserGroupRole.class);
      TurbineUser tuser =
        Database.get(TurbineUser.class, Integer.valueOf(user.getUserId()));
      user_group_role.setTurbineUser(tuser);
      user_group_role.setTurbineGroup((TurbineGroup) group);
      user_group_role.setTurbineRole((TurbineRole) role);
      // Database.commit();

      if (cachingEnable) {
        JetspeedSecurityCache.addRole(username, role, group);
      }
    } catch (Exception e) {
      // Database.rollback();
      throw new RoleException("Grant role '"
        + rolename
        + "' to user '"
        + username
        + "' failed: ", e);
    }
  }

}
