/*
 * D2DX
 * Copyright (C) SatisKia. All rights reserved.
 */

#ifndef _SOUNDDATA_HPP
#define _SOUNDDATA_HPP

#include <windows.h>

#include <d3dx9.h>
#ifdef _USE_DIRECTMUSIC
#include <dmusici.h>
#else
#include <mmreg.h>
#include <dsound.h>
#endif // _USE_DIRECTMUSIC

#include "_Object.hpp"

// OQ
class _Memory;

class _SoundData : public _Object
{
friend class _Main;

private:
#ifdef _USE_DIRECTMUSIC
	IDirectMusicSegment8* sound;
#else
	IDirectSoundBuffer* sound;
#endif // _USE_DIRECTMUSIC
	_Memory* data;

public:
	_SoundData();
	virtual ~_SoundData();

#ifdef _USE_DIRECTMUSIC
	void attach( IDirectMusicSegment8* sound );
#else
	void attach( IDirectSoundBuffer* sound );
#endif // _USE_DIRECTMUSIC

private:
	void Dispose();
public:

	BOOL isEnabled();
};

#endif // _SOUNDDATA_HPP
