/****************************************************
 * R a y  S p e e d e r                             *
 * Copyright (C) SatisFactory. All rights reserved. *
 ****************************************************/

#include "_Global.h"

#include "_Vector.hpp"

#include "Wave.hpp"

#include "Bar.hpp"

#define m g_main
#define g g_main->g

/**
 * RXgN^
 */
Wave::Wave() {
	bar = new _Vector();
}

/**
 * fXgN^
 */
Wave::~Wave() {
	delete bar;
}

/**
 * \z
 */
void Wave::create() {
	bar->removeAllElements();
}

/**
 * o[o^
 */
void Wave::add_bar(int x, int y, int col, int count, BOOL border) {
	bar->addElement(new Bar(x, y, col, count, border));
}
void Wave::add_bar(int x, int y, int col) {
	bar->addElement(new Bar(x, y, col, 0, FALSE));
}

/**
 * o[Ȃǂ
 */
BOOL Wave::clear() {
	if ( bar->size() <= 0 ) return TRUE;
	return FALSE;
}

int Wave::top_x() {
	int x = 0;
	int y = 480;
	for ( int i = bar->size() - 1; i >= 0; i-- ) {
		Bar* tmp = (Bar*)bar->elementAt(i);
		if ( tmp->y() < y ) {
			y = tmp->y();
			x = tmp->x();
		}
	}
	return x;
}
int Wave::bottom_x() {
	int x = 0;
	int y = 0;
	for ( int i = bar->size() - 1; i >= 0; i-- ) {
		Bar* tmp = (Bar*)bar->elementAt(i);
		if ( tmp->y() > y ) {
			y = tmp->y();
			x = tmp->x();
		}
	}
	return x;
}

/**
 * EF[uf[^XV
 */
void Wave::update() {
	for ( int i = bar->size() - 1; i >= 0; i-- ) {
		Bar* tmp = (Bar*)bar->elementAt(i);
		if ( !tmp->update() ) {
			bar->removeElementAt(i);
		}
	}
}

/**
 * `
 */
int Wave::draw() {
	int cnt = 0;
	for ( int i = bar->size() - 1; i >= 0; i-- ) {
		Bar* tmp = (Bar*)bar->elementAt(i);
		if ( tmp->col() == 3 ) {
			cnt += m->drawImage2(m->use_image(DATA_BAR), 296 - (m->speeder[0]->x() - tmp->x()), tmp->y(), 0, 24 * ((m->elapse() / 2) % 3), 400, 24);
			g->setROP(_ROP_ADD);
			g->drawImage(m->use_image(DATA_BAR2), 296 - (m->speeder[0]->x() - tmp->x()), tmp->y(), 0, 24 * ((m->elapse() / 2) % 3), 400, 24);
			g->setROP(_ROP_COPY);
			g->drawImage(m->use_image(DATA_BAR), 296 - (m->speeder[0]->x() - tmp->x()) - 48, tmp->y() - 12, 48 * tmp->count(), 144, 48, 48);
			g->drawImage(m->use_image(DATA_BAR), 296 - (m->speeder[0]->x() - tmp->x()) + 400, tmp->y() - 12, 48 * tmp->count(), 144, 48, 48);
		} else {
			cnt += m->drawImage2(m->use_image(DATA_BAR), 296 - (m->speeder[0]->x() - tmp->x()), tmp->y(), 0, 24 * tmp->col(), 400, 24);
			g->setROP(_ROP_ADD);
			g->drawImage(m->use_image(DATA_BAR2), 296 - (m->speeder[0]->x() - tmp->x()), tmp->y(), 0, 24 * tmp->col(), 400, 24);
			g->setROP(_ROP_COPY);
		}
	}
	if ( abs(cnt) == bar->size() ) {
		return cnt;
	}
	return 0;
}
