/*
 * 쐬: 2007/11/30
 * 쌠: Copyright (c) 2007 kry
 * CZXFEclipse Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/epl-v10.html
 */
package kry.sql.format.rule;

import java.util.Arrays;

import kry.sql.constant.AbstractSqlconstant;
import kry.sql.constant.IDBType;
import kry.sql.token.TokenUtil;
import kry.sql.util.ArrayUtil;
import kry.sql.util.StringUtil;

/**
 * @author kry
 *
 */
public abstract class AbstractSqlFormatRule extends AbstractSqlconstant
		implements ISqlFormatRule, IDBType {

	/**
	 * ݒ荀
	 */
	// L[[hϊ
	private int convertKeyword = CONVERT_STRING_UPPERCASE;

	// Oϊ
	private int convertName = CONVERT_STRING_NONE;

	// Cfg
	private String indentString = "    ";

	// o͉sϊ
	private int outNewLineCode = NEWLINE_CODE_SYSTEM;

	// o͉sR[h
	private String outNewLineCodeStr = TokenUtil.NEW_LINE_SYSTEM;

	// o͉sR[h
	private char outNewLineEnd = TokenUtil.NEW_LINE_SYSTEM
			.charAt(TokenUtil.NEW_LINE_SYSTEM.length() - 1);

	// oSQL؂蕶ϊ
	private int outSqlSeparator = SQL_SEPARATOR_SLASH;

	// oSQL؂蕶
	private char outSqlSeparatorChar = '/';

	// s w,xOɉs邩
	private boolean newLineBeforeComma = true;

	// s wAND ORxOɉs邩
	private boolean newLineBeforeAndOr = true;

	// s f[^^()s邩
	private boolean newLineDataTypeParen = false;

	// s ֐()s邩
	private boolean newLineFunctionParen = false;

	// DECODEtH[}bg CASECNɉs
	private boolean decodeSpecialFormat = true;

	// INtH[}bg ʓl݂̂̏ꍇ́AsȂ
	private boolean inSpecialFormat = true;

	// BETWEENtH[}bg BETWEENANDsACfgB
	private boolean betweenSpecialFormat = false;

	// Rg폜邩
	private boolean removeComment = false;

	// 󔒍s폜邩
	private boolean removeEmptyLine = false;

	// 󔒍sCfg邩
	private boolean indentEmptyLine = false;

	// s܂Ԃ邩
	private boolean wordBreak = false;

	// sw
	private int width = 80;

	// ʑÕXy[X}邩
	private boolean insertParenSpace = false;

	// \
	private String[] reservedWords = RESERVED_WORDS;

	// ֐
	private String[] functions = FUNCTIONS;

	// f[^^
	private String[] dataTypes = DATA_TYPES;

	// SQL
	private String[] sqlStartStatements = SQL_STATEMENTS;

	// }`L[[h
	private String[] multiKeyWords = MULTI_KEYWORDS;

	// L
	private String[] symbols = SYMBOLS;
	private char[] symbolChars;

	// Zq
	private String[] operators = OPERATORS;
	private char[] operatorChars;

	// Rg
	private String[] singleLineComments = SINGLE_LINE_COMMENTS;

	/**
	 * RXgN^
	 */
	public AbstractSqlFormatRule() {
		this.convertKeyword = CONVERT_STRING_UPPERCASE;
		this.convertName = CONVERT_STRING_NONE;
		this.indentString = "    ";
		this.outNewLineCode = NEWLINE_CODE_SYSTEM;
		this.outNewLineCodeStr = TokenUtil.NEW_LINE_SYSTEM;
		this.outNewLineEnd = TokenUtil.NEW_LINE_SYSTEM
				.charAt(TokenUtil.NEW_LINE_SYSTEM.length() - 1);
		this.outSqlSeparator = SQL_SEPARATOR_SLASH;
		this.outSqlSeparatorChar = '/';
		this.newLineBeforeComma = true;
		this.newLineBeforeAndOr = true;
		this.newLineDataTypeParen = false;
		this.newLineFunctionParen = false;
		this.decodeSpecialFormat = false;
		this.inSpecialFormat = true;
		this.betweenSpecialFormat = false;
		this.removeComment = false;
		this.removeEmptyLine = false;
		this.indentEmptyLine = false;
		this.wordBreak = false;
		this.width = 80;
		this.insertParenSpace = false;

		this.setReservedWords(RESERVED_WORDS);
		this.setDataTypes(DATA_TYPES);
		this.setFunctions(FUNCTIONS);
		this.setSqlStartStatements(SQL_STATEMENTS);
		this.setMultiKeyWords(MULTI_KEYWORDS);
		this.setSymbols(SYMBOLS);
		this.setOperators(OPERATORS);
		this.setSingleLineComments(SINGLE_LINE_COMMENTS);

		initiarize();
	}

	/**
	 * 
	 */
	protected void initiarize() {
		// L
		this.symbolChars = StringUtil.getCharTable(this.symbols).toCharArray();
		Arrays.sort(this.symbolChars);

		// Zq
		this.operatorChars = StringUtil.getCharTable(this.operators)
				.toCharArray();
		Arrays.sort(this.operatorChars);

		// o͉s
		setOutNewLineStr();
	}

	public abstract boolean isNameChar(char c);

	/**
	 * tH[}bg[𐶐܂B
	 *
	 * @param dbType
	 * @return
	 */
	public static ISqlFormatRule createSqlFormatRule() {
		return createSqlFormatRule(-1);
	}

	public static ISqlFormatRule createSqlFormatRule(int dbType) {
		ISqlFormatRule rule = null;

		switch (dbType) {
		case IDBType.ORACLE:
			rule = new OracleSqlFormatRule();
			break;

		case IDBType.SYMFOWARE:
		case IDBType.MYSQL:
		case IDBType.POSTGRE_SQL:
		case IDBType.SQL_SERVER:
		case IDBType.DERBY:
		case IDBType.HSQLDB:
		case IDBType.DB2:
		default:
			rule = new OracleSqlFormatRule();
			break;
		}

		return rule;
	}

	public int getConvertKeyword() {
		return convertKeyword;
	}

	public void setConvertKeyword(int convertKeyword) {
		this.convertKeyword = convertKeyword;
	}

	public int getConvertName() {
		return convertName;
	}

	public void setConvertName(int convertName) {
		this.convertName = convertName;
	}

	public String getIndentString() {
		return indentString;
	}

	public void setIndentString(String indentString) {
		if (indentString == null)
			indentString = "";
		this.indentString = indentString;
	}

	public int getOutNewLineCode() {
		return outNewLineCode;
	}

	public void setOutNewLineCode(int outNewLineCode) {
		this.outNewLineCode = outNewLineCode;

		// sݒ
		setOutNewLineStr();
	}

	public String getOutNewLineStr() {
		return this.outNewLineCodeStr;
	}

	private void setOutNewLineStr() {
		// sݒ
		switch (this.outNewLineCode) {
		case NEWLINE_CODE_SYSTEM:
			this.outNewLineCodeStr = TokenUtil.NEW_LINE_SYSTEM;
			break;

		case NEWLINE_CODE_CRLF:
		case NEWLINE_CODE_CR:
		case NEWLINE_CODE_LF:
			this.outNewLineCodeStr = TokenUtil.NEW_LINES[this.outNewLineCode - 1];
			break;
		}

		// sR[hݒ
		setOutNewLineEnd();
	}

	private void setOutNewLineEnd() {
		// sR[hݒ
		this.outNewLineEnd = this.outNewLineCodeStr
				.charAt(this.outNewLineCodeStr.length() - 1);
	}

	public char getOutNewLineEnd() {
		return outNewLineEnd;
	}

	public int getOutSqlSeparator() {
		return outSqlSeparator;
	}

	public void setOutSqlSeparator(int outSqlSeparator) {
		this.outSqlSeparator = outSqlSeparator;

		switch (this.outSqlSeparator) {
		case SQL_SEPARATOR_SLASH:
			this.outSqlSeparatorChar = '/';
			break;

		case SQL_SEPARATOR_SEMICOLON:
			this.outSqlSeparatorChar = ';';
			break;

		case SQL_SEPARATOR_NONE:
		default:
			break;
		}
	}

	public boolean isNewLineBeforeComma() {
		return newLineBeforeComma;
	}

	public void setNewLineBeforeComma(boolean newLineBeforeComma) {
		this.newLineBeforeComma = newLineBeforeComma;
	}

	public boolean isNewLineBeforeAndOr() {
		return newLineBeforeAndOr;
	}

	public void setNewLineBeforeAndOr(boolean newLineBeforeAndOr) {
		this.newLineBeforeAndOr = newLineBeforeAndOr;
	}

	public boolean isNewLineDataTypeParen() {
		return newLineDataTypeParen;
	}

	public void setNewLineDataTypeParen(boolean newLineDataTypeParen) {
		this.newLineDataTypeParen = newLineDataTypeParen;
	}

	public boolean isNewLineFunctionParen() {
		return newLineFunctionParen;
	}

	public void setNewLineFunctionParen(boolean newLineFunctionParen) {
		this.newLineFunctionParen = newLineFunctionParen;
	}

	public boolean isDecodeSpecialFormat() {
		return decodeSpecialFormat;
	}

	public void setDecodeSpecialFormat(boolean decodeSpecialFormat) {
		this.decodeSpecialFormat = decodeSpecialFormat;
	}

	public boolean isInSpecialFormat() {
		return inSpecialFormat;
	}

	public void setInSpecialFormat(boolean inSpecialFormat) {
		this.inSpecialFormat = inSpecialFormat;
	}

	public boolean isBetweenSpecialFormat() {
		return betweenSpecialFormat;
	}

	public void setBetweenSpecialFormat(boolean betweenSpecialFormat) {
		this.betweenSpecialFormat = betweenSpecialFormat;
	}

	public boolean isRemoveComment() {
		return removeComment;
	}

	public void setRemoveComment(boolean removeComment) {
		this.removeComment = removeComment;
	}

	public boolean isRemoveEmptyLine() {
		return removeEmptyLine;
	}

	public void setRemoveEmptyLine(boolean removeEmptyLine) {
		this.removeEmptyLine = removeEmptyLine;
	}

	public boolean isIndentEmptyLine() {
		return indentEmptyLine;
	}

	public void setIndentEmptyLine(boolean indentEmptyLine) {
		this.indentEmptyLine = indentEmptyLine;
	}

	public boolean isWordBreak() {
		return wordBreak;
	}

	public void setWordBreak(boolean wordBreak) {
		this.wordBreak = wordBreak;
	}

	public int getWidth() {
		return width;
	}

	public void setWidth(int width) {
		this.width = width;
	}

	public boolean isInsertParenSpace() {
		return insertParenSpace;
	}

	public void setInsertParenSpace(boolean insertParenSpace) {
		this.insertParenSpace = insertParenSpace;
	}

	public String[] getReservedWords() {
		return reservedWords;
	}

	public void setReservedWords(String[] reservedWords) {
		Arrays.sort(reservedWords);
		this.reservedWords = reservedWords;
	}

	public void addReservedWords(String[] reservedWords) {
		reservedWords = StringUtil.toUpperCase(reservedWords);
		this.reservedWords = (String[]) ArrayUtil.add(this.reservedWords,
				reservedWords, new String[0]);
	}

	public void subtractReservedWords(String[] reservedWords) {
		reservedWords = StringUtil.toUpperCase(reservedWords);
		this.reservedWords = (String[]) ArrayUtil.subtract(this.reservedWords,
				reservedWords, new String[0]);
	}

	public String[] getDataTypes() {
		return dataTypes;
	}

	public void setDataTypes(String[] dataTypes) {
		Arrays.sort(dataTypes);
		this.dataTypes = dataTypes;
	}

	public void addDataTypes(String[] dataTypes) {
		dataTypes = StringUtil.toUpperCase(dataTypes);
		this.dataTypes = (String[]) ArrayUtil.add(this.dataTypes, dataTypes,
				new String[0]);
	}

	public void subtractDataTypes(String[] dataTypes) {
		dataTypes = StringUtil.toUpperCase(dataTypes);
		this.dataTypes = (String[]) ArrayUtil.subtract(this.dataTypes,
				dataTypes, new String[0]);
	}

	public String[] getFunctions() {
		return this.functions;
	}

	public void setFunctions(String[] functions) {
		Arrays.sort(functions);
		this.functions = functions;
	}

	public void addFunctions(String[] functions) {
		functions = StringUtil.toUpperCase(functions);
		this.functions = (String[]) ArrayUtil.add(this.functions, functions,
				new String[0]);
	}

	public void subtractFunctions(String[] functions) {
		functions = StringUtil.toUpperCase(functions);
		this.functions = (String[]) ArrayUtil.subtract(this.functions,
				functions, new String[0]);
	}

	public String[] getSqlStartStatements() {
		return sqlStartStatements;
	}

	public void setSqlStartStatements(String[] sqlStartStatements) {
		Arrays.sort(sqlStartStatements);
		this.sqlStartStatements = sqlStartStatements;
	}

	public String[] getMultiKeyWords() {
		return multiKeyWords;
	}

	public void setMultiKeyWords(String[] multiKeyWords) {
		Arrays.sort(multiKeyWords);
		this.multiKeyWords = multiKeyWords;
	}

	public String[] getSymbols() {
		return symbols;
	}

	public void setSymbols(String[] symbols) {
		Arrays.sort(symbols);
		this.symbols = symbols;
	}

	public String[] getOperators() {
		return operators;
	}

	public void setOperators(String[] operators) {
		Arrays.sort(operators);
		this.operators = operators;
	}

	public String[] getSingleLineComments() {
		return singleLineComments;
	}

	public void setSingleLineComments(String[] singleLineComments) {
		Arrays.sort(singleLineComments);
		this.singleLineComments = singleLineComments;
	}

	/**
	 * L[[hł邩Ԃ܂B
	 *
	 * @param str
	 * @return
	 */
	public boolean isKeywords(String str) {
		return (Arrays.binarySearch(this.reservedWords, str) >= 0)
				|| (Arrays.binarySearch(this.dataTypes, str) >= 0)
				|| (Arrays.binarySearch(this.functions, str) >= 0)
				|| (Arrays.binarySearch(this.multiKeyWords, str) >= 0);
	}

	/**
	 * \ł邩Ԃ܂B
	 *
	 * @param str
	 * @return
	 */
	public boolean isReservedWords(String str) {
		return (Arrays.binarySearch(this.reservedWords, str) >= 0);
	}

	/**
	 * w肳ꂽ񂪊֐L[[hł邩Ԃ܂B
	 *
	 * @param str
	 * @return
	 */
	public boolean isFunctions(String str) {
		return (Arrays.binarySearch(this.functions, str) >= 0);
	}

	/**
	 * w肳ꂽ񂪃f[^^L[[hł邩Ԃ܂B
	 *
	 * @param str
	 * @return
	 */
	public boolean isDataTypes(String str) {
		return (Arrays.binarySearch(this.dataTypes, str) >= 0);
	}

	/**
	 * w肳ꂽSQLJn\ł邩Ԃ܂B
	 *
	 * @param str
	 * @return
	 */
	public boolean isSqlStartStatements(String str) {
		return (Arrays.binarySearch(this.sqlStartStatements, str) >= 0);
	}

	/**
	 * w肳ꂽ񂪃}`L[[hł邩Ԃ܂B
	 *
	 * @param str
	 * @return
	 */
	public boolean isMultiKeywords(String str) {
		return (Arrays.binarySearch(this.multiKeyWords, str) >= 0);
	}

	/**
	 * w肳ꂽ񂪋Lł邩Ԃ܂B
	 *
	 * @param str
	 * @return
	 */
	public boolean isSymbols(String str) {
		return (Arrays.binarySearch(this.symbols, str) >= 0);
	}

	/**
	 * w肳ꂽ񂪋Lł邩Ԃ܂B
	 *
	 * @param c
	 * @return
	 */
	public boolean isSymbolChars(char c) {
		return (Arrays.binarySearch(this.symbolChars, c) >= 0);
	}

	/**
	 * w肳ꂽZqł邩Ԃ܂B
	 *
	 * @param str
	 * @return
	 */
	public boolean isOperators(String str) {
		return (Arrays.binarySearch(this.operators, str) >= 0);
	}

	/**
	 * w肳ꂽZqł邩Ԃ܂B
	 *
	 * @param c
	 * @return
	 */
	public boolean isOperatorChars(char c) {
		return (Arrays.binarySearch(this.operatorChars, c) >= 0);
	}

	/**
	 * w肳ꂽ񂪃Rgł邩Ԃ܂B
	 *
	 * @param str
	 * @return
	 */
	public boolean isComments(String str) {
		// VOCRg
		if (Arrays.binarySearch(this.singleLineComments, str) >= 0)
			return true;

		// }`CRg
		return ("/*".equals(str));
	}

	/**
	 * w肳ꂽ񂪃VOCRgł邩Ԃ܂B
	 *
	 * @param str
	 * @return
	 */
	public boolean isSingleLineComments(String str) {
		return (Arrays.binarySearch(this.singleLineComments, str) >= 0);
	}

	/**
	 * ̂ł邩Ԃ܂B
	 *
	 * @param str
	 * @return
	 */
	public boolean isName(String str) {
		boolean b = isKeywords(str);
		b |= isSymbols(str);
		b |= TokenUtil.isValue(str);
		b |= isComments(str);
		b |= TokenUtil.isSqlSeparate(str.charAt(0));
		return !b;
	}
}
