/*
 * 쐬: 2007/11/30
 * 쌠: Copyright (c) 2007 kry
 * CZXFEclipse Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/epl-v10.html
 */
package kry.sql.format.rule;

import kry.sql.constant.IOracleConstant;

/**
 * @author kry
 *
 */
public class OracleSqlFormatRule extends AbstractSqlFormatRule implements
		IOracleConstant {

	/**
	 *
	 */
	public OracleSqlFormatRule() {
		this.setReservedWords(IOracleConstant.RESERVED_WORDS);
		this.setDataTypes(IOracleConstant.DATA_TYPES);
		this.setFunctions(IOracleConstant.FUNCTIONS);
		this.setSqlStartStatements(IOracleConstant.SQL_STATEMENTS);
		this.setMultiKeyWords(IOracleConstant.MULTI_KEYWORDS);
		this.setSymbols(IOracleConstant.SYMBOLS);
		this.setOperators(IOracleConstant.OPERATORS);
		this.setSingleLineComments(IOracleConstant.SINGLE_LINE_COMMENTS);

		initiarize();
	}

	public boolean isNameChar(char c) {
		if (Character.isLetterOrDigit(c))
			return true;
		return (c == '_' || c == '$' || c == '#');
	}
}
