//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 12/12/2011.
//

#ifndef __INCLUDE_TKCELLCODE__
#define __INCLUDE_TKCELLCODE__

#include <string>

class TKReceptor;
class TKContainer;
class TKCell;
class TKCellCodeInstance;

class TKCellCode
{
public:
    TKCellCode(std::string theFQNName, std::string theCellAPIName) : mFQNName(theFQNName), mCellAPIName(theCellAPIName) {}
    virtual ~TKCellCode() {}
    
    std::string getFQNName() const { return mFQNName; }
    std::string getCellAPIName() const { return mCellAPIName; }

	virtual TKCellCodeInstance* createCellCodeInstance(TKCell *owner, const void *data) = 0;

protected:
    std::string mFQNName;
    std::string mCellAPIName;
};

#endif 
