//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 3/24/2012.
//
#ifndef QTDNSTORAGEIMPL_H
#define QTDNSTORAGEIMPL_H

#include "DNStorageImpl.h"

#include <QString>
#include <QtSql>

class QtDNDatabase
{
public:
    QSqlDatabase database;
};

class QtDNDBQueries
{
public:
    QSqlQuery   propertiesCountQuery;
    QSqlQuery   propertiesInsertQuery;
    QSqlQuery   propertiesUpdateQuery;
    QSqlQuery   propertiesGetQuery;

    QSqlQuery   xyzvDataInsetQuery;
    QSqlQuery   xyzvDataRemoveQuery;
    QSqlQuery   xyzvDataCountQuery;
    QSqlQuery   xyzvDataGetQuery;
};

class QtDNStorageImpl : public DNStorageImpl
{
public:
    QtDNStorageImpl(const char *storagePath);
    virtual ~QtDNStorageImpl();

    virtual bool    setValue(const char *path, const char *key, float value);
    virtual float   getValue(const char *path, const char *key);
    virtual int     getCount(const char *path, const char *key);

    virtual int     countXYZVData(const char *path, const char *key);
    virtual bool    insertXYZVData(const char *path, const char *key, int index, float x, float y, float z, float v);
    virtual DNStorageXYZVRecords* queryXYZVData(const char *path, const char *key);
    virtual bool    deleteXYZVData(const char *path, const char *key);

    virtual bool    flush();

    virtual bool    isValid() { return mIsValid; }

    virtual bool    startTransaction();
    virtual bool    commitTransaction();
    virtual bool    rollbackTransaction();

private:
    bool            initDB();
    bool            mIsValid;
    QString         mStoragePath;

    QtDNDatabase    *mDatabase;
    QtDNDBQueries   *mQueries;
};

#endif // QTDNSTORAGEIMPL_H
