//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 1/6/2012.
//

#ifndef dennco_TKContainerBuilder_h
#define dennco_TKContainerBuilder_h

#include <queue>
#include <string>
#include "TKLock.h"

class TKContainer;

class DNContainerBuilder
{
public:
    DNContainerBuilder(TKContainer *container);
    ~DNContainerBuilder();
    
    bool buildContainerFromXHTML(const char* docRoot);

private:
    void        parseXHTML(const char* docRoot, const char *fpath);
    TKLock                              mLock;
    TKContainer                         *mContainer;

    void defineCellWithoutCellCodeClass(const char *path, std::string name, std::string type, std::string customScript);
    void defineCellWithCellCodeClass(const char *path, std::string name, std::string cellcode, std::string customScript);
    void defineCellCodeClass(const char *path, std::string name, std::string type, std::string cellScript);
    void defineConnection(const char *path, std::string origine, std::string destination, std::string name);

    class PendingCellDefinition
    {
    public:
        bool        useCellCodeClass;
        std::string location;
        std::string cellName;
        std::string cellCodeClassOrType;
        std::string customScript;
    };
    
    class PendingCellConnection
    {
    public:
        std::string connectionName;
        std::string originCellName;
        std::string targetCellName;
    };
    
    std::queue<PendingCellConnection*> mPendingConnections;
    std::queue<PendingCellDefinition*> mPendingCellDefinitions;
    

};


#endif
