//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Apr/15/2012.
//
#include "DNSerialPort.h"
#include "DNSerialPortImpl.h"

DNSerialPort::DNSerialPort(DNServerSerialPort *server)
{
    impl = DNSerialPortImpl::create(server);
}

DNSerialPort::~DNSerialPort()
{
    if (impl)
    {
        delete impl;
        impl = 0;
    }
}

bool DNSerialPort::setup()
{
    if (impl)
    {
        return impl->setup();
    }
    return false;
}

bool DNSerialPort::isRunning()
{
    if (impl)
    {
        return impl->isRunning();
    }
    return false;
}

void DNSerialPort::start()
{
    if (impl)
    {
        impl->start();
    }
}

void DNSerialPort::stop()
{
    if (impl)
    {
        impl->stop();
    }
}
