//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Apr/15/2012.
//
#ifndef DNSERVERSERIALPORT_H
#define DNSERVERSERIALPORT_H

#include "DNServerBase.h"
#include "DNSerialPort.h"

#include <string>

class DNEngine;

class DNServerSerialPort : public DNServerBase
{
public:
    DNServerSerialPort(DNEngine *engine);
    virtual ~DNServerSerialPort();

    bool    setup();

    virtual bool    isRunning();
    virtual void    start();
    virtual void    stop();

    virtual void    doQueryRequest(std::string requestBody);
    virtual void    doSetRequest(std::string requestBody);
private:
    DNSerialPort *m_serialPort;

};

#endif // DNSERVERSERIALPORT_H
