//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Mar-4/2012.
//
//
#include "dnwebinterface.h"

#include "DNEngine.h"
#include "TKLog.h"

DNWebInterface::DNWebInterface(DNEngine *engine) :
    QObject(0), mEngine(engine)
{
}

void DNWebInterface::setValue(const QString name, float value)
{
    mEngine->doClientSetRequest(name.toLocal8Bit().data(), value);
}

float DNWebInterface::getValue(const QString name)
{
    return mEngine->doClientGetRequest(name.toLocal8Bit().data());
}
