//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 2/22/2012.
//
#include "dnqsbasiccell.h"

#include "TKContainer.h"
#include "dnqscontainer.h"
#include "TKLog.h"
#include "TKReceptor.h"
#include "TKAxon.h"
#include "TKCellCodeInstance.h"
#include "DNUtils.h"

DNQSBasicCell::DNQSBasicCell(DNQSContainer *container, std::string location, std::string name, bool canInterfaceIn, bool canInterfaceOut):
    DNQSCellBase(container,location,name,canInterfaceIn, canInterfaceOut)
{
}

DNQSBasicCell::~DNQSBasicCell()
{

}

bool DNQSBasicCell::doTick(float time)
{
    if (!mCellCodeInstance) return false;

    prepareValueForScript();

    if (mCellCodeInstance->doTick(time))
    {
        reflectValueFromScript();
        return true;
    }
    else
    {
        handleScriptException("doTick()");
        return false;
    }
}

bool DNQSBasicCell::doInit()
{
    if (!mCellCodeInstance) return false;

    prepareValueForScript();

    if (mCellCodeInstance->doInit())
    {
        reflectValueFromScript();
        return true;
    }
    else
    {
        handleScriptException("doInit()");
        return false;
    }
}

bool DNQSBasicCell::doDestroy()
{
    if (!mCellCodeInstance) return false;

    prepareValueForScript();

    if (mCellCodeInstance->doDestroy())
    {
        reflectValueFromScript();
        return true;
    }
    else
    {
        handleScriptException("doDestroy()");
        return false;
    }
}
