//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 2/22/2012.
//
#include "dnqscellcodeinstance.h"

#include "TKContainer.h"
#include "dnqscontainer.h"
#include "TKCell.h"
#include "TKLog.h"

#include <QTextStream>

TKLock DNQSCellCodeInstance::mLock;
int DNQSCellCodeInstance::mInstanceCount = 0;

DNQSCellCodeInstance::DNQSCellCodeInstance(TKCell *owner, QScriptValue qsObject) : TKCellCodeInstance(owner), mQSCellCodeInstance(qsObject)
{
    mScriptEngine = ((DNQSContainer*)owner->getContainer())->getScriptEngine();
    mQSCellContainer = ((DNQSContainer*)owner->getContainer())->getQSCellContainer();

    mLock.lock();
    mInstanceCount++;
    mLock.unlock();

    QTextStream(&mInstanceTag) << "INST" << mInstanceCount;
    mQSCellContainer.setProperty(mInstanceTag, qsObject);

    mQSDoTick = qsObject.property("doTick");
    mHasDoTick = mQSDoTick.isFunction();

    mQSDoInit = qsObject.property("doInit");
    mQSDoDestroy = qsObject.property("doDestroy");

}

DNQSCellCodeInstance::~DNQSCellCodeInstance()
{
    QScriptEngine *engine = mQSCellContainer.engine();
    if (engine)
    {
        mQSCellContainer.setProperty(mInstanceTag, engine->undefinedValue());
    }
    mIsValid = false;
}

bool DNQSCellCodeInstance::doTick(float time)
{
    if (mHasDoTick)
    {
        QScriptValueList args;
        args << time;
        mQSDoTick.call(mQSCellCodeInstance, args);
        return !mScriptEngine->hasUncaughtException();
    }
    else
    {
        return true;
    }
}

bool DNQSCellCodeInstance::doInit()
{
    if (mQSDoInit.isFunction())
    {
        mQSDoInit.call(mQSCellCodeInstance);
        return !mScriptEngine->hasUncaughtException();
    }
    else
    {
        return true;
    }
}

bool DNQSCellCodeInstance::doDestroy()
{
    if (mQSDoDestroy.isFunction())
    {
        mQSDoDestroy.call(mQSCellCodeInstance);
        return !mScriptEngine->hasUncaughtException();
    }
    else
    {
        return true;
    }
}
