//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 2/22/2012.
//
#ifndef DNQSCELLCODEINSTANCE_H
#define DNQSCELLCODEINSTANCE_H

#include "TKCellCodeInstance.h"

#include <QtScript/QScriptEngine>
#include <QtScript/QScriptValue>

#include "TKLock.h"

class DNQSCellCodeInstance : public TKCellCodeInstance
{
public:
    DNQSCellCodeInstance(TKCell *owner, QScriptValue qsObject);
    virtual ~DNQSCellCodeInstance();

    virtual bool    doTick(float time);
    virtual bool    doInit();
    virtual bool    doDestroy();

    bool            isValid() { return mIsValid; }

private:
    QScriptEngine   *mScriptEngine;
    QScriptValue    mQSCellContainer;

    QString         mInstanceTag;
    QScriptValue    mQSCellCodeInstance;
    QScriptValue    mQSDoInit;
    QScriptValue    mQSDoTick;
    bool            mHasDoTick;
    QScriptValue    mQSDoDestroy;
    bool            mIsValid;

    static TKLock   mLock;
    static int      mInstanceCount;
};

#endif // DNQSCELLCODEINSTANCE_H
