//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 3/14/2012.
//
#include "dnqsoutputcell.h"

#include "TKContainer.h"
#include "TKAxon.h"
#include "TKReceptor.h"

DNQSOutputCell::DNQSOutputCell(TKContainer *container, std::string location, std::string name):
    DNCellInterfaceable(container,location,name,false,true)
{
}

DNQSOutputCell::~DNQSOutputCell()
{
}

bool DNQSOutputCell::doTick(float time)
{
    (void)time;

    float value = 0.0;

    for ( TKReceptorMap::iterator it = mReceptors.begin(); it != mReceptors.end(); ++it ) {
       value += it->second->getValue();
    }

    mAxon->setValue(value);

    return true;
}

bool DNQSOutputCell::doInit()
{
    return true;
}

bool DNQSOutputCell::doDestroy()
{
    return true;
}

void DNQSOutputCell::setValue(float value)
{
    (void)value;
}
