//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 1/29/2012.
//

#include "SimpleHTTPServerController.h"
#include "OSXDNSimpleHTTPServerImpl.h"


DNHTTPServerImpl* DNHTTPServerImpl::create(DNHTTPServer *owner, DNClientRequestHandler handler)
{
    return new OSXDNSimpleHTTPServerImpl(owner, handler);
}

OSXDNSimpleHTTPServerImpl::OSXDNSimpleHTTPServerImpl(DNHTTPServer *owner, DNClientRequestHandler handler)
: mOwner(owner), mHandler(handler), mIsRunning(false), mPortNumber(DNHTTPServer::HTTPDEFAULTPORT)
{
}

OSXDNSimpleHTTPServerImpl::~OSXDNSimpleHTTPServerImpl()
{
    stop();
}

bool OSXDNSimpleHTTPServerImpl::isRunning()
{
    return mIsRunning;
}

void OSXDNSimpleHTTPServerImpl::start()
{
    if (isRunning())
    {
        stop();
    }

    controller = [[SimpleHTTPServerController alloc]initWithTCPPort:mPortNumber dnserver:mOwner requestHandler:mHandler];
    
    mIsRunning = controller != NULL;
}

void OSXDNSimpleHTTPServerImpl::stop()
{
    mIsRunning = false;
    if (controller)
        [controller stop];
    controller = nil;
}

void OSXDNSimpleHTTPServerImpl::setPortNumber(unsigned int portNumber)
{
    mPortNumber = portNumber;
}

void OSXDNSimpleHTTPServerImpl::replyWithStatusCode(int code, const char* message)
{
    [controller replyWithStatusCode:code message:[NSString stringWithCString:message encoding:NSUTF8StringEncoding]];
}

void OSXDNSimpleHTTPServerImpl::replyWithFile(const char* filePath)
{
    NSString *pathString = @"file://";
    pathString = [pathString stringByAppendingString:[[NSString alloc]initWithUTF8String:filePath]];
    NSURL *url = [[NSURL alloc]initWithString:pathString];
    NSURLRequest *request = [NSURLRequest requestWithURL:url];
    
    NSError* error = nil;
    NSURLResponse* response = nil;
    NSData* data = [NSURLConnection sendSynchronousRequest:request returningResponse:&response error:&error];
    [controller replyWithData:data MIMEType:[response MIMEType]];
}

