//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 1/7/2012.
//

#ifndef dennco_OSXDNTimeKeeperImpl_h
#define dennco_OSXDNTimeKeeperImpl_h

#include "DNTimeKeeperImpl.h"

#import <Foundation/Foundation.h>

class OSXDNTimeKeeperImpl : public DNTimeKeeperImpl
{
public:
    
    OSXDNTimeKeeperImpl();
    virtual ~OSXDNTimeKeeperImpl();
    
    virtual bool setIntevalSec(float time);
    virtual bool sleepUntilNextInterval();
    virtual float getTickTime();

    virtual bool    start();
    virtual bool    stop();

private:
    float               mIntervalTime;
    float               mAvgActualInterval;
    float               mAdjustTime;
    NSDate              *mPrevTime;
    NSDate              *mStartTime;
    
    NSTimeInterval      mTickTime;


};


#endif
