//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 1/17/2013.
//
#include "qtdnpluginmanager.h"

#include "qtdnplugin.h"
#include <QLibrary>
#include <QMessageBox>

static QtDNPluginManager *s_manager = NULL;

//static
DNPluginManager* DNPluginManager::instance()
{
    return s_manager;
}

//static
void DNPluginManager::construct()
{
    if (!s_manager)
        s_manager = new QtDNPluginManager;
}

//static
void DNPluginManager::destroy()
{
    if (s_manager)
        delete s_manager;

    s_manager = NULL;
}

QtDNPluginManager::QtDNPluginManager()
{
}

QtDNPluginManager::~QtDNPluginManager()
{
    while (!m_plugins.isEmpty())
    {
        QMap<QString, DNPlugin*>::iterator i = m_plugins.begin();
        delete i.value();
        m_plugins.take(i.key());
    }
}

DNPlugin* QtDNPluginManager::getPlugin(std::string name)
{
    QString qname = QString::fromStdString(name);
    QMap<QString, DNPlugin*>::const_iterator it = m_plugins.find(qname);
    if (it != m_plugins.end())
    {
        return it.value();
    }

    DNPlugin *plugin = new QtDNPlugin(qname);
    m_plugins.insert(qname, plugin);

    return plugin;
}
