//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Apr/15/2012.
//
#ifndef QTDNSERIALPORTIMPL_H
#define QTDNSERIALPORTIMPL_H

#include "DNSerialPortImpl.h"

#include "TKLock.h"
#include "ui_portinfodialog.h"

#include <serialport.h>
#include <serialportinfo.h>
#include <QString>
#include <QQueue>
#include <QSemaphore>
#include <QDialog>

class DNServerSerialPort;
class DNThread;

namespace Ui {
    class QtDNSerialPortSettingDialog;
}

class QtDNSerialPortSettingDialog : public QDialog
{
    Q_OBJECT

public:
    explicit QtDNSerialPortSettingDialog(QWidget *parent = 0);
    ~QtDNSerialPortSettingDialog();

    QString getSelectedPortName();
    int     getSelectedRate();
    bool                    isOK();
    SerialPort::DataBits    getSelectedDataBits();
    SerialPort::Parity      getSelectedParity();
    SerialPort::StopBits    getSelectedStopBits();
    SerialPort::FlowControl getSelectedFlowControl();

private slots:
    void procUpdateAvailablePorts();
    void procItemPortChanged(int idx);
    void procOKButtonClick();
    void procCancelButtonClick();

private:
    Ui::QtDNSerialPortSettingDialog *ui;
    bool mIsOK;
};

class QtDNSerialPortImpl : public DNSerialPortImpl
{
public:
    QtDNSerialPortImpl(DNServerSerialPort *server);
    virtual ~QtDNSerialPortImpl();

    virtual bool    setup();

    virtual bool    isRunning();
    virtual void    start();
    virtual void    stop();

    void            sendMessage(const char* message);

    static void     serialCommunicationThreadBody(void *impl);
    static void     requestHandelrThreadBody(void *impl);

private:
    DNThread *mSerialCommunicationThread;
    DNThread *mHandlerThread;
    bool    mStopping;

    QQueue<QString> mRequestQueue;
    QString         mResponseString;
    TKLock          mRequestQueueLock;
    TKLock          mResponseStringLock;
    TKLock          mStartStopLock;
    QSemaphore      mQueueSemaphore;
    QSemaphore      mSerialWriteSemaphore;

    QString mPortName;
    SerialPort::Rate mBaudRate;
    SerialPort::DataBits mDataBits;
    SerialPort::Parity mParity;
    SerialPort::StopBits mStopBits;
    SerialPort::FlowControl mFlowControl;

};

#endif // QTDNSERIALPORTIMPL_H
