//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Apr/27/2012.
//
#include "DNSettingsImpl.h"

#include <QString>
#include <QSettings>
#include <QVariant>

#include <string>

//static
std::string DNSettingsImpl::getValue(const char *key, std::string defaultValue)
{
    QSettings settings("dennco project", "dennco engine");
    QString  result = settings.value(QString(key), QString::fromStdString(defaultValue)).toString();

    return result.toStdString();
}

//static
void DNSettingsImpl::setValue(const char *key, std::string value)
{
    QSettings settings("dennco project", "dennco engine");
    settings.setValue(QString(key), QVariant(QString::fromStdString(value)));
}

