﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using ClipClop.User;
using System.Xml;
using System.Diagnostics;

namespace ClipClop.View
{
    /// <summary>
    /// TemplateSettingTreeNodeが保持するデータ
    /// </summary>
    public class TemplateSettingTreeNodeData : ICloneable
    {
        public ContextMenuSettingDefinition.Classification classification_;
        public ContextMenuSettingDefinition.SentenceType sentenceType_ = ContextMenuSettingDefinition.SentenceType.non;

        public string nameAttribute_;
        public string valueAttribute_;
		public string latterAttribute_;


        public string DisplayString
        {
            get
			{
                return XmlNodeHelper.GetDisplayString(classification_, nameAttribute_, valueAttribute_);
			}
        }

        public string DisplayValue
        {
            get
            {
                return XmlNodeHelper.GetDisplayValue(classification_, valueAttribute_);
            }
        }

		/// <summary>
		/// TemplateSettingTreeView.imageList_の要素
		/// </summary>
        public enum ImageListItem
        {
            eRoot,
            eSplitter,
            eTemplate,
            eFolder,
            eExecute,
            eEdit,
            eHistory,
			eComplex,
        }


        public TemplateSettingTreeNodeData(XmlNode xmlNode)
        {
            this.classification_ = XmlNodeHelper.GetClassification(xmlNode);

            this.nameAttribute_ = XmlNodeHelper.GetAttributeValue(xmlNode, ContextMenuSettingDefinition.Name_);
            this.valueAttribute_ = XmlNodeHelper.GetAttributeValue(xmlNode, ContextMenuSettingDefinition.Value_);
			this.latterAttribute_ = XmlNodeHelper.GetAttributeValue(xmlNode, ContextMenuSettingDefinition.Latter_);

            if (this.classification_ == ContextMenuSettingDefinition.Classification.sentence)
                this.sentenceType_ = XmlNodeHelper.GetSentenceType(xmlNode);
        }

        public TemplateSettingTreeNodeData(TemplateSettingTreeNodeData other)
        {
            this.classification_ = other.classification_;

            this.nameAttribute_ = other.nameAttribute_;
            this.valueAttribute_ = other.valueAttribute_;
			this.latterAttribute_ = other.latterAttribute_;
                        
            this.sentenceType_ = other.sentenceType_;
        }

		public TemplateSettingTreeNodeData(ContextMenuSettingDefinition.Classification classification, string nameAttribute)
        {
			this.classification_ = classification;
            this.nameAttribute_ = nameAttribute;
        }

		public TemplateSettingTreeNodeData(ContextMenuSettingDefinition.Classification classification)
        {
			this.classification_ = classification;
        }



        public ImageListItem ImageItem
        {
            get
            {
                if (ContextMenuSettingDefinition.Classification.sentence == this.classification_)
                {
                    switch (this.sentenceType_)
                    {
                        case ContextMenuSettingDefinition.SentenceType.template:
                            return ImageListItem.eTemplate;
                        case ContextMenuSettingDefinition.SentenceType.execute:
                            return ImageListItem.eExecute;
                        case ContextMenuSettingDefinition.SentenceType.editfile:
                            return ImageListItem.eEdit;
                        case ContextMenuSettingDefinition.SentenceType.clipboardhistory:
                            return ImageListItem.eHistory;
						case ContextMenuSettingDefinition.SentenceType.complex:
							return ImageListItem.eComplex;
					}
                    Debug.Fail("ここにはこないはず");
                }

                if (ContextMenuSettingDefinition.Classification.folder == this.classification_)
                {
                    return ImageListItem.eFolder;
                }

                if (ContextMenuSettingDefinition.Classification.root == this.classification_)
                {
                    return ImageListItem.eRoot;
                }

                return ImageListItem.eSplitter;
            }
        }

		public object Clone()
        {
            return new TemplateSettingTreeNodeData(this);
        }


    }
}
