﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using ClipClop.User;
using System.IO;

namespace ClipClop.View
{
    public partial class HistoryForm : ActiveForm
    {
        /// <summary>
        /// 履歴保存のオン・オフ
        /// </summary> 
        public bool Valid
        {
            get;
            set;
        }

        public ListBox.ObjectCollection History
        {
            get
            {
                return this.listBoxHistory.Items;
            }
        }

        /// <summary>
        /// クリップボード監視クラス
        /// </summary>
        private CaLib.User.ClipboardViewer cpViewer_;


        public HistoryForm()
        {
            InitializeComponent();

            FormUtil.GeometryFromString(Properties.Settings.Default.WindowGeometryHistoryForm, this);

            this.Valid = true;
            cpViewer_ = new CaLib.User.ClipboardViewer(this);
            cpViewer_.ClipboardHandler += this.OnClipBoardChanged;
        }

        #region イベント

        public void HotkeyEventHandler_Active()
        {
            this.Open();
        }

        public void HotkeyEventHandler_DeleteHistory()
        {
            this.listBoxHistory.RemoveLast();
        }

        private void 先頭に移動ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            listBoxHistory.MoveHead(false);
        }

        private void 改行を削除して先頭へToolStripMenuItem_Click(object sender, EventArgs e)
        {
            listBoxHistory.MoveHead(true);
        }

        private void 削除ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            listBoxHistory.DeleteSelectedItem();
        }

        private void 全て削除toolStripMenuItem_Click(object sender, EventArgs e)
        {
            listBoxHistory.Clear();
            SetListContextMenuStripEnabled(false);
        }

        private void ファイルに保存toolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (listBoxHistory.SelectedIndex < 0)
                return;
            string s = listBoxHistory.SelectedItem.ToString();

            using (SaveFileDialog d = new SaveFileDialog())
            {
                d.DefaultExt = "txt";
                d.OverwritePrompt = true;
                d.InitialDirectory = string.IsNullOrEmpty(ClipClop.Properties.Settings.Default.InitialDirectoryTextFile) ?
                    string.Empty : ClipClop.Properties.Settings.Default.InitialDirectoryTextFile;
                d.FileName = Util.MakeFileName(s);
                d.Filter = "TEXTファイル(*.TXT)|*.TXT|すべてのファイル(*.*)|*.*";

                DialogResult ret = d.ShowDialog();
                if (ret != DialogResult.OK)
                    return;

                ClipClop.Properties.Settings.Default.InitialDirectoryTextFile = Path.GetDirectoryName(d.FileName);

                try
                {
                    using (StreamWriter sw = new StreamWriter(d.FileName, false, Encoding.UTF8))
                    {
                        sw.Write(s);
                        sw.Close();
                    }
                }
                catch (Exception ex)
                {
                    Util.ShowError(ex.Message);
                }
            }
        }

        private void listBoxHistory_SelectedIndexChanged(object sender, EventArgs e)
        {
            //操作メニューの有効無効更新
            if (listBoxHistory.SelectedIndex < 0)
                SetListContextMenuStripEnabled(false);
            else
                SetListContextMenuStripEnabled(true);

        }
        #endregion

        public void Read(string path)
        {
            this.listBoxHistory.Read(path);
        }

        public void Save(string path)
        {
            this.listBoxHistory.Save(path);
        }

        public void Setup(bool alwaysTop, double opacity, Font f, int maxCout)
        {
            this.TopMost = alwaysTop;
            this.Opacity = opacity;


            this.listBoxHistory.Font = f;

            //履歴最大数設定
            listBoxHistory.SetMax(maxCout);
        }

        private void SetListContextMenuStripEnabled(bool enable)
        {
            foreach (ToolStripItem item in listContextMenuStrip.Items)
            {
                item.Enabled = enable;
            }
            listContextMenuStrip.Enabled = enable;
        }

        /// <summary>
        /// ダブルクリック等で開く
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public void Open_Click(object sender, MouseEventArgs e)
        {
            Open();
        }
        public void Open_Click(object sender, EventArgs e)
        {
            Open();
        }

        /// <summary>
        /// クリップボードにテキストがコピーされると呼び出される
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="args"></param>
        private void OnClipBoardChanged(object sender, CaLib.User.ClipboardEventArgs args)
        {
            if (this.Valid && false == string.IsNullOrEmpty(args.Text))
            {
                listBoxHistory.InsertHead(args.Text);
            }
        }

        private void HistoryForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (!base.CheckClosing(sender, e))
            {
                return;
            }

            Properties.Settings.Default.WindowGeometryHistoryForm = FormUtil.GeometryToString(this);
        }

    }
}
