﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;
using System.Windows.Forms;
using ClipClop.User;
using System.Runtime.Serialization.Formatters.Binary;
using System.IO;
using System.Runtime.Serialization;

namespace ClipClop.View
{
	public class TemplateSettingTreeNode : TreeNode, ICloneable
	{
        TemplateSettingTreeNodeData data_;

        //public TemplateSettingTreeNodeData Data
        //{
        //    get
        //    {
        //        return this.data_;
        //    }
        //}

		public TemplateSettingTreeNode()
		{
		}

        public TemplateSettingTreeNode(TemplateSettingTreeNodeData data)
            : base(data.DisplayString, (int)data.ImageItem, (int)data.ImageItem)
        {
            this.data_ = data;
        }

        public TemplateSettingTreeNode(TemplateSettingTreeNodeData data, TreeNode[] children)
            : base(data.DisplayString, (int)data.ImageItem, (int)data.ImageItem, children)
        {
            this.data_ = data;
        }

		public ContextMenuSettingDefinition.Classification Classification
		{
			get
			{
                return data_.classification_;
			}
		}

        public string DisplayString
        {
            get { return data_.DisplayString; }
        }
        public string DisplayValue
        {
            get { return data_.DisplayValue; }
        }

        public string NameAttribute
        {
            get { return data_.nameAttribute_; }
        }
        public string ValueAttribute
        {
            get { return data_.valueAttribute_; }
        }
		public string LatterAttribute
		{
			get { return data_.latterAttribute_; }
		}

 
        public ContextMenuSettingDefinition.SentenceType SentenceType
		{
			get{
                return data_.sentenceType_;
			}
		}

		public void EditAttribute(ContextMenuSettingDefinition.SentenceType sentenceType, string name, string value, string latter)
		{
			this.data_.sentenceType_ = sentenceType;
            this.data_.nameAttribute_ = name;
            this.data_.valueAttribute_ = value;
			this.data_.latterAttribute_ = latter;
		}

		public bool IsRoot()
		{
            return (this.Parent == null);
		}

		/// <summary>
		/// 要素を追加できるかどうか
		/// </summary>
		/// <returns></returns>
		public bool IsAddable()
		{
			if (this.IsRoot())
				return true;
			if (this.IsFolder())
				return true;
			return false;
		}

		public bool IsEditable()
		{
			if (this.IsRoot())
				return false;
			if (this.Classification == ContextMenuSettingDefinition.Classification.separator)
				return false;
			return true;
		}

		public bool IsFolder()
		{
			return this.data_.classification_ == ContextMenuSettingDefinition.Classification.folder ? true : false;
		}

		public void DeleteNode()
		{
			this.Remove();
		}

		public void Update()
		{
			this.Text = this.data_.DisplayString;

            TemplateSettingTreeNodeData.ImageListItem idx = data_.ImageItem;

			base.ImageIndex = (int)idx;
			base.SelectedImageIndex = (int)idx;
		}

		/// <summary>
		/// memo : MemberwiseClone
		/// </summary>
		/// <returns></returns>
		public override object Clone()
		{
			TemplateSettingTreeNode result = null;

			if (this.Nodes.Count < 1)
			{
                result = new TemplateSettingTreeNode((TemplateSettingTreeNodeData)this.data_.Clone());
				return result;
			}

			TemplateSettingTreeNode[] children = new TemplateSettingTreeNode[this.Nodes.Count];

			for (int i = 0; i < this.Nodes.Count; i++ )
			{
				TemplateSettingTreeNode tmp = this.Nodes[i] as TemplateSettingTreeNode;
				children[i] = (TemplateSettingTreeNode)tmp.Clone();
			}

            result = new TemplateSettingTreeNode((TemplateSettingTreeNodeData)this.data_.Clone(), children);
			return result;
		}


        public XmlElement CreateXmlNode(XmlCipheredDocument doc)
        {
			XmlElement element = XmlNodeHelper.CreateXmlNodeEx(
				this.Classification, 
				this.SentenceType, 
				this.NameAttribute, 
				this.ValueAttribute, 
				this.LatterAttribute, 
				doc
			);			
			return element;
        }
	}
}
