﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Scripting.Hosting;
using IronPython.Hosting;
using System.Diagnostics;
using System.Reflection;
using System.IO;


namespace ClipClop.User
{
    public class ScriptManager
    {
        //TODO 使い回していいのか知らない。

        /// <summary>
        /// Python スクリプトエンジン
        /// </summary>
        ScriptEngine scriptEngine_ = null;

        ScriptScope scope_ = null;

        public bool Valid
        {
            get
            {
				return (this.scriptEngine_ != null && this.scope_ != null) ? true : false;
            }
        }

        public ScriptManager()
        {
        }

        /// <summary>
        /// 準備する
        /// </summary>
		public void Create()
        {
			if (this.Valid==false)
			{
				scriptEngine_ = Python.CreateEngine();

				// このアセンブリをPython側で参照できるようにしておく
				Assembly assembly = typeof(Program).Assembly;
				ScriptRuntime runtime = scriptEngine_.Runtime;
				runtime.LoadAssembly(Assembly.LoadFile(assembly.Location));

				// スコープ生成
				// IronPython に変数を渡したり取得したりするときに使う
				scope_ = scriptEngine_.CreateScope();
			}
        }

        public void Destory()
        {
            scope_ = null;
            scriptEngine_ = null;
        }


        public string Execute(string filePath, string variableName, string input)
        {
            Debug.Assert(scriptEngine_ != null);

            // Python スクリプトを読み込む
            ScriptSource source = scriptEngine_.CreateScriptSourceFromFile(filePath);
            CompiledCode code = source.Compile();

            // Python側のスコープに変数をセットする
            scope_.SetVariable(variableName, input);

            // Python スクリプト実行（関数定義、クラス定義が完了する）
            code.Execute(scope_);

            string ret = scope_.GetVariable<string>(variableName);

            return ret;
        }
    }
}
