﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Drawing;
using System.IO;
using System.Collections.Specialized;
using System.Diagnostics;

namespace CaLib.User
{
	public class ClipboardAdapter
	{
		public static void Clear()
		{
			Clipboard.Clear();
		}

		public static bool ContainsAudio()
		{
			return Clipboard.ContainsAudio();
		}

		public static bool ContainsData(string format)
		{
			return Clipboard.ContainsData(format);
		}

		public static bool ContainsFileDropList()
		{
			return Clipboard.ContainsFileDropList();
		}

		public static bool ContainsImage()
		{
			return Clipboard.ContainsImage();
		}

		public static bool ContainsText()
		{
			return Clipboard.ContainsText();
		}

		public static bool ContainsText(TextDataFormat format)
		{
			return Clipboard.ContainsText(format);
		}

		public static Stream GetAudioStream()
		{
			return Clipboard.GetAudioStream();
		}

		public static object GetData(string format)
		{
			return Clipboard.GetData(format);
		}

		public static IDataObject GetDataObject()
		{
			return Clipboard.GetDataObject();
		}

		public static StringCollection GetFileDropList()
		{
			return Clipboard.GetFileDropList();
		}

		public static Image GetImage()
		{
			return Clipboard.GetImage();
		}

		public static string GetText()
		{
			return Clipboard.GetText();
		}

		public static string GetText(TextDataFormat format)
		{
			return Clipboard.GetText(format);
		}

		public static void SetAudio(byte[] audioBytes)
		{
			Clipboard.SetAudio(audioBytes);
		}

		public static void SetAudio(Stream audioStream)
		{
			Clipboard.SetAudio(audioStream);
		}

		public static void SetData(string format, object data)
		{
			Trace.WriteLine("ClipboardAdapter.SetDataObject " + data.GetType().ToString());

			Clipboard.SetData(format, data);
		}

		public static void SetDataObject(object data)
		{
			Trace.WriteLine("ClipboardAdapter.SetDataObject " + data.GetType().ToString());

			Clipboard.SetDataObject(data);
		}

		public static void SetDataObject(object data, bool copy)
		{
			Trace.WriteLine("ClipboardAdapter.SetDataObject " + data.GetType().ToString());

			Clipboard.SetDataObject(data, copy);
		}

		public static void SetDataObject(object data, bool copy, int retryTimes, int retryDelay)
		{
			Trace.WriteLine("ClipboardAdapter.SetDataObject " + data.GetType().ToString());

			Clipboard.SetDataObject(data, copy, retryTimes, retryDelay);
		}

		public static void SetFileDropList(StringCollection filePaths)
		{
			Clipboard.SetFileDropList(filePaths);
		}

		public static void SetImage(Image image)
		{
			Trace.WriteLine("ClipboardAdapter.SetImage " + image.GetHashCode());

			Clipboard.SetImage(image);
		}

		public static void SetText(string text)
		{
			Clipboard.SetText(text);
		}

		public static void SetText(string text, TextDataFormat format)
		{
			Clipboard.SetText(text, format);
		}
	}
}
