﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using ClipClop.User;
using System.IO;
using System.Xml;
using CaLib.User;

namespace ClipClop.View
{
	public partial class TemplateItemForm : Form
	{
		public TemplateItemForm()
		{
			InitializeComponent();
            FormUtil.GeometryFromString(Properties.Settings.Default.WindowGeometryTemplateItemForm, this);
        }


		public TemplateItemForm(ContextMenuSettingDefinition.SentenceType sentenceType, string dispalyName, string dispalyValue, string dispalyLatter)
		{
			InitializeComponent();

            FormUtil.GeometryFromString(Properties.Settings.Default.WindowGeometryTemplateItemForm, this);

			this.comboBoxType.DataSource = ContextMenuSettingDefinition.SentenceTypeNamestrings;
			this.comboBoxType.ValueMember = "Value";
			this.comboBoxType.DisplayMember = "Key";

            this.comboBoxType.SelectedIndex = (int)sentenceType;

			UpdateControlString(sentenceType, dispalyName, dispalyValue, dispalyLatter);
		}


		void UpdateControlString(ContextMenuSettingDefinition.SentenceType sentenceType, string dispalyName, string dispalyValue, string dispalyLatter)
		{
			this.textBoxLatter.Visible = false;
			this.labelLatter.Visible = false;
			this.splitContainer.Panel2Collapsed = true;

			switch (sentenceType)
			{
				case ContextMenuSettingDefinition.SentenceType.template:
				case ContextMenuSettingDefinition.SentenceType.execute:
					this.textBoxName.Text = dispalyName;
					this.textBoxValue.Text = dispalyValue;
                    this.textBoxName.Enabled = true;
                    this.textBoxValue.Enabled = true;
                    break;
				case ContextMenuSettingDefinition.SentenceType.editfile:
                    this.textBoxName.Text = global::ClipClop.Properties.Resources.MenuEdit;
					this.textBoxValue.Text = string.Empty;
                    this.textBoxName.Enabled = false;
                    this.textBoxValue.Enabled = false;
					break;
				case ContextMenuSettingDefinition.SentenceType.clipboardhistory:
                    this.textBoxName.Text = global::ClipClop.Properties.Resources.MenuHistory;
					this.textBoxValue.Text = string.Empty;
                    this.textBoxName.Enabled = true;
                    this.textBoxValue.Enabled = false;
                    break;
				case ContextMenuSettingDefinition.SentenceType.complex:
					this.textBoxName.Text = dispalyName;
					this.textBoxValue.Text = dispalyValue;
					this.textBoxLatter.Text = dispalyLatter;

					this.textBoxName.Enabled = true;
					this.textBoxValue.Enabled = true;

					this.textBoxLatter.Visible = true;
					this.labelLatter.Visible = true;
					this.splitContainer.Panel2Collapsed = false;

					break;
			}
		}

		private void comboBoxType_SelectedValueChanged(object sender, EventArgs e)
		{
			ContextMenuSettingDefinition.SentenceType mode = (ContextMenuSettingDefinition.SentenceType)this.comboBoxType.SelectedIndex;
			UpdateControlString(mode, this.textBoxName.Text, this.textBoxValue.Text, this.textBoxLatter.Text);
		}

		public string DispValue
		{
			get
			{
				return this.textBoxValue.Text;
			}
		}
		public string DispName
		{
			get
			{
				return this.textBoxName.Text;
			}
		}

		public string DispLatter
		{
			get
			{
				return this.textBoxLatter.Text;
			}
		}

		public ContextMenuSettingDefinition.SentenceType SentenceType
		{
			get
			{
				return (ContextMenuSettingDefinition.SentenceType)this.comboBoxType.SelectedIndex;
			}
		}

        bool bValidInput_ = false;

		private void buttonOK_Click(object sender, EventArgs e)
		{
            bValidInput_ = false;
       
			ContextMenuSettingDefinition.SentenceType sentenceType = (ContextMenuSettingDefinition.SentenceType)this.comboBoxType.SelectedIndex;
			switch (sentenceType)
			{
				case ContextMenuSettingDefinition.SentenceType.template:
					if (string.IsNullOrEmpty(this.textBoxValue.Text))
					{
						Util.ShowWarn(global::ClipClop.Properties.Resources.MSG001);
						return;
					}
					//名前は空でもいい
					break;

				case ContextMenuSettingDefinition.SentenceType.complex:
					if (string.IsNullOrEmpty(this.textBoxValue.Text) || string.IsNullOrEmpty(this.textBoxLatter.Text))
					{
						Util.ShowWarn(global::ClipClop.Properties.Resources.MSG001);
						return;
					}
					//名前は空でもいい
					break;

				case ContextMenuSettingDefinition.SentenceType.execute:
					if (string.IsNullOrEmpty(this.textBoxName.Text))
					{
						Util.ShowWarn(global::ClipClop.Properties.Resources.MSG002);
						return;
					}
					if (string.IsNullOrEmpty(this.textBoxValue.Text))
					{
						Util.ShowWarn(global::ClipClop.Properties.Resources.MSG001);
						return;
					}

					string exec = LaunchExec.FindExecuteString(this.textBoxValue.Text);
					if (!string.IsNullOrEmpty(exec))
					{
						//exeファイルのパスが指定された場合
						//ファイル名に使用できない文字を取得
						char[] invalidChars = Path.GetInvalidFileNameChars();

						if (exec.IndexOfAny(invalidChars) > -1)
						{
							Util.ShowWarn(global::ClipClop.Properties.Resources.MSG003);
							return;
						}
					}

					break;
				case ContextMenuSettingDefinition.SentenceType.editfile:
                    break;
                case ContextMenuSettingDefinition.SentenceType.clipboardhistory:
                    if (string.IsNullOrEmpty(this.textBoxName.Text))
                    {
                        Util.ShowWarn(global::ClipClop.Properties.Resources.MSG002);
                        return;
                    }
                    break;
			}

            bValidInput_ = true;
			//this.Close();
		}

        private void TemplateItemForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (this.DialogResult == DialogResult.OK)
            {
                e.Cancel = false;
                if (bValidInput_ == false)
                {
                    e.Cancel = true;
                    return;
                }
            }

            Properties.Settings.Default.WindowGeometryTemplateItemForm = FormUtil.GeometryToString(this);
        }

        private void textBoxValue_DragEnter(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent(DataFormats.FileDrop))
                e.Effect = DragDropEffects.Copy;
        }

        private void textBoxValue_DragDrop(object sender, DragEventArgs e)
        {
            string[] dropFiles = (string[])e.Data.GetData(DataFormats.FileDrop);
            if( dropFiles.Length > 0 )
                textBoxValue.Text = dropFiles[0];
        }
	}
}
