/*DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64

                         D r . D e a m o n  6 4
                        for INTEL64(R), AMD64(R)
	
   Copyright(C) 2007-2009 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64*/

/* File Info -----------------------------------------------------------
File: drd64_.c
Function: 
Comment: 
----------------------------------------------------------------------*/

#define	DRD64_SRC_DEBUGD_MAIN
#include"drd64_debugd.h"


void Drd64_Debugd_SigTerm( siginfo_t *info, ucontext_t *uap)
{
	drd64_debugd_info.i_flag_terminate	= 0xff;
	return;
}


void Drd64_Debugd_SigHup( siginfo_t *info, ucontext_t *uap)
{
	drd64_debugd_info.i_flag_terminate	= 0xff;
	return;
}


int
	Drd64_Debugd_Terminate(
		void )
{
	DRD64_LOG_INFO("[INFO] Terminating drdebugd");

	Drd64_Debugd_Debug_Detach( &drd64_debugd_info );

	free( gp_sendbuffer );

	if( drd64_debugd_info.i_socket_client
			!= drd64_debugd_info.i_socket_server )	{
		close( drd64_debugd_info.i_socket_server );
	}

	close( drd64_debugd_info.i_socket_client );
	close( drd64_debugd_info.i_socket_debugd );

	DRD64_LOG_INFO("[INFO] Terminate drdebugd. Good-Bye.");
	Drd64_Server_Log_TermLogSystem();

	return 0x00;
}


int
	Drd64_Debugd_Main_PreInit(
		Drd64_Debugd_MasterInformation *p_debugd )
{
	Drd64_Server_Log_InitLogSystem(
		DRD64_LOG_MODULE_DEBUGD,
		DRD64_LOG_LEVEL_DEBUGD,
		DRD64_LOG_FACILITY_DEBUGD );

	DRD64_LOG_INFO("**************************************************");
	DRD64_LOG_INFO("drd64_debugd : Dr.Deamon64 Process Debugger Deamon");
	DRD64_LOG_INFO("Copyright(C) 2007- Koine Yuusuke(koinec). All rights reserved.");
	DRD64_LOG_INFO("[Arch]: INTEL64(amd64/x86-64) / FreeBSD");
	DRD64_LOG_INFO("[INFO]: Booting drdebugd");

	p_debugd->str_socketname_debugd[0] = '\0';
	p_debugd->i_flag_terminate			= 0x00;

	return 0x00;
}


int
	Drd64_Debugd_Main_Init(
		Drd64_Debugd_MasterInformation *p_debugd,
		int		i_request_fd )
{
	int		i_err;

	/* Set Signal Functions */
	Drd64_Server_Common_Signal( SIGINT, Drd64_Debugd_SigTerm );
	Drd64_Server_Common_Signal( SIGTERM, Drd64_Debugd_SigTerm );
	Drd64_Server_Common_Signal( SIGHUP, Drd64_Debugd_SigHup );

	/* Init Recv.Status Struct */
	i_err	= Drd64_Server_RecvStatus_Init( DRD64_DEBUGD_RECVSTATUS_UNITS );
	if( 0x00 != i_err )		{ return i_err; }

	/* Init Packet Read Buffer */
	Drd64_Server_RecvSocket_InitReadBuffer();

	/* Create Socket from Local Client or Marshald */
	p_debugd->i_socket_debugd =
		Drd64_LibBrownie_Socket_InitSocketServer_Local(
			p_debugd->str_socketname_debugd );
	if( 0 > p_debugd->i_socket_debugd )	{
		return 0x01;
	}

	/* Init Packet Data Buffer for Send */
	gp_sendbuffer   = (Byte *)malloc( DRD64_MAX_PACKET_LENGTH );
    if( NULL == gp_sendbuffer )     { return 0x03; }

	/* Attach or Debug-Start */

	/* Send Debugd-Boot-Info. Packet to Local-Marshald */
	i_err = Drd64_Debugd_Send_Cmd_BootInfo( i_request_fd );
	if( 0x00 != i_err )		{ return i_err; }

	return 0x00;
}


void
	Drd64_Debugd_Main_Usage(
		void )
{
	puts("drd64_debugd : Dr.Deamon64 Process Debugger Deamon");
	puts("Copyright(C) 2007- Koine Yuusuke(koinec). All rights reserved.");
	puts("[Arch]: INTEL64(amd64/x86-64) / FreeBSD");
	puts(" ** CAUTION! ** ");
	puts("  This Program have Booted by drd64_marshald.");
	puts("  So, You can't boot drd64_debugd by Command-Line.");
	
	return;
}


int
	Drd64_Debugd_Main_AnalyzeOption(
		Drd64_Debugd_MasterInformation	*p_debugd,
		int		argc,
		char	*argv[],
		int		*i_request_fd )
{
	int			i_err;
	int			i_flag_debug;
	int			i_opt;
	int			i_options;
	extern char	 *optarg;
	extern int	 optind;
	extern int	 optopt;

	i_err	= 0x00;
	i_flag_debug	= 0;
	i_options	= 0;

	while( -1 != ( i_opt = getopt( argc, argv, "n:c:r:m:a:d" )) )		{
		if( 1 < i_flag_debug )
						{ break; }

		/* "n" : SocketName for Client */
		if( 'n' == i_opt )		{
			strncpy( p_debugd->str_socketname_debugd,
								optarg, DRD64_MAX_PATH );
			i_options++;
		}
		/* "s" : SocketName for Server */
		/*else if( 's' == i_opt )		{
			strncpy( p_debugd->str_socketname_server,
								optarg, DRD64_MAX_PATH );
		}*/
		/* "c" : coredump File Name */
		else if( 'c' == i_opt )	{
			strncpy( p_debugd->str_target_file_coredump,
									optarg, DRD64_MAX_PATH );
		}
		/* "r" : Attach or Debug Request Source FD */
		else if( 'r' == i_opt )	{
			if( 0x00 == Drd64_Common_isDigits( optarg ) )
				{ i_err	= 0x01; }
			else
				{ *i_request_fd	= atoi( optarg ); }
			i_options++;
		}
		/* "m" : Local Marshald ConnectInfo ID */
		else if( 'm' == i_opt )	{
			if( 0x00 == Drd64_Common_isDigits( optarg ) )
				{ i_err	= 0x01; }
			else
				{ p_debugd->i_marshald_connectid	= atoi( optarg ); }
			i_options++;
		}
		/* "d" : Debug > Option Debugee FullPath */
		else if( 'd' == i_opt ) {
			if( 0 < i_flag_debug )
				{ i_err	= 0x01; }
			else
				{ i_flag_debug	= 2; }
			i_options++;
			break;
		}
		/* "a" : Attach > Option : Debugee Pid */
		else if( 'a' == i_opt )	{
			if( 0x00 == Drd64_Common_isDigits( optarg ) )
				{ i_err	= 0x01; }
			else
				{ p_debugd->i_target_pid	= atoi( optarg ); }
			i_flag_debug	= 1;
			i_options++;
			break;
		}
		else 		{
			i_err	= 0x01;
			break;
		}
	}

	if(( 'd' == i_opt ) && ( optind < argc ))		{
		strncpy( p_debugd->str_target_file_exec, argv[optind], DRD64_MAX_PATH );

		optind++;
		if( optind < argc )	{
			p_debugd->ppstr_argv	= argv + optind;
			p_debugd->i_arg_options	= argc - optind;
		}
	}
	else	{

	}

	if(( 0x00 != i_err ) || ( 4 > i_options ))		{
		Drd64_Debugd_Main_Usage();
	}

	return i_err;
}


int main(
	int argc,
	char *argv[] )
{
	int		i_err;
	int		i_request_fd;

	/* Phase 1 : Check Booting by Command-Line? ---*/
	if( 9 > argc )	{
		Drd64_Debugd_Main_Usage();
		return 0x00;
	}

	/* Phase 2 : Deamonize drd64_debugd ---*/
	Drd64_Server_Common_Deamonize();
	/* XXX : Error Proc. */

	/* Phase 3 : PreInit. drd64_debugd ( Init. LogSystem ) ---*/
	i_err = Drd64_Debugd_Main_PreInit( &drd64_debugd_info  );
	if( 0x00 != i_err )		{ return 0x01; }
	DRD64_LOG_VERBOSE("  [STAT] Completed Deamonize ");

	/* Phase 4 : Init. memory & Analyze Option ---*/
	i_err	= 0x00;

	memset( &drd64_debugd_info, 0x00,
						sizeof( Drd64_Debugd_MasterInformation ) );
	drd64_debugd_info.i_socket_client	= -1;
	drd64_debugd_info.i_target_pid	= -1;

	i_err = Drd64_Debugd_Main_AnalyzeOption(
				&drd64_debugd_info, argc, argv, &i_request_fd );
	if( 0x00 != i_err )	{ return 0x01; }
	DRD64_LOG_VERBOSE("  [STAT] Completed Analyze Option ");

	/* Phase 5 : Init. drd64_debugd ---*/
	i_err = Drd64_Debugd_Main_Init( &drd64_debugd_info, i_request_fd );
	if( 0x00 != i_err )		{
		return 0x02;
	}
	DRD64_LOG_VERBOSE("  [STAT] Completed drd64_debugd System Init. ");

	/* Phase 6 : Attach or Debug-Start to Debugee Program ---*/
	i_err = Drd64_Debugd_Debug_Attach( &drd64_debugd_info );
	if( 0x00 != i_err )		{
		return 0x03;
	}
	DRD64_LOG_VERBOSE("  [STAT] Completed Attach. ");


	DRD64_LOG_VERBOSE("[STAT] Completed Booting drd64_debugd. ");

	Drd64_Debugd_Dispatch_Polling( &drd64_debugd_info );

	Drd64_Debugd_Terminate();

	return 0x00;
}



/* EOF of drd64_.c ----------------------------------- */
