/*DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64

                         D r . D e a m o n  6 4
                        for INTEL64(R), AMD64(R)
	
   Copyright(C) 2007-2009 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64*/

/* File Info -----------------------------------------------------------
File: drd64_.c
Function: 
Comment: 
----------------------------------------------------------------------*/

#define	DRD64_SRCID_MARSHALD_BOOT_DEBUGD	0x0000
#include"drd64_marshald.h"

#define	DRD64_FUNCID_Marshald_Boot_Debugd	0x01

/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
int
	Drd64_Marshald_Boot_Debugd(
		char	*pstr_sockname_debugd,
		int		i_prog_pid,
		int		i_request_rid,
		int		i_attach_cid )
{
	int		i_pid_debugd;
	char	str_sockname[DRD64_MAX_PATH+1];
	char	str_pid_debugd[10];
	char	str_request_fd[10];
	char	str_debugd_connect_id[10];
	DWord	dw_errcode;
	DWord	dw_location;

	DRD64_LOG_DEBUG("  [DEBUG] Boot Debugd Start");

	/* Phase 0 : Init ----------------------------*/
	dw_errcode	= DRD64_ERROR_CODE_CLEAR;
	dw_location	= DRD64_ERROR_SET_LOCATION(
						DRD64_ERROR_MODULE_MARSHALD,
						DRD64_ERROR_ARCH_NODEPEND,
						DRD64_SRCID_MARSHALD_BOOT_DEBUGD,
						DRD64_FUNCID_Marshald_Boot_Debugd );

	/* Phase 1 : Generate Debugd Param -----------*/
	/* n : socketname(PF_UNIX) for debugd<=>Client */
	strcpy( str_sockname, "/tmp/tmpdrd64debugd_client_XXXXXXXXXX" );
	if( NULL == mktemp( str_sockname ))	{
		dw_errcode  = DRD64_ERROR_SET_CODE(
							DRD64_ERROR_TYPE_ERROR,
							DRD64_ERROR_PTN_SYSCALL,
							0x00, 0x01 );
		Drd64_LibBrownie_Error_SetErrorInfo(
				dw_errcode, dw_location, errno );

		return -0x02;
	}

	/* a : attach pid => p_attach->i_prog_pid */
	snprintf( str_pid_debugd, 10, "%d", i_prog_pid );

	/* r : request fd */
	snprintf( str_request_fd, 10, "%d", i_request_rid );

	/* m : to Debugd ConnectInfo ID */
	snprintf( str_debugd_connect_id, 10, "%d", i_attach_cid );

	/* XXX c : coredump file */


	/* Phase 2 : Exec debugd ----------------------*/
	i_pid_debugd	= fork();
	/* fork error */
	if( 0 > i_pid_debugd )	{
		dw_errcode  = DRD64_ERROR_SET_CODE(
							DRD64_ERROR_TYPE_ERROR,
							DRD64_ERROR_PTN_SYSCALL,
							0x00, 0x02 );
		Drd64_LibBrownie_Error_SetErrorInfo(
				dw_errcode, dw_location, errno );

		return i_pid_debugd;
	}
	/* child Proc. */
	else if( 0 == i_pid_debugd )	{
		/* XXX */
		execl( drd64_marshald_info.str_path_debugd,
				DRD64_MODULENAME_DEBUGD,
				"-n", str_sockname,
				"-r", str_request_fd,
				"-m", str_debugd_connect_id,
				"-a", str_pid_debugd, NULL );
		exit( 0 );
	}

	/* Parent Proc. */
	strncpy( pstr_sockname_debugd, str_sockname, DRD64_MAX_PATH );

	DRD64_LOG_DEBUG("  [DEBUG] Boot Debugd Ended");

	return i_pid_debugd;
}


/* EOF of drd64_.c ----------------------------------- */
