/*DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64

                         D r . D e a m o n  6 4
                        for INTEL64(R), AMD64(R)
	
   Copyright(C) 2007-2009 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64*/

/* File Info -----------------------------------------------------------
File: drd64_.c
Function: 
Comment: 
----------------------------------------------------------------------*/

#define DRD64_SRC_MARSHALD_CINFO
#include"drd64_marshald.h"

Drd64_Marshald_ConnectInfo	*gp_marshald_cinfo;
int							gi_marshald_cinfo_max;
int							gi_marshald_cinfo_now;


EXTERN_MARSHALD_CINFO
Drd64_Marshald_ConnectInfo	*
	Drd64_Marshald_SearchINetConnection(
		struct	in_addr	*p_addr )
{
	int		i_cnt;
	Drd64_Marshald_ConnectInfo	*p_cinfo;

	p_cinfo	= NULL;
	
	for( i_cnt = 0; i_cnt < gi_marshald_cinfo_now; i_cnt++ )	{
		p_cinfo	= (gp_marshald_cinfo + i_cnt);

		if( -1 == p_cinfo->i_cinfo_id )		{ continue; }

		/* host = client */
		if( DRD64_MARSHALD_CINFOTYPE_CLIENT
								== p_cinfo->b_cinfo_type )	{
			if( 0x00 == Drd64_LibBrownie_INetAddr_CmpInAddr(
							p_addr, &(p_cinfo->t_dest_addr_inet)) )
				{ return p_cinfo; }
		}
		/* host = server */
		else if( DRD64_MARSHALD_CINFOTYPE_SERVER
								== p_cinfo->b_cinfo_type )	{
			if( 0x00 == Drd64_LibBrownie_INetAddr_CmpInAddr(
							p_addr, &(p_cinfo->t_src_addr_inet)) )
				{ return p_cinfo; }
		}
	}

	return NULL;
}


EXTERN_MARSHALD_CINFO
Drd64_Marshald_ConnectInfo	*
	Drd64_Marshald_Search_DebugdConnection(
		int	i_prog_pid )
{
	int		i_cnt;
	Drd64_Marshald_ConnectInfo	*p_cinfo;

	p_cinfo	= NULL;
	
	for( i_cnt = 0; i_cnt < gi_marshald_cinfo_now; i_cnt++ )	{
		p_cinfo	= (gp_marshald_cinfo + i_cnt);

		if( -1 == p_cinfo->i_cinfo_id )		{ continue; }

		if( DRD64_MARSHALD_CINFOTYPE_DEBUGD
								== p_cinfo->b_cinfo_type )	{
			if( i_prog_pid == p_cinfo->i_prog_pid )
				{ return p_cinfo; }
		}
	}

	return NULL;
}


EXTERN_MARSHALD_CINFO
Drd64_Marshald_ConnectInfo	*
	Drd64_Marshald_CInfo_GetConnectInfo(
		int	i_cinfo_id )
{
	if(( 0 > i_cinfo_id ) || ( gi_marshald_cinfo_max < i_cinfo_id ))
		{ return NULL; }
	return (gp_marshald_cinfo + i_cinfo_id);
}


// Alloc
EXTERN_MARSHALD_CINFO
Drd64_Marshald_ConnectInfo	*
	Drd64_Marshald_CInfo_AllocConnectInfo(
		void )
{
	int							i_cnt;
	int							i_cinfo_newid;
	Drd64_Marshald_ConnectInfo	*p_cinfo_temp;
	Drd64_Marshald_ConnectInfo	*p_cinfo_now;

	p_cinfo_now		= NULL;
	i_cinfo_newid		= -1;

	if( gi_marshald_cinfo_now == gi_marshald_cinfo_max )	{
		for( i_cnt = 0; i_cnt < gi_marshald_cinfo_max; i_cnt++ )	{
			p_cinfo_temp	= gp_marshald_cinfo + i_cnt;

			if( -1 == p_cinfo_temp->i_cinfo_id )	{
				i_cinfo_newid	= i_cnt;
				break;
			}
		}

		if( -1 == i_cinfo_newid )	{
			p_cinfo_temp
				= (Drd64_Marshald_ConnectInfo *)
					realloc( gp_marshald_cinfo,
							sizeof( Drd64_Marshald_ConnectInfo )
								* ( gi_marshald_cinfo_max
									+ DRD64_MARSHALD_CINFO_UNITS) );
			if( NULL == p_cinfo_temp )	{ return NULL; }

			gp_marshald_cinfo	= p_cinfo_temp;
			gi_marshald_cinfo_max	+= DRD64_MARSHALD_CINFO_UNITS;
			i_cinfo_newid	= gi_marshald_cinfo_now++;
		}
	}
	else	{
		i_cinfo_newid	= gi_marshald_cinfo_now++;
	}

	if( -1 != i_cinfo_newid )	{
		p_cinfo_now	= gp_marshald_cinfo + i_cinfo_newid;

		memset( p_cinfo_now, 0x00, sizeof( Drd64_Marshald_ConnectInfo ) );
		p_cinfo_now->i_cinfo_id	= i_cinfo_newid;
		p_cinfo_now->i_dest_cinfo_id	= DRD64_CONNECTID_NONE;
		p_cinfo_now->i_dest_socket		= -1;
		p_cinfo_now->p_dest_cinfo_connection = NULL;
		p_cinfo_now->i_src_cinfo_id		= DRD64_CONNECTID_NONE;
		p_cinfo_now->i_src_socket		= -1;
		p_cinfo_now->p_src_cinfo_connection = NULL;
		p_cinfo_now->i_debugd_socket	= -1;
		p_cinfo_now->i_client_socket	= -1;
	}

	return	p_cinfo_now;
}


// Free
EXTERN_MARSHALD_CINFO
int
	Drd64_Marshald_Cinfo_FreeConnectInfo(
		Drd64_Marshald_ConnectInfo *p_cinfo )
{
	int		i_cnt;
	Drd64_Marshald_ConnectInfo	*p_cinfo_temp;

	if( NULL == p_cinfo )	{ return 0x01; }

	//if( p_cinfo->i_cinfo_id + 1 == gi_marshald_cinfo_now )
		//{ gi_marshald_cinfo_now--; }
	for( i_cnt = gi_marshald_cinfo_now - 1; i_cnt >= 0 ; i_cnt-- )	{
		p_cinfo_temp	= (gp_marshald_cinfo + i_cnt);
		assert( NULL != p_cinfo_temp );

		if( -1 < p_cinfo_temp->i_cinfo_id )	{ break; }
	}

	gi_marshald_cinfo_now	= i_cnt + 1;
	p_cinfo->i_cinfo_id	= -1;

	return 0x00;
}


EXTERN_MARSHALD_CINFO
int
	Drd64_Marshald_CInfo_InitConnectInfo(
		void )
{

	gp_marshald_cinfo
		= (Drd64_Marshald_ConnectInfo *)malloc(
				sizeof( Drd64_Marshald_ConnectInfo )
					* DRD64_MARSHALD_CINFO_UNITS );

	if( NULL == gp_marshald_cinfo )		{
		return 0x01;
	}
						
	memset( gp_marshald_cinfo, 0x00,
				sizeof( Drd64_Marshald_ConnectInfo )
					* DRD64_MARSHALD_CINFO_UNITS );

	gi_marshald_cinfo_max	= DRD64_MARSHALD_CINFO_UNITS;
	gi_marshald_cinfo_now	= 0;

	return 0x00;
}


EXTERN_MARSHALD_CINFO
int
	Drd64_Marshald_CInfo_TermConnectInfo(
		void )
{
	if( NULL != gp_marshald_cinfo )		{
		free( gp_marshald_cinfo );
		gp_marshald_cinfo	= NULL;
	}

	gi_marshald_cinfo_max	= DRD64_MARSHALD_CINFO_UNITS;
	gi_marshald_cinfo_now	= 0;

	return 0x00;
}


/* EOF of drd64_.c ----------------------------------- */
