/*DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64

                         D r . D e a m o n  6 4
                        for INTEL64(R), AMD64(R)
	
   Copyright(C) 2007-2009 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64*/

/* File Info -----------------------------------------------------------
File: drd64_.c
Function: 
Comment: 
----------------------------------------------------------------------*/

#include"drd64_marshald.h"


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
int
	Drd64_Marshald_Cmd_AttachReport_Local_Answer(
		int		i_recv_id,
		Drd64_PacketHeader	*p_phead,
		Drd64_PacketData_AttachReport		*p_areport,
		Drd64_Marshald_MasterInformation	*p_marshald )
{
	int		i_result;
	int		i_err;
	Drd64_Marshald_ConnectInfo	*p_cinfo;

	DRD64_LOG_DEBUG("  [DEBUG]CMD: Attach Report (Local : Answer) Start");

	i_result	= DRD64_MARSHALD_DISPATCH_RESULT_COMPLETE;

	p_phead->i_cid_dest	= p_phead->i_cid_client;

	p_cinfo	= Drd64_Marshald_CInfo_GetConnectInfo( p_phead->i_cid_dest );
	assert( NULL != p_cinfo );

	p_phead->w_packettype   ^= DRD64_PACKETTYPE_OPTION_INDICATE;

	i_err  = send( p_cinfo->i_client_socket, (void *)p_phead,
                        DRD64_PacketSize(p_phead), 0x00 );
	DRD64_DEBUG_PRINT("send",i_err,"FD",p_cinfo->i_client_socket,"errno",errno);
	if( i_err != DRD64_PacketSize(p_phead) )   { return 0x02; }

	DRD64_LOG_DEBUG("  [DEBUG]CMD: Attach Report (Local : Answer) Ended");

	return i_result;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
int
	Drd64_Marshald_Cmd_AttachReport_Local_Request(
		int		i_recv_id,
		Drd64_PacketHeader	*p_phead,
		Drd64_PacketData_AttachReport		*p_areport,
		Drd64_Marshald_MasterInformation	*p_marshald )
{
	int		i_result;
	int		i_err;
	Drd64_Marshald_ConnectInfo	*p_cinfo;
	Drd64_Marshald_ConnectInfo	*p_cinfo_debugd;

	DRD64_LOG_DEBUG("  [DEBUG]CMD: Attach Report (Local : Request) Start");

	i_result	= DRD64_MARSHALD_DISPATCH_RESULT_COMPLETE;

	p_cinfo	= Drd64_Marshald_CInfo_GetConnectInfo( p_phead->i_cid_dest );
	assert( NULL != p_cinfo );

	p_cinfo_debugd	= Drd64_Marshald_Connect_Debugd(
						p_cinfo->str_dest_addr_local,
						p_cinfo->i_prog_pid,
						p_cinfo->i_debugd_pid );
	
	p_cinfo->i_dest_socket		= p_cinfo_debugd->i_dest_socket;
	p_cinfo->i_debugd_socket	= p_cinfo_debugd->i_dest_socket;
	p_cinfo->p_dest_cinfo_connection	= p_cinfo_debugd;

	p_phead->w_packettype   |= DRD64_PACKETTYPE_OPTION_INDICATE;
	p_phead->i_cid_client   = p_phead->i_cid_dest;
	p_phead->i_cid_dest     = DRD64_CONNECTID_NONE;
	p_phead->i_cid_src      = p_cinfo_debugd->i_cinfo_id;

	i_err  = send( p_cinfo_debugd->i_dest_socket, (void *)p_phead,
                        DRD64_PacketSize(p_phead), 0x00 );
	DRD64_DEBUG_PRINT("send",i_err,"FD",p_cinfo_debugd->i_dest_socket,"errno",errno);
	if( i_err != DRD64_PacketSize(p_phead) )   { return 0x02; }


	DRD64_LOG_DEBUG("  [DEBUG]CMD: Attach Report (Local : Request) Ended");

	return i_result;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
int
	Drd64_Marshald_Cmd_AttachReport_Inet(
		int		i_recv_id,
		Drd64_PacketHeader	*p_phead,
		Drd64_PacketData_AttachReport		*p_areport,
		Drd64_Marshald_MasterInformation	*p_marshald )
{
	int		i_result;
	int		i_err;
	Drd64_Marshald_ConnectInfo	*p_cinfo;

	DRD64_LOG_DEBUG("  [DEBUG]CMD: Attach Report (INet) Start");

	i_result	= DRD64_MARSHALD_DISPATCH_RESULT_COMPLETE;

	p_cinfo	= Drd64_Marshald_CInfo_GetConnectInfo( p_phead->i_cid_dest );
	assert( NULL != p_cinfo );

	p_phead->w_packettype   |= DRD64_PACKETTYPE_FLAG_ANSWER;

	i_err  = send( p_cinfo->i_client_socket, (void *)p_phead,
                        DRD64_PacketSize(p_phead), 0x00 );
	DRD64_DEBUG_PRINT("send",i_err,"FD",p_cinfo->i_client_socket,"errno",errno);
	if( i_err != DRD64_PacketSize(p_phead) )   { return 0x02; }

	DRD64_LOG_DEBUG("  [DEBUG]CMD: Attach Report (INet) Ended");

	return i_result;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
int
	Drd64_Marshald_Cmd_AttachReport(
		int		i_recv_id,
		Drd64_PacketHeader	*p_phead,
		Drd64_PacketData_AttachReport		*p_areport,
		Drd64_Marshald_MasterInformation	*p_marshald )
{
	int		i_result;
	Drd64_Marshald_ConnectInfo		*p_cinfo;

	DRD64_LOG_VERBOSE("[STAT]CMD: Attach Report Start");

	i_result	= DRD64_MARSHALD_DISPATCH_RESULT_COMPLETE;

	if( DRD64_IsPacketType_Answer( p_phead ) )	{
		/* debugee is localhost(answer) */
		i_result = Drd64_Marshald_Cmd_AttachReport_Local_Answer(
						i_recv_id, p_phead, p_areport, p_marshald );
	}
	else	{
		p_cinfo = Drd64_Marshald_CInfo_GetConnectInfo( p_phead->i_cid_dest );
		assert( NULL != p_cinfo );

		if( -1 == p_cinfo->i_dest_socket )	{
			/* debugee is localhost(request) */
			i_result
				= Drd64_Marshald_Cmd_AttachReport_Local_Request(
						i_recv_id, p_phead, p_areport, p_marshald );
		}
		else	{
			/* debugee is INet */
			i_result	= Drd64_Marshald_Cmd_AttachReport_Inet(
							i_recv_id, p_phead, p_areport, p_marshald );
		}
	}

	DRD64_LOG_VERBOSE("[STAT]CMD: Attach Report Ended");

	return i_result;
}


/* EOF of drd64_.c ----------------------------------- */
