/*DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64

                         D r . D e a m o n  6 4
                        for INTEL64(R), AMD64(R)
	
   Copyright(C) 2007-2009 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64*/

/* File Info -----------------------------------------------------------
File: drd64_.c
Function: 
Comment: 
----------------------------------------------------------------------*/

#define	DRD64_SRCID_MARSHALD_CMD_ATTACH_REQUEST	0x0000
#include"drd64_marshald.h"


#define DRD64_CMDSTATUS_ATTACHREQ_NORMAL		0x00
#define DRD64_CMDSTATUS_ATTACHREQ_WAITCONNECT	0x01
//#define DRD64_CMDSTATUS_ATTACHREQ_WAITTRANS		0x02
#define DRD64_CMDSTATUS_ATTACHREQ_WAITEXEC		0x03


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
#define	DRD64_FUNCID_Marshald_Cmd_AttachRequest_Scn5	0x15
int
	Drd64_Marshald_Cmd_AttachRequest_Scn5_RecvTranAttachReq(
		int		i_recv_id,
		Drd64_PacketHeader					*p_phead,
		Drd64_PacketData_AttachRequest		*p_attachreq,
		Drd64_Marshald_MasterInformation	*p_marshald )
{
	int		i_wlen;
	//int		i_result;
	DWord	dw_errcode;
	DWord	dw_location;
	int		i_fds;
	Drd64_Marshald_ConnectInfo	*p_cinfo_client;
	Drd64_Marshald_ConnectInfo	*p_cinfo_self;

	DRD64_LOG_DEBUG(
		"  [DEBUG]CMD: Attach Req. (Scn5:RecvTransAttachReq) Start");

	dw_errcode	= DRD64_ERROR_CODE_CLEAR;
	dw_location	= DRD64_ERROR_SET_LOCATION(
						DRD64_ERROR_MODULE_MARSHALD,
						DRD64_ERROR_ARCH_NODEPEND,
						DRD64_SRCID_MARSHALD_CMD_ATTACH_REQUEST,
						DRD64_FUNCID_Marshald_Cmd_AttachRequest_Scn5 );

	/* Phase 0 : Init ----------------------------*/
	p_cinfo_client	= Drd64_Marshald_CInfo_GetConnectInfo(
									p_phead->i_cid_client );
	assert( NULL != p_cinfo_client );

	i_fds	= p_cinfo_client->i_src_socket;
	assert( -1 < i_fds );


	/* Phase 0 : Init ----------------------------*/
	p_cinfo_self	= Drd64_Marshald_CInfo_GetConnectInfo(
									p_attachreq->i_cid_marshald );
	assert( NULL != p_cinfo_self );
	
	p_cinfo_self->i_dest_cinfo_id	= p_attachreq->i_cid_debugd;
	strncpy( p_cinfo_self->str_dest_addr_local,
				p_attachreq->str_debugd_sockname,
				DRD64_MAX_PATH );

	p_cinfo_self->i_debugd_pid_real	= p_attachreq->i_debugd_pid;


	/* Set Answer Data ---------*/
	//p_attach->i_cid					= p_phead->i_cid_dest;	//XXX
	//p_attach->i_cid_debugd			= p_attach->i_cid_marshald;
	//p_attach->i_cid_marshald		= DRD64_CONNECTID_NONE;

	/* Phase 0 : Init ----------------------------*/
	p_phead->w_packettype			|= DRD64_PACKETTYPE_FLAG_ANSWER;
	p_phead->i_cid_dest				= p_phead->i_cid_client;
	p_phead->i_cid_src				= DRD64_CONNECTID_NONE;
	p_phead->i_cid_client			= DRD64_CONNECTID_NONE;

	/* Phase 0 : Init ----------------------------*/
	i_wlen  = send( i_fds, (void *)p_phead,
						DRD64_PacketSize(p_phead), 0x00 );
	DRD64_DEBUG_PRINT("send",i_wlen,"FD",i_fds,"errno",errno);
	if( i_wlen != DRD64_PacketSize(p_phead) )	{
		dw_errcode  = DRD64_ERROR_SET_CODE( DRD64_ERROR_TYPE_ERROR,
							DRD64_ERROR_PTN_SOCKET, 0x00, 0x01 );
		Drd64_LibBrownie_Error_SetErrorInfo(
				dw_errcode, dw_location, errno );

		/* NOT send for Error Packet ( because Socket Error ) */
		return DRD64_MARSHALD_DISPATCH_RESULT_CLOSE;
	} 

	DRD64_LOG_DEBUG(
		"  [DEBUG]CMD: Attach Req. (Scn5:RecvTransAttachReq) Ended");

	return DRD64_MARSHALD_DISPATCH_RESULT_COMPLETE;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
#define	DRD64_FUNCID_Marshald_Cmd_AttachRequest_Scn4	0x14
int
	Drd64_Marshald_Cmd_AttachRequest_Scn4_RecvBootInfo(
		int		i_recv_id,
		Drd64_PacketHeader					*p_phead,
		Drd64_PacketData_AttachRequest		*p_attach,
		Drd64_Marshald_MasterInformation	*p_marshald )
{
	int		i_wlen;
	int		i_fds;
	DWord	dw_errcode;
	DWord	dw_location;
	Drd64_Marshald_ConnectInfo	*p_cinfo;

	DRD64_LOG_DEBUG("  [DEBUG]CMD: Attach Req. (Scn4:RecvBootInfo) Start");

	dw_errcode	= DRD64_ERROR_CODE_CLEAR;
	dw_location	= DRD64_ERROR_SET_LOCATION(
						DRD64_ERROR_MODULE_MARSHALD,
						DRD64_ERROR_ARCH_NODEPEND,
						DRD64_SRCID_MARSHALD_CMD_ATTACH_REQUEST,
						DRD64_FUNCID_Marshald_Cmd_AttachRequest_Scn4 );

	p_cinfo	= Drd64_Marshald_CInfo_GetConnectInfo(
									p_phead->i_cid_dest );
	assert( NULL != p_cinfo );

	i_fds	= Drd64_Server_RecvStatus_GetSocketID( i_recv_id );
	assert( -1 != i_fds );

	/* Set Answer Data ---------*/
	p_phead->dw_errcode				= dw_errcode;
	p_phead->dw_errlocation			= dw_location;
	p_phead->w_packettype			|= DRD64_PACKETTYPE_FLAG_ANSWER;

	i_fds = p_cinfo->i_src_socket;
	i_wlen  = send( i_fds, (void *)p_phead,
						DRD64_PacketSize(p_phead), 0x00 );
	DRD64_DEBUG_PRINT("send",i_wlen,"FD",i_fds,"errno",errno);

	if( i_wlen != DRD64_PacketSize(p_phead) )		{
		dw_errcode  = DRD64_ERROR_SET_CODE( DRD64_ERROR_TYPE_ERROR,
							DRD64_ERROR_PTN_SOCKET, 0x00, 0x01 );
		Drd64_LibBrownie_Error_SetErrorInfo(
				dw_errcode, dw_location, errno );

		/* NOT send for Error Packet ( because Socket Error ) */
		return DRD64_MARSHALD_DISPATCH_RESULT_CLOSE;
	}

	DRD64_LOG_DEBUG("  [DEBUG]CMD: Attach Req. (Scn4:RecvBootInfo) Ended");

	return DRD64_MARSHALD_DISPATCH_RESULT_COMPLETE;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
#define	DRD64_FUNCID_Marshald_Cmd_AttachRequest_Scn2	0x12
int
	Drd64_Marshald_Cmd_AttachRequest_Scn2_ConnectINetMarshald(
		int		i_recv_id,
		Drd64_PacketHeader	*p_phead,
		Drd64_PacketData_AttachRequest	*p_attachreq,
		Drd64_Marshald_MasterInformation	*p_marshald )
{
	int		i_err;
	int		i_result;
	DWord	dw_errcode;
	DWord	dw_location;
	Drd64_Marshald_ConnectInfo	*p_cinfo_inet;

	DRD64_LOG_DEBUG(
		"  [DEBUG]CMD: Attach Req. (Scn2:ConnectINetMarshald) Start");

	i_result	= DRD64_MARSHALD_DISPATCH_RESULT_CLOSE;
	dw_errcode	= DRD64_ERROR_CODE_CLEAR;
	dw_location	= DRD64_ERROR_SET_LOCATION(
						DRD64_ERROR_MODULE_MARSHALD,
						DRD64_ERROR_ARCH_NODEPEND,
						DRD64_SRCID_MARSHALD_CMD_ATTACH_REQUEST,
						DRD64_FUNCID_Marshald_Cmd_AttachRequest_Scn2 );

	i_err	= Drd64_Marshald_Connect_Marshald(
				&p_cinfo_inet, &(p_attachreq->t_prog_addr), i_recv_id );

	if( 0 < i_err )	{
		i_result
			= Drd64_Marshald_Cmd_AttachRequest_Scn3_TransAttachRequest(
						i_recv_id, p_phead, p_attachreq, p_marshald );
	}
	else if( 0 == i_err )	{
		Drd64_Server_RecvStatus_SetCmdStatus( i_recv_id,
						DRD64_CMDSTATUS_ATTACHREQ_WAITCONNECT );

		/* Polling form debugd-Initialized */
		i_result	= DRD64_MARSHALD_DISPATCH_RESULT_POLL; 
	}
	else	{
		dw_errcode  = DRD64_ERROR_SET_CODE( DRD64_ERROR_TYPE_ERROR,
						DRD64_ERROR_PTN_FUNCTION, 0x00, 0x01 );
        Drd64_LibBrownie_Error_SetErrorInfo(
						dw_errcode, dw_location, errno );
		/* send answer */
	}

	DRD64_LOG_DEBUG(
		"  [DEBUG]CMD: Attach Req. (Scn2:ConnectINetMarshald) Ended");

	return i_result;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
#define	DRD64_FUNCID_Marshald_Cmd_AttachRequest_Scn3	0x13
int
	Drd64_Marshald_Cmd_AttachRequest_Scn3_TransAttachRequest(
		int		i_recv_id,
		Drd64_PacketHeader	*p_phead,
		Drd64_PacketData_AttachRequest	*p_attachreq,
		Drd64_Marshald_MasterInformation	*p_marshald )
{
	int		i_err;
	int		i_result;
	DWord	dw_errcode;
	DWord	dw_location;
	Drd64_Marshald_ConnectInfo	*p_cinfo_dest;
	Drd64_Marshald_ConnectInfo	*p_cinfo_now;
	Drd64_Marshald_ConnectInfo	*p_cinfo_marshald;

	DRD64_LOG_DEBUG("  [DEBUG]CMD: Attach Req. (Scn3:TransAttachReq.) Start");

	i_result	= DRD64_MARSHALD_DISPATCH_RESULT_CLOSE;
	dw_errcode	= DRD64_ERROR_CODE_CLEAR;
	dw_location	= DRD64_ERROR_SET_LOCATION(
						DRD64_ERROR_MODULE_MARSHALD,
						DRD64_ERROR_ARCH_NODEPEND,
						DRD64_SRCID_MARSHALD_CMD_ATTACH_REQUEST,
						DRD64_FUNCID_Marshald_Cmd_AttachRequest_Scn3 );

	/* Phase 0 : Init ----------------------------*/
	p_cinfo_dest = Drd64_Marshald_SearchINetConnection(
								&(p_attachreq->t_prog_addr) );
	assert( NULL != p_cinfo_dest );

	/* Phase 1 : Init ----------------------------*/
	p_cinfo_marshald
		= Drd64_Marshald_CInfo_GetConnectInfo( p_phead->i_cid_dest );
	assert( NULL != p_cinfo_marshald );

	p_cinfo_now	= Drd64_Marshald_CInfo_AllocConnectInfo();
	if( NULL == p_cinfo_now )	{
		dw_errcode  = DRD64_ERROR_SET_CODE( DRD64_ERROR_TYPE_ERROR,
						DRD64_ERROR_PTN_NOMEMORY, 0x00, 0x01 );
        Drd64_LibBrownie_Error_SetErrorInfo(
						dw_errcode, dw_location, errno );
		/* send answer */
		return DRD64_MARSHALD_DISPATCH_RESULT_COMPLETE;
	}

	/* Phase 0 : Init ----------------------------*/
	/* Phase 3-1 : Set ConnectInfo ---*/
	p_cinfo_now->b_cinfo_type		= DRD64_MARSHALD_CINFOTYPE_ATTACH;
	p_cinfo_now->i_cinfo_refcount	= 1;

	Drd64_LibBrownie_INetAddr_CopyInAddr(
					&(p_cinfo_now->t_dest_addr_inet),
					&(p_attachreq->t_prog_addr) );
	p_cinfo_now->i_dest_cinfo_id	= -1;	/* Set Value is Scn5 */
	p_cinfo_now->i_dest_socket		= p_cinfo_dest->i_dest_socket;
	/* Set p_cinfo_now->str_dest_addr_local is Scn5 */
	p_cinfo_now->p_dest_cinfo_connection	= p_cinfo_dest;

	i_err	= Drd64_LibBrownie_INetAddr_SetInAddr_LocalHost(
					&(p_cinfo_now->t_src_addr_inet) );
    if( 0x00 != i_err )   {
		dw_errcode  = DRD64_ERROR_SET_CODE( DRD64_ERROR_TYPE_ERROR,
						DRD64_ERROR_PTN_INETADDR, 0x00, 0x02 );
        Drd64_LibBrownie_Error_SetErrorInfo(
						dw_errcode, dw_location, errno );
		Drd64_Marshald_Cinfo_FreeConnectInfo( p_cinfo_now );
		/* send answer */
        return DRD64_MARSHALD_DISPATCH_RESULT_COMPLETE;
    }

	p_cinfo_now->i_src_cinfo_id		= DRD64_CONNECTID_NONE;
	p_cinfo_now->i_src_socket
					= Drd64_Server_RecvStatus_GetSocketID( i_recv_id );
	p_cinfo_now->p_src_cinfo_connection		= p_cinfo_marshald;

	Drd64_LibBrownie_INetAddr_CopyInAddr(
					&(p_cinfo_now->t_prog_addr_inet),
					&(p_attachreq->t_prog_addr) );
	p_cinfo_now->i_prog_pid			= p_attachreq->i_prog_pid;

	p_cinfo_now->i_debugd_pid		= p_cinfo_dest->i_dest_pid;
	p_cinfo_now->i_debugd_pid_real	= -1;	/* Set Value is Scn5 */
	p_cinfo_now->i_debugd_socket	= p_cinfo_dest->i_dest_socket;

	Drd64_LibBrownie_INetAddr_CopyInAddr(
					&(p_cinfo_now->t_client_addr_inet),
					&(p_cinfo_marshald->t_client_addr_inet) );
	p_cinfo_now->i_client_socket	= p_cinfo_marshald->i_client_socket;
	p_cinfo_now->i_client_pid		= p_cinfo_marshald->i_client_pid;

	/* Phase 3-2 : Set Attach Request Struct Answer data */
	p_attachreq->i_cid_marshald		= p_cinfo_now->i_cinfo_id;


	/* Phase 0 : Init ----------------------------*/
	p_phead->w_packettype	|= DRD64_PACKETTYPE_FLAG_TRANSPORT;
	//p_phead->i_resume_recvstatus_id = i_recv_id;
	p_phead->i_cid_client	= p_phead->i_cid_dest;
	p_phead->i_cid_dest		= p_cinfo_dest->i_dest_cinfo_id;
	p_phead->i_cid_src		= p_cinfo_dest->i_cinfo_id;

	/* Phase 0 : Init ----------------------------*/
	i_err  = send( p_cinfo_dest->i_dest_socket, (void *)p_phead,
                                DRD64_PacketSize(p_phead), 0x00 );
    DRD64_DEBUG_PRINT("send",i_err,"FD",p_cinfo_dest->i_dest_socket,"errno",errno);
    if( i_err != DRD64_PacketSize(p_phead) )   {
		dw_errcode  = DRD64_ERROR_SET_CODE( DRD64_ERROR_TYPE_ERROR,
						DRD64_ERROR_PTN_SOCKET, 0x00, 0x03 );
        Drd64_LibBrownie_Error_SetErrorInfo(
						dw_errcode, dw_location, errno );
		Drd64_Marshald_Cinfo_FreeConnectInfo( p_cinfo_now );
		/* NOT send Error Answer Packet because socket error */
        return DRD64_MARSHALD_DISPATCH_RESULT_CLOSE;
    }

	/*Drd64_Server_RecvStatus_SetCmdStatus( i_recv_id,
						DRD64_CMDSTATUS_ATTACHREQ_WAITTRANS );*/
	Drd64_Server_RecvStatus_SetCmdStatus( i_recv_id,
						DRD64_CMDSTATUS_ATTACHREQ_NORMAL );

	DRD64_LOG_DEBUG("  [DEBUG]CMD: Attach Req. (Scn3:TransAttachReq.) Ended");

	/* Polling form debugd-Initialized */
	return DRD64_MARSHALD_DISPATCH_RESULT_COMPLETE;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
#define	DRD64_FUNCID_Marshald_Cmd_AttachRequest_Scn1	0x11
int
	Drd64_Marshald_Cmd_AttachRequest_Scn1_BootDebugd(
		int		i_recv_id,
		Drd64_PacketHeader					*p_phead,
		Drd64_PacketData_AttachRequest		*p_attach,
		Drd64_Marshald_MasterInformation	*p_marshald )
{
	DWord		dw_errcode;
	DWord		dw_location;
	Drd64_Marshald_ConnectInfo		*p_cinfo_now;
	Drd64_Marshald_ConnectInfo		*p_cinfo_marshald;
	char	str_sockname_client[DRD64_MAX_PATH+1];
	int		i_pid_debugd;

	DRD64_LOG_DEBUG("  [DEBUG]CMD: Attach Req. (Scn1:BootDebugd) Start");

	/* Phase 0 : Init =============================*/
	dw_errcode	= DRD64_ERROR_CODE_CLEAR;
	dw_location	= DRD64_ERROR_SET_LOCATION(
						DRD64_ERROR_MODULE_MARSHALD,
						DRD64_ERROR_ARCH_NODEPEND,
						DRD64_SRCID_MARSHALD_CMD_ATTACH_REQUEST,
						DRD64_FUNCID_Marshald_Cmd_AttachRequest_Scn1 );

	p_cinfo_now	= Drd64_Marshald_CInfo_AllocConnectInfo();
	if( NULL == p_cinfo_now )		{
		dw_errcode  = DRD64_ERROR_SET_CODE(
							DRD64_ERROR_TYPE_ERROR,
							DRD64_ERROR_PTN_NOMEMORY,
							0x00, 0x01 );
		Drd64_LibBrownie_Error_SetErrorInfo(
				dw_errcode, dw_location, errno );

		// XXX : send Error Answer Packet 
		return 0x00;
	}

	p_cinfo_marshald
		= Drd64_Marshald_CInfo_GetConnectInfo( p_phead->i_cid_dest );
	assert( NULL != p_cinfo_marshald );


	/* Phase 1 : Boot Debugd ======================*/
	i_pid_debugd	= Drd64_Marshald_Boot_Debugd(
							str_sockname_client, p_attach->i_prog_pid,
							i_recv_id, p_cinfo_now->i_cinfo_id );
	if( 0 > i_pid_debugd )		{
		dw_errcode  = DRD64_ERROR_SET_CODE(
							DRD64_ERROR_TYPE_ERROR,
							DRD64_ERROR_PTN_NOMEMORY,
							0x00, 0x01 );
		Drd64_LibBrownie_Error_SetErrorInfo(
				dw_errcode, dw_location, errno );

		// XXX : send Error Answer Packet 
		return 0x00;
	}


	/* Phase 2 : Set Connect Info. ================*/

	/* Phase 2-1 : Set ConnectInfo ---*/
	p_cinfo_now->b_cinfo_type		= DRD64_MARSHALD_CINFOTYPE_ATTACH;
	p_cinfo_now->i_cinfo_refcount	= 1;

	Drd64_LibBrownie_INetAddr_SetInAddr_LocalHost(
						&(p_cinfo_now->t_dest_addr_inet) );
	p_cinfo_now->i_dest_cinfo_id		= DRD64_CONNECTID_NONE;
	p_cinfo_now->i_dest_socket			= -1;
			/* Set Value is AttachLink(Inet) or AttachReport(local) */
	strncpy( p_cinfo_now->str_dest_addr_local,
				str_sockname_client, DRD64_MAX_PATH );
	p_cinfo_now->p_dest_cinfo_connection	= NULL;
			/* Set Value is AttachLink(Inet) or AttachReport(local) */

	Drd64_LibBrownie_INetAddr_CopyInAddr(
				&(p_cinfo_now->t_src_addr_inet),
				&(p_cinfo_marshald->t_client_addr_inet) );
	// XXX?
	p_cinfo_now->i_src_cinfo_id			= p_phead->i_cid_dest;
	p_cinfo_now->i_src_socket			= p_cinfo_marshald->i_src_socket;
	p_cinfo_now->p_src_cinfo_connection	= p_cinfo_marshald;

	Drd64_LibBrownie_INetAddr_CopyInAddr(
						&(p_cinfo_now->t_prog_addr_inet),
						&(p_attach->t_prog_addr) );
	p_cinfo_now->i_prog_pid				= p_attach->i_prog_pid;

	p_cinfo_now->i_debugd_pid			= i_pid_debugd;
	p_cinfo_now->i_debugd_pid_real		= i_pid_debugd;
	p_cinfo_now->i_debugd_socket		= -1;
			/* Set Value is AttachLink(Inet) or AttachReport(local) */

	Drd64_LibBrownie_INetAddr_CopyInAddr(
						&(p_cinfo_now->t_client_addr_inet),
						&(p_cinfo_marshald->t_client_addr_inet) );
	p_cinfo_now->i_client_socket		= p_cinfo_marshald->i_client_socket;
			/* i_client_socket is override by AttachLink(INet) */
	p_cinfo_now->i_client_pid			= p_cinfo_marshald->i_client_pid;
			/* i_client_pid is override by AttachLink(INet) */

	/* Phase 2-2 : Set Attach Request Struct Answer data */
	strncpy( p_attach->str_debugd_sockname,
				str_sockname_client, DRD64_MAX_PATH );
	p_attach->i_debugd_pid		= i_pid_debugd;

	if( DRD64_IsPacketTypeFlag(p_phead,
				DRD64_PACKETTYPE_FLAG_TRANSPORT) )		{
		p_attach->i_cid_debugd		= p_cinfo_now->i_cinfo_id;
	}
	else	{
		p_attach->i_cid_debugd		= DRD64_CONNECTID_NONE;
		p_attach->i_cid_marshald	= p_cinfo_now->i_cinfo_id;
	}

	Drd64_Server_RecvStatus_SetCmdStatus( i_recv_id,
							DRD64_CMDSTATUS_ATTACHREQ_WAITEXEC );


	DRD64_LOG_DEBUG("  [DEBUG]CMD: Attach Req. (Scn1:BootDebugd) Ended");

	/* Polling form debugd-Initialized */
	return DRD64_MARSHALD_DISPATCH_RESULT_POLL;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
#define DRD64_FUNCID_Marshald_Cmd_AttachRequest	0x01
int
	Drd64_Marshald_Cmd_AttachRequest(
		int		i_recv_id,
		Drd64_PacketHeader	*p_phead,
		Drd64_PacketData_AttachRequest	*p_attachreq,
		Drd64_Marshald_MasterInformation	*p_marshald )
{
	int			i_result;
	int			i_cmd_status;
	int			i_inet_flag;
	Byte		b_packet_status;

	DRD64_LOG_VERBOSE("[STAT]CMD: Attach Request Start");

	i_result	= DRD64_MARSHALD_DISPATCH_RESULT_COMPLETE;

	b_packet_status = Drd64_Server_RecvStatus_GetPacketStatus( i_recv_id );
	if( DRD64_SERVER_RECVSTATUS_STATUS_ERROR == b_packet_status )
		{ return i_result; }

	i_cmd_status	= Drd64_Server_RecvStatus_GetCmdStatus( i_recv_id );
	if( -1 == i_cmd_status )
		{ return i_result; }
	
	i_inet_flag	= Drd64_LibBrownie_INetAddr_CmpInAddr(
						&(p_attachreq->t_prog_addr),
						&(p_marshald->t_marshald_addr) );

	if( DRD64_SERVER_RECVSTATUS_STATUS_READ == b_packet_status )	{
		/* Scenery 5 : Recv. Answer Trans. Attach req. from Inet Marshald -*/
		if( DRD64_IsPacketType_Answer( p_phead ) )	{
			i_result
				= Drd64_Marshald_Cmd_AttachRequest_Scn5_RecvTranAttachReq(
						i_recv_id, p_phead, p_attachreq, p_marshald );

		}
		else	{
			/* Scenery 1 : Local Debug Started (from Local or Inet)---*/
			if( 0x00 == i_inet_flag )	{
				i_result = Drd64_Marshald_Cmd_AttachRequest_Scn1_BootDebugd(
							i_recv_id, p_phead, p_attachreq, p_marshald );
	
			}
			/* Scenery 2 : Inet Debug Started (for Trans Inet Marshald ) ---*/
			else	{
				i_result
					= Drd64_Marshald_Cmd_AttachRequest_Scn2_ConnectINetMarshald(
							i_recv_id, p_phead, p_attachreq, p_marshald );
			}
		}
	}
	else if( DRD64_SERVER_RECVSTATUS_STATUS_RESUME == b_packet_status )	{
		/* Scenery 3 : Trans Attach Req. for Inet Marshald ---*/
		if( DRD64_CMDSTATUS_ATTACHREQ_WAITCONNECT == i_cmd_status )	{
			assert( 0x00 != i_inet_flag );

			i_result
				= Drd64_Marshald_Cmd_AttachRequest_Scn3_TransAttachRequest(
						i_recv_id, p_phead, p_attachreq, p_marshald );
		}
		/* Scenery 4 : Recv. BootInfo Cmd from Debugd ---*/
		else if( DRD64_CMDSTATUS_ATTACHREQ_WAITEXEC == i_cmd_status )	{
			i_result
				= Drd64_Marshald_Cmd_AttachRequest_Scn4_RecvBootInfo(
						i_recv_id, p_phead, p_attachreq, p_marshald );
		}
	}
	else	{
		/* XXX : Error Proc. */
	}

	return i_result;
}


/* EOF of drd64_.c ----------------------------------- */
