/*DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64

                         D r . D e a m o n  6 4
                        for INTEL64(R), AMD64(R)
	
   Copyright(C) 2007-2009 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64*/

/* File Info -----------------------------------------------------------
File: drd64_.c
Function: 
Comment: 
----------------------------------------------------------------------*/

#define	DRD64_SRCID_MARSHALD_CMD_CONNECT	0x0000
#include"drd64_marshald.h"

#define	DRD64_FUNCID_Marshald_Cmd_Connect_Client	0x12
#define	DRD64_FUNCID_Marshald_Cmd_Connect_Server	0x11
#define	DRD64_FUNCID_Marshald_Cmd_Connect			0x01

/*----------------------------------------------------------------------
static int
        Drd64_Intel64_DisAsm_GetSize_SizeID(
                : Get Operand Size form Intel 64 DB SizeID

                int i_operandsize,      : [src] Default Operand Size
                Word w_methodtype,      : [src] Method Type ID
                Word w_sizeid )         : [src] Size ID
----------------------------------------------------------------------*/
int
	Drd64_Marshald_Cmd_Connect_Client(
		int		i_fds,
		Drd64_PacketHeader	*p_phead,
		Drd64_PacketData_Connect	*p_connect )
{
	Drd64_Marshald_ConnectInfo	*p_cinfo;

	DRD64_LOG_DEBUG("  [DEBUG] CMD: Connect(Client) Start");
	
	p_cinfo	= Drd64_Marshald_CInfo_GetConnectInfo(
						p_connect->i_client_cinfo_id );
	assert( NULL != p_cinfo );

	p_cinfo->i_dest_cinfo_id	= p_connect->i_connect_id;


	DRD64_LOG_DEBUG("  [DEBUG] CMD: Connect(Client) Ended");

	return DRD64_MARSHALD_DISPATCH_RESULT_RESTART;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
int
	Drd64_Marshald_Cmd_Connect_Server(
		int		i_recv_id,
		Drd64_PacketHeader	*p_phead,
		Drd64_PacketData_Connect	*p_connect )
{
	int			i_wlen;
	int			i_fds;
	int			i_result;
	DWord		dw_errcode;
	DWord		dw_errlocation;
	Drd64_Marshald_ConnectInfo		*p_cinfo;
	Drd64_Server_RecvStatus			*p_recv;

	DRD64_LOG_DEBUG("  [DEBUG] CMD: Connect(Server) Start");

	i_result		= DRD64_MARSHALD_DISPATCH_RESULT_COMPLETE;
	dw_errcode		= DRD64_ERROR_CODE_CLEAR;
	dw_errlocation	= DRD64_ERROR_SET_LOCATION(
						DRD64_ERROR_MODULE_MARSHALD,
						DRD64_ERROR_ARCH_NODEPEND,
						DRD64_SRCID_MARSHALD_CMD_CONNECT,
						DRD64_FUNCID_Marshald_Cmd_Connect_Server );

	p_recv	= Drd64_Server_RecvStatus_GetRecvStatus( i_recv_id );
	assert( NULL != p_recv );
	i_fds	= p_recv->i_fds_id;
	
	/* Alloc ConnectInfo. */
	p_cinfo	= Drd64_Marshald_CInfo_AllocConnectInfo();
	if( NULL == p_cinfo )		{
		dw_errcode	= DRD64_ERROR_SET_CODE(
						DRD64_ERROR_TYPE_ERROR,
						DRD64_ERROR_PTN_NOMEMORY,
						0x00, 0x01 );
		Drd64_LibBrownie_Error_SetErrorInfo(
					dw_errcode, dw_errlocation, errno );

		i_result	=  DRD64_MARSHALD_DISPATCH_RESULT_CLOSE;

		goto goto_Marshald_Cmd_Connect_Server_Answer;
	}

	/* Set Cinfo Common Info. ---*/
	p_cinfo->b_cinfo_type	= DRD64_MARSHALD_CINFOTYPE_SERVER;
	p_cinfo->i_cinfo_refcount	= 1;

	/* p_cinfo->t_dest_addr_inet = NONE */
	p_cinfo->i_dest_cinfo_id		= -1;
	p_cinfo->i_dest_socket			= -1;
	p_cinfo->str_dest_addr_local[0]	= '\0'; 

	Drd64_LibBrownie_INetAddr_CopyInAddr(
						&(p_cinfo->t_src_addr_inet),
						&(p_connect->t_client_addr_inet) );
	p_cinfo->i_src_cinfo_id			= p_connect->i_client_cinfo_id;
	p_cinfo->i_src_socket			= i_fds;

	/* p_cinfo->t_src_addr_inet = NONE */
	p_cinfo->i_prog_pid				= -1;

	p_cinfo->i_debugd_pid			= -1;
	p_cinfo->i_debugd_socket		= -1;

	Drd64_LibBrownie_INetAddr_CopyInAddr(
				&(p_cinfo->t_client_addr_inet),
				&(p_connect->t_client_addr_inet) );
	p_cinfo->i_client_socket		= i_fds;
	p_cinfo->i_client_pid			= p_connect->i_client_pid;


	Drd64_Server_RecvStatus_SetConnectionInfoPointer(
									p_recv, (void *)p_cinfo );

    p_connect->i_connect_id		= p_cinfo->i_cinfo_id;
    p_connect->i_marshald_pid	= getpid();

	/* Set Answer Data ---------*/
goto_Marshald_Cmd_Connect_Server_Answer:
	p_phead->dw_errcode			= dw_errcode;
	p_phead->dw_errlocation		= dw_errlocation;
	p_phead->w_packettype		|= DRD64_PACKETTYPE_FLAG_ANSWER;

	i_wlen	= send( i_fds, (void *)p_phead, DRD64_PacketSize(p_phead), 0x00 );
	DRD64_DEBUG_PRINT("send",i_wlen,"Socket",i_fds,"errno",errno);
	if( i_wlen != DRD64_PacketSize(p_phead) )	{
		dw_errcode	= DRD64_ERROR_SET_CODE(
						DRD64_ERROR_TYPE_ERROR,
						DRD64_ERROR_PTN_SOCKET,
						0x00, 0x02 );
		Drd64_LibBrownie_Error_SetErrorInfo(
					dw_errcode, dw_errlocation, errno );

		i_result	=  DRD64_MARSHALD_DISPATCH_RESULT_CLOSE;
	}
	
	DRD64_LOG_DEBUG("  [DEBUG] CMD: Connect(Server) Complete ");

	return i_result;
}


/*----------------------------------------------------------------------
Drd64_Marshald_Cmd_Connect(
----------------------------------------------------------------------*/
int
	Drd64_Marshald_Cmd_Connect(
		int		i_recv_id,
		Drd64_PacketHeader	*p_phead,
		Drd64_PacketData_Connect	*p_connect )
{
	int		i_result;

	DRD64_LOG_VERBOSE("[STAT]CMD: Connect Start");
	
	if( DRD64_IsPacketType_Answer( p_phead ) )	{
		i_result	= Drd64_Marshald_Cmd_Connect_Client(
								i_recv_id, p_phead, p_connect );

	}
	else	{
		i_result	= Drd64_Marshald_Cmd_Connect_Server(
								i_recv_id, p_phead, p_connect );
	}
	
	DRD64_LOG_VERBOSE("[STAT]CMD: Connect Ended");

	return i_result;
}


/* EOF of drd64_.c ----------------------------------- */
