/*DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64

                         D r . D e a m o n  6 4
                        for INTEL64(R), AMD64(R)
	
   Copyright(C) 2007-2009 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64*/

/* File Info -----------------------------------------------------------
File: drd64_.c
Function: 
Comment: 
----------------------------------------------------------------------*/

#include"drd64_marshald.h"


/*----------------------------------------------------------------------
static int
        Drd64_Intel64_DisAsm_GetSize_SizeID(
                : Get Operand Size form Intel 64 DB SizeID

                int i_operandsize,      : [src] Default Operand Size
                Word w_methodtype,      : [src] Method Type ID
                Word w_sizeid )         : [src] Size ID
----------------------------------------------------------------------*/
int
	Drd64_Marshald_Cmd_ConnectCount_Client(
		int		i_fds,
		Drd64_PacketHeader	*p_phead,
		Drd64_PacketData_ConnectCount	*p_ccount )
{
	Drd64_Marshald_ConnectInfo	*p_cinfo;

	DRD64_LOG_DEBUG("  [DEBUG] CMD: ConnectCount(Client) Start");
	
	p_cinfo	= Drd64_Marshald_CInfo_GetConnectInfo(
									p_phead->i_cid_src );
	assert( NULL != p_cinfo );

	p_cinfo->i_cinfo_refcount	+= p_ccount->i_refcount_diff;

	if( p_cinfo->i_cinfo_refcount != p_ccount->i_refcount_server )	{
		DRD64_LOG_DEBUG("  [DEBUG] CMD: ConnectCount(Client) Error");
	}

	if( 0 == p_cinfo->i_cinfo_refcount )	{
		Drd64_Marshald_Dispatch_CloseSocket( p_cinfo->i_dest_socket );
		//Drd64_Marshald_Cinfo_FreeConnectInfo( p_cinfo );
		//p_cinfo     = NULL;
		DRD64_LOG_DEBUG("  [DEBUG] CMD: ConnectCount(Client) DisConnect");
	}

	DRD64_LOG_DEBUG("  [DEBUG] CMD: ConnectCount(Client) Ended");

	return DRD64_MARSHALD_DISPATCH_RESULT_RESTART;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
int
	Drd64_Marshald_Cmd_ConnectCount_Server(
		int		i_recv_id,
		Drd64_PacketHeader	*p_phead,
		Drd64_PacketData_ConnectCount	*p_ccount )
{
	int			i_wlen;
	int			i_fds;
	Drd64_Marshald_ConnectInfo		*p_cinfo;
	Drd64_Server_RecvStatus			*p_recv;

	DRD64_LOG_DEBUG("  [DEBUG] CMD: ConnectCount(Server) Start");

	p_recv	= Drd64_Server_RecvStatus_GetRecvStatus( i_recv_id );
	assert( NULL != p_recv );
	i_fds	= p_recv->i_fds_id;
	
	/* Alloc ConnectInfo. */
	p_cinfo = Drd64_Marshald_CInfo_GetConnectInfo( p_phead->i_cid_dest );
	assert( NULL != p_cinfo );

	p_cinfo->i_cinfo_refcount	+= p_ccount->i_refcount_diff; 
	/* XXX : Connection Lock
	if( 0 == p_cinfo->i_cinfo_refcount )	{
		// Connection LOCK!
	}
	*/

	/* Set Answer Data ---------*/
	p_phead->w_packettype		|= DRD64_PACKETTYPE_FLAG_ANSWER;
	p_ccount->i_refcount_server	= p_cinfo->i_cinfo_refcount;

	i_wlen	= send( i_fds, (void *)p_phead, DRD64_PacketSize(p_phead), 0x00 );
	DRD64_DEBUG_PRINT("send",i_wlen,"FD",i_fds,"errno",errno);
	if( i_wlen != DRD64_PacketSize(p_phead) )
		{ return DRD64_MARSHALD_DISPATCH_RESULT_CLOSE; }	// XXX > error
	
	DRD64_LOG_DEBUG("  [DEBUG] CMD: ConnectCount(Server) Complete ");

	return DRD64_MARSHALD_DISPATCH_RESULT_COMPLETE;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
int
	Drd64_Marshald_Cmd_ConnectCount(
		int		i_recv_id,
		Drd64_PacketHeader	*p_phead,
		Drd64_PacketData_ConnectCount	*p_ccount )
{
	int		i_result;

	DRD64_LOG_VERBOSE("[STAT]CMD: Connect Count Start");
	
	if( DRD64_IsPacketType_Answer( p_phead ) )	{
		i_result	= Drd64_Marshald_Cmd_ConnectCount_Client(
								i_recv_id, p_phead, p_ccount );

	}
	else	{
		i_result	= Drd64_Marshald_Cmd_ConnectCount_Server(
								i_recv_id, p_phead, p_ccount );
	}
	
	DRD64_LOG_VERBOSE("[STAT]CMD: Connect Count Ended");

	return i_result;
}


/* EOF of drd64_.c ----------------------------------- */
