/*DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64

                         D r . D e a m o n  6 4
                        for INTEL64(R), AMD64(R)
	
   Copyright(C) 2007-2009 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64*/

/* File Info -----------------------------------------------------------
File: drd64_.c
Function: 
Comment: 
----------------------------------------------------------------------*/

#include"drd64_marshald.h"

#define DRD64_CMDSTATUS_DETACH_NORMAL			0x00
#define DRD64_CMDSTATUS_DETACH_WAITDISCONNECT	0x01


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
int
	Drd64_Marshald_Cmd_Detach_Scn4_INetAnswer(
		int		i_recv_id,
		Drd64_PacketHeader	*p_phead,
		Drd64_Marshald_MasterInformation	*p_marshald )
{
	int		i_result;
	int		i_err;
	int		i_socket;
	int		i_cmd_status;
	Drd64_Marshald_ConnectInfo	*p_cinfo_now;
	Drd64_Marshald_ConnectInfo	*p_cinfo_connect;

	DRD64_LOG_DEBUG("  [DEBUG]CMD: Detach (INet : Answer) Start");

	i_result	= DRD64_MARSHALD_DISPATCH_RESULT_COMPLETE;
	p_cinfo_now = Drd64_Marshald_CInfo_GetConnectInfo(
									p_phead->i_cid_client );
	assert( NULL != p_cinfo_now );

	i_cmd_status	= Drd64_Server_RecvStatus_GetCmdStatus( i_recv_id );

	if( DRD64_CMDSTATUS_DETACH_NORMAL == i_cmd_status )		{
	
		p_cinfo_connect	= p_cinfo_now->p_dest_cinfo_connection;
		assert( NULL != p_cinfo_connect );

		Drd64_Marshald_SendCmd_ConnectCount(
        			p_cinfo_connect, -1, i_recv_id );
		
		Drd64_Server_RecvStatus_SetCmdStatus( i_recv_id,
                        DRD64_CMDSTATUS_DETACH_WAITDISCONNECT );

		i_result	= DRD64_MARSHALD_DISPATCH_RESULT_POLL;

		DRD64_LOG_DEBUG("  [DEBUG]CMD: Detach (INet : Answer) Polling(Waiting INet-DisConnect)");
	}
	else if( DRD64_CMDSTATUS_DETACH_WAITDISCONNECT == i_cmd_status )	{
		i_socket		= p_cinfo_now->i_client_socket;

		Drd64_Marshald_Cinfo_FreeConnectInfo( p_cinfo_now );
		p_cinfo_now		= NULL;

		p_phead->w_packettype	^= DRD64_PACKETTYPE_FLAG_TRANSPORT;
		p_phead->i_cid_dest		= p_phead->i_cid_client;
		p_phead->i_cid_client	= DRD64_CONNECTID_NONE;
	
		i_err  = send( i_socket, (void *)p_phead,
                        DRD64_PacketSize(p_phead), 0x00 );
		DRD64_DEBUG_PRINT("send",i_err,"FD",i_socket,"errno",errno);
		if( i_err != DRD64_PacketSize(p_phead) )   { return 0x02; }

		Drd64_Server_RecvStatus_SetCmdStatus( i_recv_id,
                        	DRD64_CMDSTATUS_DETACH_NORMAL );


		DRD64_LOG_DEBUG("  [DEBUG]CMD: Detach (INet : Answer) Ended");
	}
	else	{
		DRD64_LOG_DEBUG("  [DEBUG]CMD: Detach (INet : Answer) Error");
	}

	return i_result;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
int
	Drd64_Marshald_Cmd_Detach_Scn3_LocalAnswer(
		int		i_recv_id,
		Drd64_PacketHeader	*p_phead,
		Drd64_Marshald_MasterInformation	*p_marshald )
{
	int		i_result;
	int		i_err;
	int		i_socket;
	Drd64_Marshald_ConnectInfo	*p_cinfo_now;
	Drd64_Marshald_ConnectInfo	*p_cinfo_connect;

	DRD64_LOG_DEBUG("  [DEBUG]CMD: Detach (Local : Answer) Start");

	i_result	= DRD64_MARSHALD_DISPATCH_RESULT_COMPLETE;

	p_cinfo_now = Drd64_Marshald_CInfo_GetConnectInfo( p_phead->i_cid_src );
	assert( NULL != p_cinfo_now );

	i_socket	= p_cinfo_now->i_src_socket;
	Drd64_Marshald_Dispatch_CloseSocket( p_cinfo_now->i_dest_socket );

	Drd64_Marshald_Cinfo_FreeConnectInfo( p_cinfo_now );
	p_cinfo_now		= NULL;

	p_phead->w_packettype   ^= DRD64_PACKETTYPE_OPTION_INDICATE;
	p_phead->i_cid_dest     = p_phead->i_cid_src;
	p_phead->i_cid_src      = DRD64_CONNECTID_NONE;

	i_err  = send( i_socket, (void *)p_phead,
                        DRD64_PacketSize(p_phead), 0x00 );
	DRD64_DEBUG_PRINT("send",i_err,"FD",i_socket,"errno",errno);
	if( i_err != DRD64_PacketSize(p_phead) )   { return 0x02; }

	DRD64_LOG_DEBUG("  [DEBUG]CMD: Detach (Local : Answer) Ended");

	return i_result;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
int
	Drd64_Marshald_Cmd_Detach_Scn2_INetRequest(
		int		i_recv_id,
		Drd64_PacketHeader	*p_phead,
		Drd64_Marshald_MasterInformation	*p_marshald )
{
	int		i_result;
	int		i_err;
	Drd64_Marshald_ConnectInfo	*p_cinfo;

	DRD64_LOG_DEBUG("  [DEBUG]CMD: Detach (INet : Request) Start");

	i_result	= DRD64_MARSHALD_DISPATCH_RESULT_COMPLETE;

	p_cinfo = Drd64_Marshald_CInfo_GetConnectInfo( p_phead->i_cid_dest );
	assert( NULL != p_cinfo );

	p_phead->w_packettype   |= DRD64_PACKETTYPE_FLAG_TRANSPORT;
	p_phead->i_cid_client   = p_phead->i_cid_dest;
	p_phead->i_cid_dest     = p_cinfo->i_dest_cinfo_id;
	//p_phead->i_cid_src      = p_cinfo->i_cinfo_id;

	i_err  = send( p_cinfo->i_dest_socket, (void *)p_phead,
                        DRD64_PacketSize(p_phead), 0x00 );
	DRD64_DEBUG_PRINT("send",i_err,"FD",p_cinfo->i_dest_socket,"errno",errno);
	if( i_err != DRD64_PacketSize(p_phead) )   { return i_result; }

	DRD64_LOG_DEBUG("  [DEBUG]CMD: Detach (INet : Request) Ended");

	return i_result;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
int
	Drd64_Marshald_Cmd_Detach_Scn1_LocalRequest(
		int		i_recv_id,
		Drd64_PacketHeader	*p_phead,
		Drd64_Marshald_MasterInformation	*p_marshald )
{
	int		i_result;
	int		i_err;
	Drd64_Marshald_ConnectInfo	*p_cinfo;

	DRD64_LOG_DEBUG("  [DEBUG]CMD: Detach (Local : Request) Start");

	i_result	= DRD64_MARSHALD_DISPATCH_RESULT_COMPLETE;

	p_cinfo = Drd64_Marshald_CInfo_GetConnectInfo( p_phead->i_cid_dest );
	assert( NULL != p_cinfo );

	p_phead->w_packettype   |= DRD64_PACKETTYPE_OPTION_INDICATE;
	p_phead->i_cid_src      = p_phead->i_cid_dest;
	p_phead->i_cid_dest     = p_cinfo->i_dest_cinfo_id;
								/* = DRD64_CONNECTID_NONE */

	i_err  = send( p_cinfo->i_dest_socket, (void *)p_phead,
                        DRD64_PacketSize(p_phead), 0x00 );
	DRD64_DEBUG_PRINT("send",i_err,"FD",p_cinfo->i_dest_socket,"errno",errno);
	if( i_err != DRD64_PacketSize(p_phead) )   { return i_result; }

	DRD64_LOG_DEBUG("  [DEBUG]CMD: Detach (Local : Request) Ended");

	return i_result;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
int
	Drd64_Marshald_Cmd_Detach(
		int		i_recv_id,
		Drd64_PacketHeader	*p_phead,
		Drd64_PacketData_AttachReport		*p_areport,
		Drd64_Marshald_MasterInformation	*p_marshald )
{
	int		i_result;
	Drd64_Marshald_ConnectInfo		*p_cinfo;

	DRD64_LOG_VERBOSE("[STAT]CMD: Detach Start");

	i_result	= DRD64_MARSHALD_DISPATCH_RESULT_COMPLETE;

	if( DRD64_IsPacketType_Answer( p_phead ) )	{
		/* Scnery 3: (Local)Detach Answer from local-debugd */
		if( DRD64_CONNECTID_NONE == p_phead->i_cid_dest )	{
			i_result = Drd64_Marshald_Cmd_Detach_Scn3_LocalAnswer(
							i_recv_id, p_phead, p_marshald );
		}
		/* Scnery 4: (INet)Detach Answer from INet Marshald */
		else	{
			i_result = Drd64_Marshald_Cmd_Detach_Scn4_INetAnswer(
							i_recv_id, p_phead, p_marshald );
		}
	}
	else	{
		p_cinfo = Drd64_Marshald_CInfo_GetConnectInfo( p_phead->i_cid_dest );
		assert( NULL != p_cinfo );

		/* Scnery 1: (Local)Detach Packet for Local Debugd */
		if( DRD64_CONNECTID_NONE == p_cinfo->i_dest_cinfo_id )	{
			i_result = Drd64_Marshald_Cmd_Detach_Scn1_LocalRequest(
							i_recv_id, p_phead, p_marshald );
		}
		/* Scnery 2: (INet)Detach Packet for INet Marshald */
		else	{
			i_result = Drd64_Marshald_Cmd_Detach_Scn2_INetRequest(
							i_recv_id, p_phead, p_marshald );
		}
	}

	DRD64_LOG_VERBOSE("[STAT]CMD: Detach Ended");

	return i_result;
}


/* EOF of drd64_.c ----------------------------------- */
