/*DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64

                         D r . D e a m o n  6 4
                        for INTEL64(R), AMD64(R)
	
   Copyright(C) 2007-2009 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64*/

/* File Info -----------------------------------------------------------
File: drd64_marshald_dispatch.c
Function: Marshald Command Dispatcher (Main Loop Routine) 
Comment: 
----------------------------------------------------------------------*/

#include"drd64_marshald.h"

static	fd_set  g_fds_orig;


/* for EXTERNAL Function */
void
	Drd64_Marshald_Dispatch_SetFD(
		int	i_fds )
{
	FD_SET( i_fds, &g_fds_orig );
	return;
}


/* for EXTERNAL Function */
void
	Drd64_Marshald_Dispatch_CloseSocket(
		int	i_fds )
{
	Drd64_Server_RecvStatus	*p_recv;
	Drd64_Marshald_ConnectInfo	*p_cinfo;

	p_recv = Drd64_Server_RecvStatus_GetRecvStatus( i_fds );
	assert( NULL != p_recv );

	if( NULL != p_recv->pv_cinfo_connection )	{
		p_cinfo	= (Drd64_Marshald_ConnectInfo *)p_recv->pv_cinfo_connection;

		Drd64_Marshald_Cinfo_FreeConnectInfo( p_cinfo );
		p_recv->pv_cinfo_connection	= NULL;
		p_cinfo	= NULL;
		DRD64_LOG_DEBUG("  [DEBUG] Free ConnectionInfo with Close");
	}

	close( i_fds );
	FD_CLR( i_fds, &g_fds_orig );
	Drd64_Server_RecvStatus_DeleteSocketsChain( p_recv );
	Drd64_Server_RecvStatus_CloseRecvStatus( i_fds );
	DRD64_DEBUG_PRINT("CloseSocket",i_fds,"FD",i_fds,"errono",errno);

	return;
}


int
	Drd64_Marshald_Dispatch_OpenSocket(
		int	i_socket_server )
{
	int		i_socket_new;
	Drd64_Server_RecvStatus		*p_recv;

	i_socket_new    = accept( i_socket_server, NULL, NULL );
	DRD64_DEBUG_SYSCALL("accept(New Comm.)",i_socket_new,errno);

	if( -1 == i_socket_new )	{
		return -1;
	}

	FD_SET( i_socket_new, &g_fds_orig );

	p_recv = Drd64_Server_RecvStatus_AllocRecvStatus(
					i_socket_new, DRD64_MARSHALD_RECVSTATUS_UNITS );

	if( NULL == p_recv )	{
		return -2;
	}

	Drd64_Server_RecvStatus_InitRecvStatus( p_recv, i_socket_new );
	Drd64_Server_RecvStatus_AddSocketsChain( p_recv );

	return i_socket_new;
}


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
int
	Drd64_Marshald_Dispatch_ExecPacket(
		int		i_recv_id,
		Drd64_Server_RecvStatus	*p_recv,
        Drd64_Marshald_MasterInformation *p_marshald )
{
	int							i_result;
	Drd64_PacketHeader			*p_phead;
	Drd64_Server_RecvStatus		*p_recv_parent;
	void						*pv_data;

	/* Phase 1 : Init. ================================*/
	pv_data			= NULL;
	i_result	= DRD64_MARSHALD_DISPATCH_RESULT_CLOSE;		// XXX > error

	p_phead	= (Drd64_PacketHeader *)p_recv->pv_buf;
	assert( NULL != p_phead );

	if( 0 < p_phead->i_datalen )
		{ pv_data	= DRD64_PacketData( p_recv->pv_buf ); }


	/* Phase 2 : Exec. Command ========================*/
	/* CMD: Connect -----------------------------------*/
	if( DRD64_COMMAND_CONNECT == p_phead->dw_command )	{
		i_result = Drd64_Marshald_Cmd_Connect(
							i_recv_id, p_phead, pv_data );
	}
	/* CMD: Connect Count -----------------------------*/
	else if( DRD64_COMMAND_CONNECT_COUNT == p_phead->dw_command )	{
		i_result = Drd64_Marshald_Cmd_ConnectCount(
							i_recv_id, p_phead, pv_data );
	}
	/* CMD: DisConnect --------------------------------*/
	else if( DRD64_COMMAND_DISCONNECT == p_phead->dw_command )	{
		i_result = Drd64_Marshald_Cmd_DisConnect( i_recv_id, p_phead, pv_data );
	}
	/* CMD: Attach Request  ---------------------------*/
	else if( DRD64_COMMAND_ATTACH_REQUEST == p_phead->dw_command )	{
		i_result = Drd64_Marshald_Cmd_AttachRequest(
							i_recv_id, p_phead, pv_data, p_marshald );
	}
	/* CMD: Attach Link  ------------------------------*/
	else if( DRD64_COMMAND_ATTACH_LINK == p_phead->dw_command )	{
		i_result = Drd64_Marshald_Cmd_AttachLink(
							i_recv_id, p_phead, pv_data, p_marshald );
	}
	/* CMD: Attach Report -----------------------------*/
	else if( DRD64_COMMAND_ATTACH_REPORT == p_phead->dw_command )	{
		i_result = Drd64_Marshald_Cmd_AttachReport(
							i_recv_id, p_phead, pv_data, p_marshald );
	}
	else if( DRD64_COMMAND_DETACH == p_phead->dw_command )	{
		i_result = Drd64_Marshald_Cmd_Detach(
							i_recv_id, p_phead, pv_data, p_marshald );
	}
	else if( DRD64_COMMAND_EXIT == p_phead->dw_command )	{
	}
	else if( DRD64_COMMAND_DEBUGD_BOOTINFO == p_phead->dw_command )	{
		i_result = Drd64_Marshald_Msg_DebugdBootInfo(
							i_recv_id, p_phead, pv_data, p_marshald );
	}


	/* Phase 3 : Result Proc.  =======================*/
	if( DRD64_MARSHALD_DISPATCH_RESULT_RESTART == i_result )	{
		if( -1 < p_phead->i_rid_resume )	{
			p_recv_parent = Drd64_Server_RecvStatus_GetRecvStatus(
									p_phead->i_rid_resume );
			assert( NULL != p_recv_parent );

			p_recv_parent->b_recv_status
					= DRD64_SERVER_RECVSTATUS_STATUS_RESUME;
		}
	}
	else if( DRD64_MARSHALD_DISPATCH_RESULT_POLL == i_result )	{
		p_recv->b_recv_status	= DRD64_SERVER_RECVSTATUS_STATUS_STOP;
	}

	/* XXX > error */
	if(( DRD64_MARSHALD_DISPATCH_RESULT_COMPLETE == i_result )
			|| ( DRD64_MARSHALD_DISPATCH_RESULT_RESTART == i_result ))	{
		Drd64_Server_RecvStatus_DeleteResumeChain( i_recv_id );
	}

	return i_result;
}


int
	Drd64_Marshald_Dispatch_JudgePacket(
		int		i_fds,
		int		i_remainbytes,
		Drd64_Server_RecvStatus	*p_recv,
        Drd64_Marshald_MasterInformation *p_marshald )
{
	int		i_result;
	int		i_recv_id;
	Drd64_PacketHeader			*p_phead;
	Drd64_Server_RecvStatus		*p_recv_new;

	i_result		= 0x00;

	/* Judge 1: Receiving : Remain Bytes Receiving = 0x01 */
	if( 0 < i_remainbytes )
		{ return DRD64_MARSHALD_DISPATCH_RESULT_RECEVING; }
	/* Judge 2: Error: Connection Down or Close = 0x00 */
	else if( 0 > i_remainbytes )
		{ return DRD64_MARSHALD_DISPATCH_RESULT_CLOSE; }

	p_phead	= (Drd64_PacketHeader *)p_recv->pv_buf;
	assert( NULL != p_phead );

	/* Check 1 : Header Check */
	if( DRD64_PACKET_HEADER != p_phead->w_header )
		{ return DRD64_MARSHALD_DISPATCH_RESULT_CLOSE; }

	/* Judge 3: Remain Packet Data? = 0x01 */
	if(( DRD64_SERVER_RECVSTATUS_PHASE_HEADER == p_recv->i_read_phase ) &&
			( 0 < p_phead->i_datalen ))		{
		p_recv->i_read_phase	= DRD64_SERVER_RECVSTATUS_PHASE_DATA;

		/* Check BOF Attack */
		if( DRD64_MAX_PACKET_DATA < p_phead->i_datalen )
			{ return DRD64_MARSHALD_DISPATCH_RESULT_CLOSE; }
		p_recv->i_remain_bytes	= p_phead->i_datalen;
		
		return DRD64_MARSHALD_DISPATCH_RESULT_RECEVING;
	}

	/* Check 2: Standart Packet Header Check */
		/* XXX : NO implement */

	/* Check 4: Relay Debugd-Cmd Packet? */

	/* Push Readed Command Packet for Resume Pool */
	Drd64_Server_RecvStatus_DeleteSocketsChain( p_recv );
	i_recv_id	= Drd64_Server_RecvStatus_PushResumeChain(
						i_fds, DRD64_MARSHALD_RECVSTATUS_UNITS );
	if( 0 > i_recv_id )
		{ return DRD64_MARSHALD_DISPATCH_RESULT_CLOSE; }	// XXX > error

	p_recv_new	= Drd64_Server_RecvStatus_GetRecvStatus( i_fds );
	assert( NULL != p_recv_new );

	Drd64_Server_RecvStatus_InitRecvStatus( p_recv_new, p_recv->i_fds_id );
	Drd64_Server_RecvStatus_AddSocketsChain( p_recv_new );
	Drd64_Server_RecvStatus_SetConnectionInfoPointer(
                                    p_recv_new, p_recv->pv_cinfo_connection );
	
	/* Exec Packet by Command-Code */
	i_result = Drd64_Marshald_Dispatch_ExecPacket(
						i_recv_id, p_recv, p_marshald );

	return i_result;
}


int
	Drd64_Marshald_Dispatch_ExecResumeRecvStatus(
		Drd64_Marshald_MasterInformation *p_marshald )
{
	int							i_result;
	Drd64_Server_RecvStatus		*p_recv;

	DRD64_LOG_DEBUG("  [DEBUG] Dispatch : Exec Resume RecvStatus Start");

	p_recv	= Drd64_Server_RecvStatus_GetResumeChainStart();
	while( NULL != p_recv )	{
		if( DRD64_SERVER_RECVSTATUS_STATUS_RESUME
							== p_recv->b_recv_status )	{

			DRD64_LOG_DEBUG("    [DEBUG] Dispatch : Do Resume RecvStatus");
 			i_result = Drd64_Marshald_Dispatch_ExecPacket(
							p_recv->i_recvstatus_id, p_recv, p_marshald );

			/* XXX : support for disconnect (CLOSE) */
			/* 0x00 = Judge 1 : Disconnect ( Others Packet ) */
			if( DRD64_MARSHALD_DISPATCH_RESULT_CLOSE == i_result )	{
				Drd64_Marshald_Dispatch_CloseSocket( p_recv->i_fds_id );
			}
			else if( DRD64_MARSHALD_DISPATCH_RESULT_RESTART == i_result )	{
				p_recv	= NULL;
			}
		}
					
		if( NULL != p_recv )	{
			p_recv = (Drd64_Server_RecvStatus *)p_recv->pv_recv_next;
		}
		else	{
			p_recv	= Drd64_Server_RecvStatus_GetResumeChainStart();
		}
	}

	DRD64_LOG_DEBUG("  [DEBUG] Dispatch : Exec Resume RecvStatus Ended");

	return 0x00;
}

int
    Drd64_Marshald_Dispatch_Polling(
        Drd64_Marshald_MasterInformation *p_marshald )
{
	fd_set  fds_now;
	//int     i_cnt;
	int		i_socket;
	int		i_result;
	int		i_err;
	int		i_pid;
	int		i_selects;
	int		i_resume_flag;
	int		i_selects_base;
	int     i_selects_max;
	int		i_selects_last;
	Drd64_Server_RecvStatus		*p_recv;
	struct	timeval				tmval;

	FD_ZERO( &g_fds_orig );
	FD_SET( p_marshald->i_socket_local, &g_fds_orig );
	FD_SET( p_marshald->i_socket_inet, &g_fds_orig );

	if( p_marshald->i_socket_local > p_marshald->i_socket_inet )
		{ i_selects_base	= p_marshald->i_socket_local + 1; }
	else
		{ i_selects_base	= p_marshald->i_socket_inet + 1; }
	i_selects_max = i_selects_base;

	tmval.tv_sec	= 0;
	tmval.tv_usec	= 5000;

	while( 1 )  {
		/* Phase 1: Packet & Signal Polling */
		memcpy( &fds_now, &g_fds_orig, sizeof( struct fd_set ) );
		i_selects = select( i_selects_max, &fds_now, NULL, NULL, &tmval );
	
		/* Phase 2: Receive Packet */
		if( 0 < i_selects )		{

			/* Server Socket from Local */
			if( FD_ISSET( p_marshald->i_socket_local, &fds_now )) 	{
				Drd64_Marshald_Dispatch_OpenSocket(
								p_marshald->i_socket_local );
				i_selects--;
			}

			/* Server Socket from INet */
			if( FD_ISSET( p_marshald->i_socket_inet, &fds_now )) 	{
				Drd64_Marshald_Dispatch_OpenSocket(
								p_marshald->i_socket_inet );
				i_selects--;
			}

			i_resume_flag	= 0x00;	
			p_recv	= Drd64_Server_RecvStatus_GetSocketsChainStart();
			while(( NULL != p_recv ) && ( 0 < i_selects ))	{

				i_socket	= p_recv->i_fds_id;

				if( FD_ISSET( i_socket, &fds_now ) )	{
					/* Read */
					assert( DRD64_SERVER_RECVSTATUS_STATUS_READ
										== p_recv->b_recv_status );
		
					/*i_err = Drd64_Server_RecvSocket_SocketRead_Cert(
									i_socket, &i_pid );*/
					i_err = Drd64_Server_RecvSocket_SocketRead( i_socket );
					DRD64_DEBUG_PRINT("SocketRead",i_err,"FD",i_socket,"DestPid",i_pid);
					i_selects--;

					/* Judge Packet */
					i_result = Drd64_Marshald_Dispatch_JudgePacket(
								i_socket, i_err, p_recv, &drd64_marshald_info );

					/* 0x00 = Judge 1 : Disconnect ( Others Packet ) */
					if( DRD64_MARSHALD_DISPATCH_RESULT_CLOSE == i_result )	{
							Drd64_Marshald_Dispatch_CloseSocket( i_socket );
					}
					else if( DRD64_MARSHALD_DISPATCH_RESULT_RESTART
															== i_result )
						{ i_resume_flag	= 0x01; }
					/* 0x01 = Judge 1 : Reading Next */

				}

				p_recv	= (Drd64_Server_RecvStatus *)p_recv->pv_recv_next;
			}

			/* Check Restart Packet (RecvStatus) */
			if( 0x00 != i_resume_flag )		{
				Drd64_Marshald_Dispatch_ExecResumeRecvStatus(
										&drd64_marshald_info );
			}

			/* Set Max fd */
			i_selects_last	= Drd64_Server_RecvStatus_GetRecvStatMax();
			if( i_selects_last > i_selects_base )
				{ i_selects_max	= i_selects_last; }
			else
				{ i_selects_max = i_selects_base; }
		}

		/* Phase 3: Check TimeOut Resume Packet */

		/* Phase 4: Signal Check & Proc */
	}
	
	return 0x00;
}


/* EOF of drd64_.c ----------------------------------- */
