/*DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64

                         D r . D e a m o n  6 4
                        for INTEL64(R), AMD64(R)
	
   Copyright(C) 2007-2009 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64*/

/* File Info -----------------------------------------------------------
File: drd64_.c
Function: 
Comment: 
----------------------------------------------------------------------*/

#define	DRD64_SRC_MARSHALD_MAIN
#include"drd64_marshald.h"



void Drd64_Marshald_SigTerm( siginfo_t *info, ucontext_t *uap)
{
	close( drd64_marshald_info.i_socket_inet );
	close( drd64_marshald_info.i_socket_local );

	Drd64_LibBrownie_Error_TermErrorSystem();

	DRD64_LOG_INFO("[INFO] Terminate drmarshald. Good-Bye.");
	Drd64_Server_Log_TermLogSystem();
	exit( 0x00 );
}


void Drd64_Marshald_SigHup( siginfo_t *info, ucontext_t *uap)
{
	exit( 0x00 );
}



/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
int	
	Drd64_Marshald_Init(
		Drd64_Marshald_MasterInformation *p_marshald )
{
	int		i_err;

	Drd64_Server_Log_InitLogSystem(
        			DRD64_LOG_MODULE_MARSHALD,
        			DRD64_LOG_LEVEL_MARSHALD,
        			DRD64_LOG_FACILITY_MARSHALD );

	DRD64_LOG_INFO("*********************************************");
	DRD64_LOG_INFO("drd64_marshald : Dr.Deamon64 Marshaler Deamon");
	DRD64_LOG_INFO("Copyright(C) 2007- Koine Yuusuke(koinec). All rights reserved.");
	DRD64_LOG_INFO("[Arch]: INTEL64(amd64/x86-64) / FreeBSD");
	DRD64_LOG_INFO("[INFO] Booting drmarshald ...");

	/* */
	i_err = Drd64_LibBrownie_Error_InitErrorSystem(
				DRD64_ERRORINFO_HISTORY_MARSHALD );
	if( 0x00 != i_err )		{ return 0x04; }

	/* */
	Drd64_Server_Common_Signal( SIGINT, Drd64_Marshald_SigTerm );
	Drd64_Server_Common_Signal( SIGTERM, Drd64_Marshald_SigTerm );
	Drd64_Server_Common_Signal( SIGHUP, Drd64_Marshald_SigHup );

	/* */
	i_err	= Drd64_Server_RecvStatus_Init( DRD64_MARSHALD_RECVSTATUS_UNITS );
	if( 0x00 != i_err )		{ return i_err; }
	
	/* */
	Drd64_Server_RecvSocket_InitReadBuffer();

	/* */
	i_err	= Drd64_Marshald_CInfo_InitConnectInfo();
	if( 0x00 != i_err )		{ return i_err; }

	/* */
	p_marshald->i_socket_local
		= Drd64_LibBrownie_Socket_InitSocketServer_Local(
					DRD64_SOCKET_LOCAL_NAME_MARSHALD );
	if( 0 > p_marshald->i_socket_local )	{ return 0x01; }
	DRD64_DEBUG_PRINT("Socket(Local)",p_marshald->i_socket_local,
												"errno",errno,NULL,0);

	/* */
	p_marshald->i_socket_inet =
		Drd64_LibBrownie_Socket_InitSocketServer_INet(
					"INADDR_ANY", DRD64_SOCKET_NETWORK_PORT );
	if( 0 > p_marshald->i_socket_inet )	{ return 0x01; }
	DRD64_DEBUG_PRINT("Socket(INet)",p_marshald->i_socket_inet,
												"errno",errno,NULL,0);

	/* */
	i_err	= Drd64_LibBrownie_INetAddr_SetInAddr_LocalHost(
								&(p_marshald->t_marshald_addr) );
	if( 0x00 != i_err )		{ return 0x02; }

	strncpy( p_marshald->str_path_debugd,
				DRD64_INSTALLPATH_DEBUGD, DRD64_MAX_PATH );
	strncat( p_marshald->str_path_debugd,
				DRD64_MODULENAME_DEBUGD, DRD64_MAX_PATH );

	/* */
	gp_sendbuffer	= (Byte *)malloc( DRD64_MAX_PACKET_LENGTH );
	if( NULL == gp_sendbuffer )		{ return 0x03; }


	return 0x00;
}


void
	Drd64_Marshald_Main_Usage(
		void )
{
	puts("drd64_marshald : Dr.Deamon64 Marshaler Deamon");
	puts("[Arch: INTEL64(amd64/x86-64) / FreeBSD]");
	puts("Copyright(C) 2007-2009 Koine Yuusuke(koinec). All rights reserved.");
	
	return;
}



int main(
	int argc,
	char *argv[] )
{
	int		i_err;

	memset( &drd64_marshald_info, 0x00,
				sizeof( Drd64_Marshald_MasterInformation ) );
	
	/* reserve: Analyze Option */

	//Drd64_Server_Common_Deamonize();	
	//DRD64_LOG_VERBOSE("[STAT] Completed Deamonize ");

	i_err	= Drd64_Marshald_Init( &drd64_marshald_info );
	if( 0x00 != i_err )		{
		return 0x01;
	}
	DRD64_LOG_VERBOSE("[STAT] Completed drmarshald System Init. ");

	Drd64_Marshald_Dispatch_Polling( &drd64_marshald_info );

	close( drd64_marshald_info.i_socket_inet );
	close( drd64_marshald_info.i_socket_local );

	return 0x00;
}


/* EOF of drd64_.c ----------------------------------- */
