/*DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64

                         D r . D e a m o n  6 4
                        for INTEL64(R), AMD64(R)
	
   Copyright(C) 2007-2009 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64*/

/* File Info -----------------------------------------------------------
File: drd64_.c
Function: 
Comment: 
----------------------------------------------------------------------*/

#define	DRD64_SRCID_MARSHALD_SEND_CONNECT	0x0000
#include"drd64_marshald.h"


/*----------------------------------------------------------------------
----------------------------------------------------------------------*/
#define	DRD64_FUNCID_Marshald_SendCmd_Connect	0x01
int	
	Drd64_Marshald_SendCmd_Connect(
		Drd64_Marshald_ConnectInfo **pp_cinfo,
		struct	in_addr	*p_addr_dest,
		int		i_recv_id )
{
	int							i_err;
	int							i_wlen;
	int							i_socket_inet;
	DWord						dw_errcode;
	DWord						dw_location;
	Drd64_PacketHeader			*p_phead;
	Drd64_PacketData_Connect	*p_connect;
	Drd64_Marshald_ConnectInfo	*p_cinfo;
	Drd64_Server_RecvStatus		*p_recv;

	DRD64_LOG_DEBUG("  [DEBUG]SEND: Connect Cmd (for INet-Marshald) Start");

	dw_errcode  = DRD64_ERROR_CODE_CLEAR;
	dw_location = DRD64_ERROR_SET_LOCATION(
						DRD64_ERROR_MODULE_MARSHALD,
						DRD64_ERROR_ARCH_NODEPEND,
						DRD64_SRCID_MARSHALD_SEND_CONNECT,
						DRD64_FUNCID_Marshald_SendCmd_Connect );
	*pp_cinfo	= NULL;


	/* Alloc CInfo ----*/
	p_cinfo	= Drd64_Marshald_CInfo_AllocConnectInfo();
	if( NULL == p_cinfo )	{
		dw_errcode  = DRD64_ERROR_SET_CODE( DRD64_ERROR_TYPE_ERROR,
							DRD64_ERROR_PTN_NOMEMORY, 0x00, 0x01 );
		Drd64_LibBrownie_Error_SetErrorInfo(
				dw_errcode, dw_location, errno );

		return -0x01;
	}


	/* Set Packet Header ---*/
	p_phead	= (Drd64_PacketHeader *)gp_sendbuffer;
	memset( gp_sendbuffer, 0x00, ( sizeof( Drd64_PacketHeader )
								+ sizeof( Drd64_PacketData_Connect ) ));

	p_phead->w_header		= DRD64_PACKET_HEADER;
	p_phead->i_cid_dest		= DRD64_CONNECTID_NONE;
	p_phead->i_cid_src		= DRD64_CONNECTID_NONE;
	p_phead->dw_command		= DRD64_COMMAND_CONNECT;
	p_phead->w_packettype	= DRD64_PACKETTYPE_LINK;
	p_phead->i_datalen		= sizeof( Drd64_PacketData_Connect );
	p_phead->i_rid_resume	= i_recv_id;
	p_phead->dw_errcode     = DRD64_ERROR_CODE_CLEAR;
	p_phead->dw_errlocation = DRD64_ERROR_LOCATION_CLEAR;


	p_connect
		= (Drd64_PacketData_Connect *)DRD64_PacketData( gp_sendbuffer );

	p_connect->i_client_pid			= getpid();
	p_connect->i_client_cinfo_id	= p_cinfo->i_cinfo_id;
	p_connect->i_connect_id			= -1;
	i_err	= Drd64_LibBrownie_INetAddr_SetInAddr_LocalHost(
								&(p_connect->t_client_addr_inet) );
	if( 0x00 != i_err )		{
		dw_errcode  = DRD64_ERROR_SET_CODE( DRD64_ERROR_TYPE_ERROR,
							DRD64_ERROR_PTN_INETADDR, 0x00, 0x02 );
		Drd64_LibBrownie_Error_SetErrorInfo(
				dw_errcode, dw_location, errno );

		Drd64_Marshald_Cinfo_FreeConnectInfo( p_cinfo );
		return -0x02;
	}


	/* Create INet-Marshald Socket ------*/
	i_socket_inet	=
		Drd64_LibBrownie_Socket_InitSocketClient_INet(
						p_addr_dest, DRD64_SOCKET_NETWORK_PORT ); 
	if( 0 > i_socket_inet )		{
		dw_errcode  = DRD64_ERROR_SET_CODE( DRD64_ERROR_TYPE_ERROR,
							DRD64_ERROR_PTN_SOCKET, 0x00, 0x03 );
		Drd64_LibBrownie_Error_SetErrorInfo(
				dw_errcode, dw_location, errno );

		Drd64_Marshald_Cinfo_FreeConnectInfo( p_cinfo );

		return -0x03;
	}


	/* Init. RecvStatus for INet-Socket ---- */
	p_recv = Drd64_Server_RecvStatus_AllocRecvStatus(
					i_socket_inet, DRD64_MARSHALD_RECVSTATUS_UNITS );
	if( NULL == p_recv )	{
		dw_errcode  = DRD64_ERROR_SET_CODE( DRD64_ERROR_TYPE_ERROR,
							DRD64_ERROR_PTN_NOMEMORY, 0x00, 0x04 );
		Drd64_LibBrownie_Error_SetErrorInfo(
				dw_errcode, dw_location, errno );

		Drd64_Marshald_Cinfo_FreeConnectInfo( p_cinfo );
		return -0x04;
	}

	//Drd64_Marshald_Dispatch_SetFD( i_socket_inet );
	Drd64_Server_RecvStatus_InitRecvStatus( p_recv, i_socket_inet );
	Drd64_Server_RecvStatus_AddSocketsChain( p_recv );
	/* Error Proc. is NONE. => Error Pattern is p_recv = NULL only */
	Drd64_Server_RecvStatus_SetConnectionInfoPointer(
								p_recv, (void *)p_cinfo );
	Drd64_Marshald_Dispatch_SetFD( i_socket_inet );


	/* Phase 4 : Send Packet to INet Marshald -----*/
	i_wlen	= send( i_socket_inet, (void *)p_phead,
								DRD64_PacketSize(p_phead), 0x00 );
	DRD64_DEBUG_PRINT("send",i_wlen,"FD",i_socket_inet,"errno",errno);
	if( i_wlen != DRD64_PacketSize(p_phead) )	{
		dw_errcode  = DRD64_ERROR_SET_CODE( DRD64_ERROR_TYPE_ERROR,
							DRD64_ERROR_PTN_SOCKET, 0x00, 0x05 );
		Drd64_LibBrownie_Error_SetErrorInfo(
				dw_errcode, dw_location, errno );

		Drd64_Marshald_Dispatch_CloseSocket( p_recv );
		Drd64_Marshald_Cinfo_FreeConnectInfo( p_cinfo );

		return -0x05;
	} 

	/* Phase 5 : Set Cinfo Data ------------------*/
	p_cinfo->b_cinfo_type			= DRD64_MARSHALD_CINFOTYPE_CLIENT;
	p_cinfo->i_cinfo_refcount		= 1;

	Drd64_LibBrownie_INetAddr_CopyInAddr(
						&(p_cinfo->t_dest_addr_inet),
						p_addr_dest );
	/* p_cinfo->i_dest_cinfo_id		= p_connect->i_connect_id; 
					(Set i_dest_cinfo_id when Connect-recv.) */
	p_cinfo->str_dest_addr_local[0]	= '\0';
	p_cinfo->i_dest_socket			= i_socket_inet;

	/* p_cinfo->t_src_addr_inet		= NONE */
	p_cinfo->i_src_cinfo_id			= -1;
	p_cinfo->i_src_socket			= -1;

	/* t_prog_addr_inet 			= NONE */
	p_cinfo->i_prog_pid				= -1;

	p_cinfo->i_debugd_pid			= -1;
	p_cinfo->i_debugd_socket		= -1;

	i_err	= Drd64_LibBrownie_INetAddr_SetInAddr_LocalHost(
								&(p_cinfo->t_client_addr_inet) );
	if( 0x00 != i_err )		{
		dw_errcode  = DRD64_ERROR_SET_CODE( DRD64_ERROR_TYPE_ERROR,
							DRD64_ERROR_PTN_INETADDR, 0x00, 0x06 );
		Drd64_LibBrownie_Error_SetErrorInfo(
				dw_errcode, dw_location, errno );

		Drd64_Marshald_Dispatch_CloseSocket( p_recv );
		Drd64_Marshald_Cinfo_FreeConnectInfo( p_cinfo );

		return -0x06;
	}

	p_cinfo->i_client_socket		= i_socket_inet;
	p_cinfo->i_client_pid			= getpid();

	*pp_cinfo	= p_cinfo;

	DRD64_LOG_DEBUG("  [DEBUG]SEND: Connect Cmd (for INet-Marshald) Ended");

	return 0x00;
}



/* EOF of drd64_.c ----------------------------------- */
