/*DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64

                         D r . D e a m o n  6 4
                        for INTEL64(R), AMD64(R)
	
   Copyright(C) 2007-2009 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64*/

/* File Info -----------------------------------------------------------
File: drd64_.c
Function: 
Comment: 
----------------------------------------------------------------------*/

#include"drd64_server.h"


int
	Drd64_Server_Common_Signal(
		int	i_signal, 
		void (*func_sigaction) )
{
	int		i_err;
	struct	sigaction	t_act;

	t_act.sa_handler	= func_sigaction;
	sigemptyset( &t_act.sa_mask );
	t_act.sa_flags	= SA_SIGINFO;
	
	i_err	= sigaction( i_signal, &t_act, NULL );
	
	return i_err;
}


int
	Drd64_Server_Common_Deamonize(
		void)
{
	int		i_err;
	int		i_fdlimit;
	pid_t	t_err;

	/* Create Deamon Process */
	t_err	= fork();

	/* Error fork() SystemCall */
	if( -1 == t_err )	{
		return 0x01;
	}
	/* Proc. Parent Process => Exit. */
	else if( 0 != t_err )	{
		_exit( 0x00 );
	}
	/* VVVVV Proc. Temp Child Process VVVVV */
	

	/* Create Process Session & Process Group */
	t_err	= setsid();
	if( -1 == t_err )	{
		return 0x02;
	}


	/* Create Deamon Process */
	t_err	= fork();
	if( -1 == t_err )	{
		/* Error fork() SystemCall */
		return 0x03;
	}
	else if( 0 != t_err )	{
		/* Proc. Child Process */
		_exit( 0x00 );
	}


	/* VVVVV Proc. Deamon Process VVVVV */
	
	/* Change Current Directory for Deamon Process */
	i_err	= chdir( "/" );
	if( -1 == i_err )	{
		return 0x04;
	}
		
	/* Close Std. I/O */
	i_fdlimit	= sysconf( _SC_OPEN_MAX );
	while( --i_fdlimit >= 0 )
		{ close( i_fdlimit ); }

	
	return 0x00;
}


/* EOF of drd64_.c ----------------------------------- */
