/*DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64

                         D r . D e a m o n  6 4
                        for INTEL64(R), AMD64(R)
	
   Copyright(C) 2007-2009 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64*/

/* File Info -----------------------------------------------------------
File: drd64_.c
Function: 
Comment: 
----------------------------------------------------------------------*/

#include"drd64_server.h"
#include"drd64_server_recvstatus.h"


typedef struct	{
	struct	cmsghdr		t_hdr;
	struct	cmsgcred	t_cred;
} Drd64_Server_RecvCMsg;

Drd64_Server_RecvCMsg	gt_recvmsg_cmsg;
struct	msghdr	gt_recvmsg_msghdr;
struct	iovec	gt_recvmsg_iovec;


void
	Drd64_Server_RecvSocket_InitReadBuffer(
		void )
{
	int		i_len_cmsg;

	i_len_cmsg	= sizeof( struct cmsghdr ) + sizeof( struct cmsgcred );

	memset( &gt_recvmsg_msghdr, 0x00, sizeof( struct msghdr ));
	memset( &gt_recvmsg_cmsg, 0x00, i_len_cmsg );

	gt_recvmsg_msghdr.msg_name			= NULL;
	gt_recvmsg_msghdr.msg_namelen		= 0;
	gt_recvmsg_msghdr.msg_iov			= &gt_recvmsg_iovec;
	gt_recvmsg_msghdr.msg_iovlen		= 1;
	gt_recvmsg_msghdr.msg_control		= (caddr_t)&gt_recvmsg_cmsg;
	gt_recvmsg_msghdr.msg_controllen	= i_len_cmsg;

	return;
}


int
	Drd64_Server_RecvSocket_SocketRead_Cert(
		int	i_fds,
		int	*pi_pid )
{
	int		i_reads;
	struct	cmsgcred	*p_cmsgcred;
	Drd64_Server_RecvStatus *p_recv;

	p_recv	= Drd64_Server_RecvStatus_GetRecvStatus( i_fds );

	if( NULL == p_recv )	{ return -1; }

	memset( &gt_recvmsg_cmsg, 0x00, sizeof( Drd64_Server_RecvCMsg ));
	gt_recvmsg_msghdr.msg_controllen	= sizeof( Drd64_Server_RecvCMsg );

	gt_recvmsg_iovec.iov_base	= p_recv->pv_resume;
	gt_recvmsg_iovec.iov_len	= p_recv->i_remain_bytes;

	i_reads	= recvmsg( i_fds, &gt_recvmsg_msghdr, 0x00 );
	
	if( -1 == i_reads )		{ return -2; }
	else if( 0 == i_reads ) { return -3; }

	p_cmsgcred	= (struct cmsgcred *)CMSG_DATA( &gt_recvmsg_cmsg );

	*pi_pid	= p_cmsgcred->cmcred_pid;

	p_recv->i_remain_bytes	-= i_reads;
	p_recv->pv_resume		+= i_reads;
	
	return p_recv->i_remain_bytes;
}


int
	Drd64_Server_RecvSocket_SocketRead(
		int	i_fds )
{
	int		i_reads;
	Drd64_Server_RecvStatus *p_recv;

	p_recv	= Drd64_Server_RecvStatus_GetRecvStatus( i_fds );

	if( NULL == p_recv )	{ return -1; }

	i_reads = recv( p_recv->i_fds_id, p_recv->pv_resume,
							p_recv->i_remain_bytes, 0x00 );
	if( -1 == i_reads )		{ return -2; }
	else if( 0 == i_reads )	{ return -3; }

	p_recv->i_remain_bytes	-= i_reads;
	p_recv->pv_resume		+= i_reads;
	
	return p_recv->i_remain_bytes;
}


/* EOF of drd64_.c ----------------------------------- */
