/*DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64

                         D r . D e a m o n  6 4
                        for INTEL64(R), AMD64(R)
	
   Copyright(C) 2007-2009 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64*/

/* File Info -----------------------------------------------------------
File: drd64_.c
Function: 
Comment: 
----------------------------------------------------------------------*/

#include"drd64_server.h"
#define	DRD64_SRC_SERVER_RECVSTATUS
#include"drd64_server_recvstatus.h"

Drd64_Server_RecvStatus		**gpp_recvstat;
Drd64_Server_RecvStatus		*gp_recvalloc;
int							gi_recvalloc_max;
int							gi_recvalloc_now;
int							gi_recvstat_max;
Drd64_Server_RecvStatus		*gp_recv_resume_start;
Drd64_Server_RecvStatus		*gp_recv_resume_end;
int							gi_recv_resume_max;
Drd64_Server_RecvStatus		*gp_recv_sockets_start;
Drd64_Server_RecvStatus		*gp_recv_sockets_end;


int
	Drd64_Server_RecvStatus_FreeRecvStatus_All(
		void )
{
	int		i_cnt;

	for( i_cnt = 0; i_cnt < gi_recvalloc_max; i_cnt++ )	{
			free( (gp_recvalloc + i_cnt)->pv_buf );
			(gp_recvalloc + i_cnt)->pv_buf	= NULL;
	}

	free( gp_recvalloc );
	gi_recvalloc_max	= 0;
	gi_recvalloc_now	= 0;
	gp_recvalloc		= NULL;

	free( gpp_recvstat );
	gpp_recvstat		= NULL;

	return 0x00;
}


Drd64_Server_RecvStatus *
	Drd64_Server_RecvStatus_AllocRecvStatus_Unit(
		int		i_alloc_units )
{
	int		i_cnt;
	int		i_init_start_id;
	int		i_init_end_id;
	void	*pv_temp;
	Drd64_Server_RecvStatus		*p_recvs;

	p_recvs	= NULL;

	if( 0 == gi_recvalloc_max )	{
		p_recvs = (Drd64_Server_RecvStatus *)malloc(
						sizeof( Drd64_Server_RecvStatus )
							* i_alloc_units );

		i_init_start_id		= 0;
		i_init_end_id		= i_alloc_units;
	}
	else	{
		p_recvs	= realloc( gp_recvalloc,
					gi_recvalloc_max + i_alloc_units );

		i_init_start_id		= gi_recvalloc_max;
		i_init_end_id		= gi_recvalloc_max + i_alloc_units;
	}
	
	if( NULL == p_recvs )	{
		return NULL;
	}


	for( i_cnt = i_init_start_id; i_cnt < i_init_end_id; i_cnt++ )	{
		memset( (p_recvs + i_cnt), 0x00, 
					sizeof( Drd64_Server_RecvStatus ) );
		(p_recvs + i_cnt)->i_recvstatus_id	= -1;
		(p_recvs + i_cnt)->i_fds_id			= -1;

		pv_temp	= malloc( DRD64_MAX_PACKET_LENGTH );
		if( NULL == pv_temp )	{ break; }
		(p_recvs + i_cnt)->pv_buf		= pv_temp;
		gi_recvalloc_max++;
	}

	if( gi_recvalloc_max == i_init_start_id )	{
		return NULL;
	}

	gp_recvalloc	= p_recvs;
	return p_recvs;
}


EXTERN_SERVER_RECVSTATUS
int
	Drd64_Server_RecvStatus_Init(
		int i_alloc_units )
{
	Drd64_Server_RecvStatus *p_recvs;

	/* Alloc RecvStatus Struct Management Area --- */
	gpp_recvstat
		= (Drd64_Server_RecvStatus **)malloc(
					sizeof( Drd64_Server_RecvStatus *)
						* FD_SETSIZE * DRD64_PACKET_MAX_MULTIPLE);
	if( NULL == gpp_recvstat )	{ return 0x01; }

	memset( gpp_recvstat, 0x00, 
					sizeof( Drd64_Server_RecvStatus *)
						* FD_SETSIZE * DRD64_PACKET_MAX_MULTIPLE );

	gi_recvstat_max	= 0;
	
	/* Alloc RecvStatus Area ( with Packet Data buffer ) ---*/
	p_recvs = Drd64_Server_RecvStatus_AllocRecvStatus_Unit( i_alloc_units );
	if( NULL == p_recvs )	{
		Drd64_Server_RecvStatus_FreeRecvStatus_All();
		return 0x02;
	}

	gp_recvalloc	= p_recvs;
	gi_recvalloc_now	= 0;

	gp_recv_resume_start	= NULL;
	gi_recv_resume_max		= FD_SETSIZE;

	gp_recv_sockets_start	= NULL;
	gp_recv_sockets_end		= NULL;

	return 0x00;
}


EXTERN_SERVER_RECVSTATUS
int
	Drd64_Server_RecvStatus_Term(
		void )
{
	Drd64_Server_RecvStatus_FreeRecvStatus_All();

	return 0x00;
}


EXTERN_SERVER_RECVSTATUS
Drd64_Server_RecvStatus *
	Drd64_Server_RecvStatus_AllocRecvStatus(
		int	i_fds,
		int	i_alloc_units )
{
	int		i_cnt;
	Drd64_Server_RecvStatus		*p_recv;
	Drd64_Server_RecvStatus		*p_temp;

	p_recv	= NULL;

	/* Check No-Use RecvStatus --- */
	if( gi_recvalloc_now >= gi_recvalloc_max )	{
		/* Search No-Use RecvStatus --- */
		for( i_cnt = 0; i_cnt < gi_recvalloc_max; i_cnt++ )		{
			if( -1 == (gp_recvalloc + i_cnt)->i_recvstatus_id )	{
				p_recv	= (gp_recvalloc + i_cnt);
				break;
			}
		}

		/* Realloc RecvStatus --- */
		if( NULL == p_recv )	{
			p_temp
				= Drd64_Server_RecvStatus_AllocRecvStatus_Unit(
						i_alloc_units );
			if( NULL == p_temp )	{ return NULL; }

			gp_recvalloc	= p_temp;
			p_recv	= gp_recvalloc + gi_recvalloc_now++;
		}
	}
	else	{
		p_recv	= gp_recvalloc + gi_recvalloc_now++;
	}

	/* Set RecvStatus Init. Param ---*/
	p_recv->i_recvstatus_id	= i_fds;
	p_recv->i_fds_id		= i_fds;
	*(gpp_recvstat + i_fds)	= p_recv;



	if( i_fds + 1 > gi_recvstat_max )
		{ gi_recvstat_max	= i_fds + 1; }

	return p_recv;
}


void
	Drd64_Server_RecvStatus_FreeRecvStatus(
		Drd64_Server_RecvStatus	*p_recv )
{
	assert( NULL != p_recv );

	p_recv->pv_recv_before		= NULL;
	p_recv->pv_recv_next		= NULL;
	
	p_recv->i_recvstatus_id		= -1;
	p_recv->i_fds_id			= -1;

	return;
}


EXTERN_SERVER_RECVSTATUS
void
	Drd64_Server_RecvStatus_CloseRecvStatus(
		int i_fds )
{
	int		i_cnt;
	Drd64_Server_RecvStatus	*p_recv_now;
	Drd64_Server_RecvStatus	*p_recv_temp;

	p_recv_now	= *(gpp_recvstat + i_fds);

	if( NULL != p_recv_now )	{
		*(gpp_recvstat + i_fds)	= NULL;

		if( i_fds + 1 == gi_recvstat_max )	{
			for( i_cnt = i_fds+1; i_cnt > 0; i_cnt-- )		{
				p_recv_temp	= *(gpp_recvstat + i_cnt);
				if( NULL != p_recv_temp )	{
					gi_recvstat_max	= i_cnt + 1;
					break;
				}
			}

			if( 0 == i_cnt ) { gi_recvstat_max	= 0; }
		}

		Drd64_Server_RecvStatus_FreeRecvStatus( p_recv_now );
	}
	
	return;
}


EXTERN_SERVER_RECVSTATUS
int
	Drd64_Server_RecvStatus_PushResumeChain(
		int		i_fds,
		int		i_alloc_units )
{
	int		i_cnt;
	int		i_recv_id;
	Drd64_Server_RecvStatus		*p_recv_self;
	Drd64_Server_RecvStatus		*p_recv_new;
	Drd64_Server_RecvStatus		*p_recv_before;

	i_recv_id	= -1;

	/* Get Self RecvStatus --- */
	p_recv_self	= *(gpp_recvstat + i_fds);
	if( NULL == p_recv_self )	{
		return -1;
	}

	/* Get New RecvStatus --- */
	p_recv_new
		= Drd64_Server_RecvStatus_AllocRecvStatus(
					i_fds, i_alloc_units );
	if( NULL == p_recv_new )	{
		return -2;
	}

	/* Push & Chain RecvStatus ---*/
	/* new */
	if( NULL == gp_recv_resume_start )	{
		gp_recv_resume_start		= p_recv_self;
		gp_recv_resume_end			= p_recv_self;
		p_recv_self->pv_recv_before	= NULL;
		p_recv_self->pv_recv_next	= NULL;
		i_cnt = gi_recv_resume_max;
	}
	else	{
		i_cnt	= FD_SETSIZE;
		while(( NULL != *(gpp_recvstat + i_cnt) )
					&& ( i_cnt < gi_recv_resume_max ))	{ i_cnt++; }
		assert( NULL == *(gpp_recvstat + i_cnt) );
		
		p_recv_before	= gp_recv_resume_end;
		assert( NULL != p_recv_before );
		
		p_recv_self->pv_recv_before	= (void *)p_recv_before;
		p_recv_self->pv_recv_next	= (void *)p_recv_before->pv_recv_next;
		p_recv_before->pv_recv_next	= (void *)p_recv_self;
		gp_recv_resume_end			= p_recv_self;
	}

	i_recv_id	= i_cnt;
	p_recv_self->i_recvstatus_id	= i_cnt;
	*(gpp_recvstat + p_recv_self->i_recvstatus_id)	= p_recv_self;
	if( gi_recv_resume_max == i_cnt )	{
		gi_recv_resume_max++;
	}
	
	return i_recv_id;
}


EXTERN_SERVER_RECVSTATUS
int
	Drd64_Server_RecvStatus_DeleteResumeChain(
		int		i_recv_id )
{
	Drd64_Server_RecvStatus *p_recv_self;
	Drd64_Server_RecvStatus *p_recv_before;
	Drd64_Server_RecvStatus *p_recv_next;


	p_recv_self	= *(gpp_recvstat + i_recv_id);
	if( NULL == p_recv_self )	{
		return 0x01;
	}	

	p_recv_before	= (Drd64_Server_RecvStatus *)p_recv_self->pv_recv_before;
	p_recv_next		= (Drd64_Server_RecvStatus *)p_recv_self->pv_recv_next;

	if( NULL != p_recv_before )	{
		p_recv_before->pv_recv_next	= (void *)p_recv_next;
	}

	if( NULL != p_recv_next )	{
		p_recv_next->pv_recv_before	= (void *)p_recv_before;
	}

	if( gp_recv_resume_end == p_recv_self )		{
		gp_recv_resume_end		= p_recv_before;
	}

	if( p_recv_self->i_recvstatus_id == (gi_recv_resume_max - 1) )	{
		gi_recv_resume_max--;
	}

	if( FD_SETSIZE == gi_recv_resume_max )	{
		gp_recv_resume_start	= NULL;
		gp_recv_resume_end		= NULL;
	}

	*(gpp_recvstat + i_recv_id)		= NULL;

	Drd64_Server_RecvStatus_FreeRecvStatus( p_recv_self );

	return 0x00;
}


EXTERN_SERVER_RECVSTATUS
int
	Drd64_Server_RecvStatus_AddSocketsChain(
		Drd64_Server_RecvStatus *p_recv )
{
	Drd64_Server_RecvStatus	*p_before;

	if( NULL == p_recv )	{ return 0x01; }

	p_before	= gp_recv_sockets_end;
	
	p_recv->pv_recv_before	= (void *)p_before;
	if( NULL != p_before )
		{ p_before->pv_recv_next	= (void *)p_recv; }
	else
		{ gp_recv_sockets_start	= p_recv; }

	gp_recv_sockets_end		= p_recv;
	
	return 0x00;
}


EXTERN_SERVER_RECVSTATUS
int
	Drd64_Server_RecvStatus_DeleteSocketsChain(
		Drd64_Server_RecvStatus *p_recv )
{
	Drd64_Server_RecvStatus	*p_before;
	Drd64_Server_RecvStatus	*p_next;

	if( NULL == p_recv )	{ return -1; }

	p_before	= (Drd64_Server_RecvStatus *)p_recv->pv_recv_before;
	p_next		= (Drd64_Server_RecvStatus *)p_recv->pv_recv_next;

	if( NULL != p_before )
		{ p_before->pv_recv_next	= (void *)p_next; }
	if( NULL != p_next )
		{ p_next->pv_recv_before	= (void *)p_before; }

	if( p_recv == gp_recv_sockets_start )
		{ gp_recv_sockets_start	= p_next; }	
	if( p_recv == gp_recv_sockets_end )
		{ gp_recv_sockets_end	= p_before; }

	p_recv->pv_recv_next	= NULL;
	p_recv->pv_recv_before	= NULL;
	
	return 0x00;
}


EXTERN_SERVER_RECVSTATUS
void
	Drd64_Server_RecvStatus_InitRecvStatus(
		Drd64_Server_RecvStatus *p_recv,
		int	i_socket )
{
	assert( NULL != p_recv );

	p_recv->i_read_phase		= DRD64_SERVER_RECVSTATUS_PHASE_HEADER;
	p_recv->b_recv_status		= DRD64_SERVER_RECVSTATUS_STATUS_READ;
	p_recv->i_command_status	= DRD64_SERVER_CMDSTATUS_STATUS_NORMAL;
	p_recv->i_remain_bytes		= sizeof( Drd64_PacketHeader );
	p_recv->pv_resume			= p_recv->pv_buf;
	p_recv->pv_recv_before		= NULL;
	p_recv->pv_recv_next		= NULL;
	p_recv->pv_cinfo_connection	= NULL;
	p_recv->i_fds_id			= i_socket;

	return;
}


EXTERN_SERVER_RECVSTATUS
int
	Drd64_Server_RecvStatus_SetConnectionInfoPointer(
		Drd64_Server_RecvStatus *p_recv_now,
		void *pv_cinfo )
{
	int		i_socket;
	Drd64_Server_RecvStatus *p_recv_socket;

	assert( NULL != p_recv_now );

	p_recv_now->pv_cinfo_connection		= pv_cinfo;

	p_recv_socket	= *(gpp_recvstat + p_recv_now->i_fds_id);
	if(( NULL != p_recv_socket ) && ( p_recv_socket != p_recv_now ))	{
		assert( NULL == p_recv_socket->pv_cinfo_connection );
		p_recv_socket->pv_cinfo_connection	= pv_cinfo;
	}
	
	return 0x00;
}


EXTERN_SERVER_RECVSTATUS
Drd64_Server_RecvStatus *
	Drd64_Server_RecvStatus_GetRecvStatus(
		int		i_recv_id )
{
	return *(gpp_recvstat + i_recv_id);
}


EXTERN_SERVER_RECVSTATUS
int
	Drd64_Server_RecvStatus_GetSocketID(
		int		i_recv_id )
{
	Drd64_Server_RecvStatus		*p_recv;
	p_recv	= *(gpp_recvstat + i_recv_id);
	
	if( NULL == p_recv )	{ return -1; }

	return p_recv->i_fds_id;
}


EXTERN_SERVER_RECVSTATUS
int
	Drd64_Server_RecvStatus_GetPacketStatus(
		int		i_recv_id )
{
	Drd64_Server_RecvStatus		*p_recv;
	p_recv	= *(gpp_recvstat + i_recv_id);
	
	if( NULL == p_recv )	{ return -1; }

	return p_recv->b_recv_status;
}


EXTERN_SERVER_RECVSTATUS
int
	Drd64_Server_RecvStatus_GetCmdStatus(
		int		i_recv_id )
{
	Drd64_Server_RecvStatus		*p_recv;
	p_recv	= *(gpp_recvstat + i_recv_id);
	
	if( NULL == p_recv )	{ return -1; }

	return p_recv->i_command_status;
}


EXTERN_SERVER_RECVSTATUS
int
	Drd64_Server_RecvStatus_SetCmdStatus(
		int		i_recv_id,
		int		i_command_status )
{
	Drd64_Server_RecvStatus		*p_recv;
	p_recv	= *(gpp_recvstat + i_recv_id);
	
	if( NULL == p_recv )	{ return -1; }

	p_recv->i_command_status	= i_command_status;

	return p_recv->i_command_status;
}


EXTERN_SERVER_RECVSTATUS
int
	Drd64_Server_RecvStatus_GetRecvStatMax(
		void )
{
	return gi_recvstat_max;
}


EXTERN_SERVER_RECVSTATUS
Drd64_Server_RecvStatus *
	Drd64_Server_RecvStatus_GetResumeChainStart(
		void )
{
	return gp_recv_resume_start;
}


EXTERN_SERVER_RECVSTATUS
Drd64_Server_RecvStatus *
	Drd64_Server_RecvStatus_GetSocketsChainStart(
		void )
{
	return gp_recv_sockets_start;
}


/* EOF of drd64_.c ----------------------------------- */
