/*DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64

                         D r . D e a m o n  6 4
                        for INTEL64(R), AMD64(R)
	
   Copyright(C) 2007-2009 Koine Yuusuke(koinec). All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64DrDeAmOn64*/

/* File Info -----------------------------------------------------------
File: drd64_.h
Function: Header 
Comment: 
----------------------------------------------------------------------*/

#ifndef DRD64_HEADER_SERVER_RECVSTATUS
#define DRD64_HEADER_SERVER_RECVSTATUS

#include"../include/drd64_types.h"

#define	DRD64_SERVER_RECVSTATUS_PHASE_POLL		0x00
#define	DRD64_SERVER_RECVSTATUS_PHASE_HEADER	0x01
#define	DRD64_SERVER_RECVSTATUS_PHASE_DATA		0x02
#define	DRD64_SERVER_RECVSTATUS_PHASE_END		0x03

#define	DRD64_SERVER_RECVSTATUS_STATUS_READ		0x00
#define	DRD64_SERVER_RECVSTATUS_STATUS_STOP		0x01
#define	DRD64_SERVER_RECVSTATUS_STATUS_RESUME	0x02
#define	DRD64_SERVER_RECVSTATUS_STATUS_ERROR	0xff

#define	DRD64_SERVER_CMDSTATUS_STATUS_NORMAL	0x00


typedef struct {
	int		i_recvstatus_id;
	int		i_fds_id;
	void	*pv_buf;
	void	*pv_resume;
	int		i_remain_bytes;
	int		i_read_phase;

	Byte	b_recv_status;
	int		i_command_status;	/* Cmd Proc. Use Area - for Cmd Status */

	void	*pv_recv_before;
	void	*pv_recv_next;
	void	*pv_cinfo_connection;
} Drd64_Server_RecvStatus;

#ifdef DRD64_SRC_SERVER_RECVSTATUS
	#define	EXTERN_SERVER_RECVSTATUS
#else
	#define	EXTERN_SERVER_RECVSTATUS	extern
#endif

EXTERN_SERVER_RECVSTATUS
	int
		Drd64_Server_RecvStatus_Init(
			int i_alloc_units );

EXTERN_SERVER_RECVSTATUS
	int
		Drd64_Server_RecvStatus_Term(
			void );

EXTERN_SERVER_RECVSTATUS
	Drd64_Server_RecvStatus *
		Drd64_Server_RecvStatus_AllocRecvStatus(
			int i_fds,
			int i_alloc_units );

EXTERN_SERVER_RECVSTATUS
	void
		Drd64_Server_RecvStatus_CloseRecvStatus(
			int i_fds );


EXTERN_SERVER_RECVSTATUS
	int	
		Drd64_Server_RecvStatus_PushResumeChain(
			int	i_fds,
			int	i_alloc_units );

EXTERN_SERVER_RECVSTATUS
	int
		Drd64_Server_RecvStatus_DeleteResumeChain(
			int	i_recv_id );

EXTERN_SERVER_RECVSTATUS
	int
		Drd64_Server_RecvStatus_AddSocketsChain(
			Drd64_Server_RecvStatus	*p_recv );

EXTERN_SERVER_RECVSTATUS
	int
		Drd64_Server_RecvStatus_DeleteSocketsChain(
			Drd64_Server_RecvStatus	*p_recv );


EXTERN_SERVER_RECVSTATUS
	void
		Drd64_Server_RecvStatus_InitRecvStatus(
			Drd64_Server_RecvStatus *p_recv,
			int	i_socket );

EXTERN_SERVER_RECVSTATUS
	int
		Drd64_Server_RecvStatus_SetConnectionInfoPointer(
			Drd64_Server_RecvStatus *p_recv_now,
			void	*pv_cinfo );

EXTERN_SERVER_RECVSTATUS
	Drd64_Server_RecvStatus *
		Drd64_Server_RecvStatus_GetRecvStatus(
			int	i_recv_id );

EXTERN_SERVER_RECVSTATUS
	int
		Drd64_Server_RecvStatus_GetSocketID(
			int	i_recv_id );

EXTERN_SERVER_RECVSTATUS
	int
   		Drd64_Server_RecvStatus_GetPacketStatus(
        	int     i_recv_id );

EXTERN_SERVER_RECVSTATUS
	int
    	Drd64_Server_RecvStatus_GetCmdStatus(
        	int     i_recv_id );

EXTERN_SERVER_RECVSTATUS
	int
    	Drd64_Server_RecvStatus_SetCmdStatus(
        	int     i_recv_id,
        	int     i_packet_status );


EXTERN_SERVER_RECVSTATUS
	int
		Drd64_Server_RecvStatus_GetRecvStatMax(
			void );

EXTERN_SERVER_RECVSTATUS
	Drd64_Server_RecvStatus *
		Drd64_Server_RecvStatus_GetResumeChainStart(
			void );

EXTERN_SERVER_RECVSTATUS
	Drd64_Server_RecvStatus *
		Drd64_Server_RecvStatus_GetSocketsChainStart(
			void );



#endif	/* DRD64_HEADER_XXX */

/* EOF of drd64_.h ----------------------------------- */
